/*
 * Decompiled with CFR 0.152.
 */
package io.github.xiewuzhiying.vs_addition.mixin.minecraft;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import io.github.xiewuzhiying.vs_addition.context.EntityShipCollisionDisabler;
import io.github.xiewuzhiying.vs_addition.util.ShipUtilsKt;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4d;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.core.api.ships.LoadedShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Pseudo
@Mixin(value={Entity.class})
public abstract class MixinEntity
implements EntityShipCollisionDisabler {
    @Shadow
    private Level f_19853_;
    @Unique
    private LongSet vs_addition$disabledCollisionBodies = new LongOpenHashSet();

    @Shadow
    public abstract float m_146908_();

    @Shadow
    public abstract void m_146922_(float var1);

    @Shadow
    public abstract Level m_9236_();

    @Shadow
    public abstract double m_20185_();

    @Shadow
    public abstract double m_20186_();

    @Shadow
    public abstract double m_20189_();

    @Inject(method={"removeVehicle"}, at={@At(value="HEAD")})
    private void addShipYaw(CallbackInfo ci) {
        LoadedShip ship = VSGameUtilsKt.getShipMountedTo((Entity)((Entity)this));
        if (ship == null) {
            return;
        }
        Matrix4d matrix = (Matrix4d)ship.getTransform().getShipToWorld();
        double yaw = Math.toDegrees(Math.atan2(-matrix.getRow((int)0, (Vector3d)new Vector3d()).z, matrix.getRow((int)2, (Vector3d)new Vector3d()).z));
        this.m_146922_((float)((double)this.m_146908_() + yaw) % 360.0f);
    }

    @Inject(method={"startRiding(Lnet/minecraft/world/entity/Entity;Z)Z"}, at={@At(value="RETURN")})
    private void subShipYaw(Entity vehicle, boolean force, CallbackInfoReturnable<Boolean> cir) {
        if (!this.f_19853_.f_46443_ || !((Boolean)cir.getReturnValue()).booleanValue()) {
            return;
        }
        LoadedShip ship = VSGameUtilsKt.getShipMountedTo((Entity)((Entity)this));
        if (ship == null) {
            return;
        }
        Matrix4d matrix = (Matrix4d)ship.getTransform().getShipToWorld();
        double yaw = Math.toDegrees(Math.atan2(-matrix.getRow((int)0, (Vector3d)new Vector3d()).z, matrix.getRow((int)2, (Vector3d)new Vector3d()).z));
        this.m_146922_((float)((double)this.m_146908_() - yaw) % 360.0f);
    }

    @ModifyExpressionValue(method={"move"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getOnPosLegacy()Lnet/minecraft/core/BlockPos;")})
    private BlockPos getPosStandingOnFromShipsLegacy(BlockPos original) {
        BlockPos pos = ShipUtilsKt.getPosStandingOnFromShips(this.f_19853_, (Vector3dc)new Vector3d(this.m_20185_(), this.m_20186_() - 0.2, this.m_20189_()));
        return pos == null ? original : pos;
    }

    @Override
    public LongSet getDisabledCollisionBodies() {
        return this.vs_addition$disabledCollisionBodies;
    }

    @Override
    public void setDisabledCollisionBodies(@NotNull LongSet disabledCollisionBodies) {
        this.vs_addition$disabledCollisionBodies = disabledCollisionBodies;
    }

    @Override
    public void addDisabledCollisionBody(long id) {
        this.vs_addition$disabledCollisionBodies.add(id);
    }

    @Override
    public void removeDisabledCollisionBody(long id) {
        this.vs_addition$disabledCollisionBodies.remove(id);
    }
}

