/*
 * Decompiled with CFR 0.152.
 */
package io.github.xiewuzhiying.vs_addition.mixin.vs_clockwork.flapBearing;

import com.simibubi.create.content.contraptions.ControlledContraptionEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.redstone.link.LinkBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import io.github.xiewuzhiying.vs_addition.compats.create.content.redstone.link.DualLinkBehaviour;
import io.github.xiewuzhiying.vs_addition.compats.vs_clockwork.behaviour.flap_bearing.FlapBearingLinkFrequencySlot;
import io.github.xiewuzhiying.vs_addition.compats.vs_clockwork.behaviour.flap_bearing.FlapBearingLinkFrequencySlotNegative;
import io.github.xiewuzhiying.vs_addition.mixinducks.vs_clockwork.flap_bearing.FlapBearingBlockEntityMixinDuck;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.clockwork.content.contraptions.flap.FlapBearingBlock;
import org.valkyrienskies.clockwork.content.contraptions.flap.FlapBearingBlockEntity;

@Pseudo
@Mixin(value={FlapBearingBlockEntity.class})
public abstract class MixinFlapBearingBlockEntity
extends KineticBlockEntity
implements FlapBearingBlockEntityMixinDuck {
    @Shadow(remap=false)
    private BlockPos redstonePos;
    @Shadow(remap=false)
    private float clientAngleDiff;
    @Shadow(remap=false)
    @Nullable
    private ControlledContraptionEntity flap;
    @Unique
    protected LinkBehaviour link_positive;
    @Unique
    protected DualLinkBehaviour link_negative;
    @Unique
    protected int receivedSignalPositive;
    @Unique
    protected int receivedSignalNegative;
    @Unique
    protected boolean receivedSignalPositiveActive = false;
    @Unique
    protected boolean receivedSignalNegativeActive = false;
    @Unique
    protected float lockedFlapAngle = 0.0f;
    @Unique
    protected boolean isLocked = false;

    public MixinFlapBearingBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    @Inject(method={"addBehaviours"}, at={@At(value="RETURN")}, remap=false)
    private void addBehaviours(List<BlockEntityBehaviour> behaviours, CallbackInfo ci) {
        this.createLink();
        behaviours.add((BlockEntityBehaviour)this.link_positive);
        behaviours.add(this.link_negative);
    }

    @Inject(method={"getPower"}, at={@At(value="RETURN")}, remap=false, cancellable=true)
    private void getPower(Level worldIn, BlockPos pos, CallbackInfoReturnable<Integer> cir) {
        if (Math.max(this.receivedSignalPositive, this.receivedSignalNegative) > (Integer)cir.getReturnValue()) {
            boolean isNegative = this.receivedSignalPositive <= this.receivedSignalNegative;
            Direction direction = (Direction)worldIn.m_8055_(pos).m_61143_((Property)FlapBearingBlock.FACING);
            Direction.Axis axis = direction.m_122434_();
            if (axis.m_122479_()) {
                Direction.Axis relativeAxis = direction.m_122427_().m_122434_();
                this.redstonePos = pos.m_5487_(relativeAxis, (isNegative ? -1 : 1) * -direction.m_122436_().m_123304_(axis));
            } else {
                this.redstonePos = pos.m_5487_(Direction.Axis.X, isNegative ? -1 : 1);
            }
            cir.setReturnValue((Object)(isNegative ? this.receivedSignalNegative : this.receivedSignalPositive));
        }
    }

    @Inject(method={"getFlapSpeed"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private void setReturnValue(CallbackInfoReturnable<Float> cir) {
        if (this.f_58857_.f_46443_) {
            cir.setReturnValue((Object)Float.valueOf(this.clientAngleDiff));
        }
    }

    @Inject(method={"lazyTick"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    public void lazyTick(CallbackInfo ci) {
        ci.cancel();
        super.lazyTick();
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/kinetics/base/KineticBlockEntity;tick()V")}, remap=false)
    public void sendData(CallbackInfo ci) {
        if (this.flap != null) {
            Level var10000 = this.f_58857_;
            Intrinsics.checkNotNull((Object)var10000);
            if (!var10000.f_46443_) {
                this.sendData();
            }
        }
    }

    @Inject(method={"getFlapTarget"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void getFlapTarget(boolean negativeActivated, boolean positiveActivated, CallbackInfoReturnable<Float> cir) {
        if (this.isLocked) {
            cir.setReturnValue((Object)Float.valueOf(this.lockedFlapAngle));
        }
    }

    @Override
    public void setLockedFlapAngle(float angle) {
        this.lockedFlapAngle = angle;
    }

    @Override
    public float getLockedFlapAngle() {
        return this.lockedFlapAngle;
    }

    @Override
    public void setIsLocked(boolean bl) {
        this.isLocked = bl;
    }

    @Override
    public boolean getIsLocked() {
        return this.isLocked;
    }

    @Unique
    protected void createLink() {
        Pair slots_positive = ValueBoxTransform.Dual.makeSlots(FlapBearingLinkFrequencySlot::new);
        this.link_positive = LinkBehaviour.receiver((SmartBlockEntity)this, (Pair)slots_positive, this::setSignalPositive);
        Pair slots_negative = ValueBoxTransform.Dual.makeSlots(FlapBearingLinkFrequencySlotNegative::new);
        this.link_negative = DualLinkBehaviour.receiver((SmartBlockEntity)this, (Pair<ValueBoxTransform, ValueBoxTransform>)slots_negative, this::setSignalNegative);
    }

    @Unique
    public void setSignalPositive(int power) {
        this.receivedSignalPositive = power;
        this.receivedSignalPositiveActive = this.receivedSignalPositive != 0;
    }

    @Unique
    public void setSignalNegative(int power) {
        this.receivedSignalNegative = power;
        this.receivedSignalNegativeActive = this.receivedSignalNegative != 0;
    }
}

