/*
 * Decompiled with CFR 0.152.
 */
package io.github.xiewuzhiying.vs_addition.mixin.xaeros_minimap.client;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import xaero.common.minimap.render.MinimapRenderer;

@Restriction(require={@Condition(value="xaerominimap")})
@Pseudo
@Mixin(value={MinimapRenderer.class})
public abstract class MixinMinimapRenderer {
    @Shadow
    protected Minecraft mc;
    @Unique
    @Nullable
    private Matrix4dc vs_addition$prevShipTransform = null;
    @Unique
    private double vs_addition$shipYawOffset = 0.0;

    @WrapOperation(method={"renderMinimap"}, at={@At(value="INVOKE", target="Lxaero/common/minimap/render/MinimapRenderer;getRenderAngle(Z)D")}, require=0, remap=false)
    private double vs_addition$modifyRenderAngle(MinimapRenderer instance, boolean lockedNorth, Operation<Double> original) {
        ClientShip ship = this.vs_addition$getMountedShip();
        if (lockedNorth) {
            this.vs_addition$resetShipData();
            return (Double)original.call(new Object[]{instance, true});
        }
        if (ship != null) {
            this.vs_addition$updateShipData(ship);
            double angle = (Double)original.call(new Object[]{instance, false}) - this.vs_addition$shipYawOffset;
            double d = this.vs_addition$normalizeAngle(angle);
        }
        return (Double)original.call(new Object[]{instance, false});
    }

    @Inject(method={"getActualAngle"}, at={@At(value="RETURN")}, cancellable=true, remap=false)
    private void vs_addition$modifyActualAngle(CallbackInfoReturnable<Double> cir) {
        ClientShip ship = this.vs_addition$getMountedShip();
        if (ship != null) {
            double originalAngle = cir.getReturnValueD();
            double newAngle = originalAngle - this.vs_addition$shipYawOffset;
            double normalizedAngle = this.vs_addition$normalizeAngle(newAngle);
            cir.setReturnValue((Object)normalizedAngle);
        }
    }

    @ModifyExpressionValue(method={"renderMinimap"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getViewYRot(F)F")}, remap=true)
    private float vs_addition$modifyArrowAngle(float originalAngle) {
        ClientShip ship = this.vs_addition$getMountedShip();
        if (ship != null) {
            float newAngle = (float)((double)originalAngle - this.vs_addition$shipYawOffset);
            float f = (float)this.vs_addition$normalizeAngle(newAngle);
        }
        return originalAngle;
    }

    @Unique
    private ClientShip vs_addition$getMountedShip() {
        return (ClientShip)VSGameUtilsKt.getShipMountedTo((Entity)this.mc.f_91063_.m_109153_().m_90592_());
    }

    @Unique
    private void vs_addition$updateShipData(ClientShip ship) {
        Matrix4d currentTransform = new Matrix4d(ship.getRenderTransform().getShipToWorld());
        if (this.vs_addition$prevShipTransform == null) {
            this.vs_addition$prevShipTransform = new Matrix4d((Matrix4dc)currentTransform);
            return;
        }
        Matrix4d relativeTransform = new Matrix4d(this.vs_addition$prevShipTransform).invert().mul((Matrix4dc)currentTransform);
        double yawChangeRad = Math.atan2(-relativeTransform.m20(), relativeTransform.m22());
        double yawChangeDeg = Math.toDegrees(yawChangeRad);
        this.vs_addition$shipYawOffset += yawChangeDeg;
        this.vs_addition$shipYawOffset = this.vs_addition$normalizeAngle(this.vs_addition$shipYawOffset);
        this.vs_addition$prevShipTransform = new Matrix4d((Matrix4dc)currentTransform);
    }

    @Unique
    private void vs_addition$resetShipData() {
        this.vs_addition$prevShipTransform = null;
        this.vs_addition$shipYawOffset = 0.0;
    }

    @Unique
    private double vs_addition$normalizeAngle(double angle) {
        if ((angle %= 360.0) > 180.0) {
            angle -= 360.0;
        }
        if (angle <= -180.0) {
            angle += 360.0;
        }
        return angle;
    }
}

