/*
 * Decompiled with CFR 0.152.
 */
package io.github.xiewuzhiying.vs_addition.compats.computercraft.peripheral;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.eureka.EurekaConfig;
import org.valkyrienskies.eureka.blockentity.ShipHelmBlockEntity;
import org.valkyrienskies.eureka.ship.EurekaShipControl;
import org.valkyrienskies.eureka.util.ShipAssembler;
import org.valkyrienskies.mod.api.SeatedControllingPlayer;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0016\u001a\u00020\u0015H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\u0015H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0017J\u000f\u0010\u0019\u001a\u00020\u0015H\u0007\u00a2\u0006\u0004\b\u0019\u0010\u0017J\u0017\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001aH\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001e\u001a\u00020\u0015H\u0007\u00a2\u0006\u0004\b\u001e\u0010\u0017J\u000f\u0010 \u001a\u00020\u001fH\u0007\u00a2\u0006\u0004\b \u0010!J\u000f\u0010\"\u001a\u00020\u001fH\u0007\u00a2\u0006\u0004\b\"\u0010!J\u000f\u0010#\u001a\u00020\u001fH\u0007\u00a2\u0006\u0004\b#\u0010!J\u000f\u0010$\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b$\u0010%J\u000f\u0010&\u001a\u00020\u001fH\u0007\u00a2\u0006\u0004\b&\u0010!J\u000f\u0010(\u001a\u00020'H\u0002\u00a2\u0006\u0004\b(\u0010)R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010*\u001a\u0004\b+\u0010\rR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010,\u001a\u0004\b-\u0010.R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010/\u001a\u0004\b0\u00101R\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u00102\u001a\u0004\b3\u00104\u00a8\u00065"}, d2={"Lio/github/xiewuzhiying/vs_addition/compats/computercraft/peripheral/ShipHelmPeripheral;", "Ldan200/computercraft/api/peripheral/IPeripheral;", "", "peripheralType", "Lorg/valkyrienskies/eureka/blockentity/ShipHelmBlockEntity;", "tileEntity", "Lnet/minecraft/world/level/Level;", "level", "Lnet/minecraft/core/BlockPos;", "blockPos", "<init>", "(Ljava/lang/String;Lorg/valkyrienskies/eureka/blockentity/ShipHelmBlockEntity;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)V", "getType", "()Ljava/lang/String;", "p0", "", "equals", "(Ldan200/computercraft/api/peripheral/IPeripheral;)Z", "", "getTarget", "()Ljava/lang/Object;", "", "disassemble", "()V", "assemble", "align", "Ldan200/computercraft/api/lua/IArguments;", "args", "move", "(Ldan200/computercraft/api/lua/IArguments;)V", "fakePlayerKill", "", "getBalloonAmount", "()I", "getAnchorAmount", "getActiveAnchorAmount", "areAnchorsActive", "()Z", "getShipHelmAmount", "Lorg/valkyrienskies/eureka/ship/EurekaShipControl;", "check", "()Lorg/valkyrienskies/eureka/ship/EurekaShipControl;", "Ljava/lang/String;", "getPeripheralType", "Lorg/valkyrienskies/eureka/blockentity/ShipHelmBlockEntity;", "getTileEntity", "()Lorg/valkyrienskies/eureka/blockentity/ShipHelmBlockEntity;", "Lnet/minecraft/world/level/Level;", "getLevel", "()Lnet/minecraft/world/level/Level;", "Lnet/minecraft/core/BlockPos;", "getBlockPos", "()Lnet/minecraft/core/BlockPos;", "vs_addition_continue"})
public final class ShipHelmPeripheral
implements IPeripheral {
    @NotNull
    private final String peripheralType;
    @NotNull
    private final ShipHelmBlockEntity tileEntity;
    @NotNull
    private final Level level;
    @NotNull
    private final BlockPos blockPos;

    public ShipHelmPeripheral(@NotNull String peripheralType, @NotNull ShipHelmBlockEntity tileEntity, @NotNull Level level, @NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)peripheralType, (String)"peripheralType");
        Intrinsics.checkNotNullParameter((Object)tileEntity, (String)"tileEntity");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        this.peripheralType = peripheralType;
        this.tileEntity = tileEntity;
        this.level = level;
        this.blockPos = blockPos;
    }

    @NotNull
    public final String getPeripheralType() {
        return this.peripheralType;
    }

    @NotNull
    public final ShipHelmBlockEntity getTileEntity() {
        return this.tileEntity;
    }

    @NotNull
    public final Level getLevel() {
        return this.level;
    }

    @NotNull
    public final BlockPos getBlockPos() {
        return this.blockPos;
    }

    @NotNull
    public String getType() {
        return this.peripheralType;
    }

    public boolean equals(@Nullable IPeripheral p0) {
        return p0 == this;
    }

    @NotNull
    public Object getTarget() {
        return this.tileEntity;
    }

    @LuaFunction(mainThread=true)
    public final void disassemble() throws LuaException {
        if (!this.tileEntity.getAssembled()) {
            throw new LuaException("Not assembled yet");
        }
        this.tileEntity.disassemble();
    }

    @LuaFunction(mainThread=true)
    public final void assemble() throws LuaException {
        if (!this.tileEntity.getAssembled()) {
            ServerLevel serverLevel = (ServerLevel)this.level;
            Intrinsics.checkNotNull((Object)serverLevel);
            ServerShip builtShip = ShipAssembler.INSTANCE.collectBlocks(serverLevel, this.blockPos, ShipHelmPeripheral::assemble$lambda$0);
            if (builtShip == null) {
                throw new LuaException("Ship is too big! Max size is" + EurekaConfig.SERVER.getMaxShipBlocks() + "blocks (changable in the config)");
            }
        } else {
            throw new LuaException("Already assembled");
        }
    }

    @LuaFunction
    public final void align() throws LuaException {
        if (!this.tileEntity.getAssembled()) {
            throw new LuaException("Not assembled yet");
        }
        this.tileEntity.align();
    }

    @LuaFunction
    public final void move(@NotNull IArguments args) throws LuaException {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (this.level.m_5776_()) {
            throw new LuaException("client");
        }
        ServerShip serverShip = (ServerShip)VSGameUtilsKt.getShipManagingPos((Level)this.level, (BlockPos)this.blockPos);
        if (serverShip == null) {
            throw new LuaException("No ship");
        }
        ServerShip ship = serverShip;
        if (ship.getAttachment(EurekaShipControl.class) == null) {
            throw new LuaException("Not Eureka ship");
        }
        SeatedControllingPlayer fakePlayer = (SeatedControllingPlayer)ship.getAttachment(SeatedControllingPlayer.class);
        Direction direction = ((Direction)this.level.m_8055_(this.blockPos).m_61143_((Property)BlockStateProperties.f_61374_)).m_122424_();
        if (fakePlayer == null || fakePlayer.getSeatInDirection() != direction) {
            Intrinsics.checkNotNull((Object)direction);
            fakePlayer = new SeatedControllingPlayer(direction);
            ship.saveAttachment(SeatedControllingPlayer.class, (Object)fakePlayer);
        }
        fakePlayer.setLeftImpulse((float)Math.min(Math.max(args.getDouble(0), -1.0), 1.0));
        fakePlayer.setUpImpulse((float)Math.min(Math.max(args.getDouble(1), -1.0), 1.0));
        fakePlayer.setForwardImpulse((float)Math.min(Math.max(args.getDouble(2), -1.0), 1.0));
    }

    @LuaFunction
    public final void fakePlayerKill() {
        if (this.level.m_5776_()) {
            throw new LuaException("client");
        }
        ServerShip serverShip = (ServerShip)VSGameUtilsKt.getShipManagingPos((Level)this.level, (BlockPos)this.blockPos);
        if (serverShip == null) {
            throw new LuaException("No ship");
        }
        ServerShip ship = serverShip;
        ship.saveAttachment(SeatedControllingPlayer.class, null);
    }

    @LuaFunction
    public final int getBalloonAmount() throws LuaException {
        return this.check().getBalloons();
    }

    @LuaFunction
    public final int getAnchorAmount() throws LuaException {
        return this.check().getAnchors();
    }

    @LuaFunction
    public final int getActiveAnchorAmount() throws LuaException {
        return this.check().getAnchorsActive();
    }

    @LuaFunction
    public final boolean areAnchorsActive() throws LuaException {
        return this.check().getAnchorsActive() > 0;
    }

    @LuaFunction
    public final int getShipHelmAmount() throws LuaException {
        return this.check().getHelms();
    }

    private final EurekaShipControl check() {
        if (this.level.m_5776_()) {
            throw new LuaException("client");
        }
        ServerShip serverShip = (ServerShip)VSGameUtilsKt.getShipManagingPos((Level)this.level, (BlockPos)this.blockPos);
        if (serverShip == null) {
            throw new LuaException("No ship");
        }
        ServerShip ship = serverShip;
        EurekaShipControl eurekaShipControl = (EurekaShipControl)ship.getAttachment(EurekaShipControl.class);
        if (eurekaShipControl == null) {
            throw new LuaException("Not Eureka ship");
        }
        EurekaShipControl control = eurekaShipControl;
        return control;
    }

    private static final boolean assemble$lambda$0(BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        return !blockState.m_60795_() && !EurekaConfig.SERVER.getBlockBlacklist().contains(BuiltInRegistries.f_256975_.m_7981_((Object)blockState.m_60734_()).toString());
    }
}

