/*
 * Decompiled with CFR 0.152.
 */
package io.github.xiewuzhiying.vs_addition.mixin.create.kinetics.fan;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.fan.AirCurrent;
import com.simibubi.create.content.kinetics.fan.IAirCurrentSource;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import io.github.xiewuzhiying.vs_addition.compats.create.content.kinetics.fan.AirCurrentUtils;
import io.github.xiewuzhiying.vs_addition.context.conditiontester.EncasedFanConditionTester;
import io.github.xiewuzhiying.vs_addition.util.ConversionUtilsKt;
import io.github.xiewuzhiying.vs_addition.util.ShipUtilsKt;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import kotlin.jvm.functions.Function2;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Restriction(require={@Condition(type=Condition.Type.TESTER, tester=EncasedFanConditionTester.class)})
@Pseudo
@Mixin(value={AirCurrent.class})
public abstract class MixinAirCurrent {
    @Shadow
    public AABB bounds;
    @Shadow(remap=false)
    @Final
    public IAirCurrentSource source;
    @Shadow
    public Direction direction;
    @Shadow(remap=false)
    public float maxDistance;
    @Shadow(remap=false)
    protected List<Pair<TransportedItemStackHandlerBehaviour, FanProcessingType>> affectedItemHandlers;
    @Unique
    private Vec3 min;
    @Unique
    private Vec3 max;
    @Unique
    private AABB aabb;

    @Shadow(remap=false)
    public abstract FanProcessingType getTypeAt(float var1);

    @ModifyExpressionValue(method={"tickAffectedEntities"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/phys/AABB;intersects(Lnet/minecraft/world/phys/AABB;)Z")})
    private boolean removeAABBDetect(boolean original) {
        return true;
    }

    @WrapOperation(method={"rebuild"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/kinetics/fan/processing/FanProcessingType;getAt(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Lcom/simibubi/create/content/kinetics/fan/processing/FanProcessingType;")})
    private FanProcessingType getAtInWorld(Level level, BlockPos pos, Operation<FanProcessingType> original) {
        BlockPos newPos;
        FanProcessingType type;
        BlockPos newPos2;
        FanProcessingType type2;
        Ship ship = VSGameUtilsKt.getShipManagingPos((Level)level, (BlockPos)this.source.getAirCurrentPos());
        if (ship != null && level.m_8055_(pos).m_60795_() && !(type2 = (FanProcessingType)original.call(new Object[]{level, newPos2 = BlockPos.m_274446_((Position)ConversionUtilsKt.toWorld(pos.m_252807_(), ship))})).equals(null)) {
            return type2;
        }
        Vec3 vec3 = ConversionUtilsKt.toWorld(pos.m_252807_(), level);
        List vector3dList = VSGameUtilsKt.transformToNearbyShipsAndWorld((Level)level, (double)vec3.f_82479_, (double)vec3.f_82480_, (double)vec3.f_82481_, (double)0.25);
        if (!vector3dList.isEmpty() && (ship = VSGameUtilsKt.getShipManagingPos((Level)level, (Vector3dc)((Vector3dc)vector3dList.get(0)))) != null && !(type = (FanProcessingType)original.call(new Object[]{level, newPos = BlockPos.m_274446_((Position)ConversionUtilsKt.toShipyardCoordinates(vec3, ship))})).equals(null)) {
            return type;
        }
        return (FanProcessingType)original.call(new Object[]{level, pos});
    }

    @ModifyExpressionValue(method={"tickAffectedEntities"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/foundation/utility/VecHelper;getCenterOf(Lnet/minecraft/core/Vec3i;)Lnet/minecraft/world/phys/Vec3;")})
    private Vec3 transformPosToWorld(Vec3 original, @Local(argsOnly=true) Level world) {
        return ConversionUtilsKt.toWorld(original, world);
    }

    @WrapOperation(method={"tickAffectedEntities"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V")})
    private void harvester(Entity instance, Vec3 pDeltaMovement, Operation<Void> original, @Local(ordinal=2) float acceleration, @Local Vec3i flow) {
        Level level = this.source.getAirCurrentWorld();
        Ship ship = VSGameUtilsKt.getShipManagingPos((Level)level, (BlockPos)this.source.getAirCurrentPos());
        if (ship != null) {
            Vector3d tempVec = new Vector3d();
            ship.getTransform().getShipToWorld().transformDirection((double)flow.m_123341_(), (double)flow.m_123342_(), (double)flow.m_123343_(), tempVec);
            Vec3 transformedFlow = VectorConversionsMCKt.toMinecraft((Vector3dc)tempVec);
            Vec3 previousMotion = instance.m_20184_();
            double xIn = Mth.m_14008_((double)(transformedFlow.f_82479_ * (double)acceleration - previousMotion.f_82479_), (double)-5.0, (double)5.0);
            double yIn = Mth.m_14008_((double)(transformedFlow.f_82480_ * (double)acceleration - previousMotion.f_82480_), (double)-5.0, (double)5.0);
            double zIn = Mth.m_14008_((double)(transformedFlow.f_82481_ * (double)acceleration - previousMotion.f_82481_), (double)-5.0, (double)5.0);
            original.call(new Object[]{instance, previousMotion.m_82549_(new Vec3(xIn, yIn, zIn).m_82490_(0.125))});
        } else {
            original.call(new Object[]{instance, pDeltaMovement});
        }
    }

    @WrapOperation(method={"findEntities"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getEntities(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/AABB;)Ljava/util/List;")})
    private List<Entity> findWorldEntities(Level instance, Entity entity, AABB originalAABB, Operation<List> original) {
        if (VSGameUtilsKt.getShipManagingPos((Level)this.source.getAirCurrentWorld(), (BlockPos)this.source.getAirCurrentPos()) != null) {
            this.transformWorldAABB();
            return this.clipEntities(instance, this.min, this.max);
        }
        return (List)original.call(new Object[]{instance, entity, originalAABB});
    }

    @Inject(method={"findAffectedHandlers"}, at={@At(value="INVOKE", target="Ljava/util/List;clear()V", shift=At.Shift.AFTER)}, remap=false)
    private void findWorldAffectedHandlers(CallbackInfo ci, @Local Level level, @Local BlockPos start) {
        int limit = (int)(this.maxDistance + 1.0f);
        Ship ship = VSGameUtilsKt.getShipManagingPos((Level)level, (BlockPos)start);
        for (int i = 1; i <= limit; ++i) {
            BlockPos currentPos = start.m_5484_(this.direction, i);
            Vec3 currentVec3 = ConversionUtilsKt.toWorld(currentPos.m_252807_(), level);
            for (Direction direction : Direction.values()) {
                Vec3i vec3i = direction.m_122436_();
                Vec3 directionVec3 = new Vec3((double)vec3i.m_123341_(), (double)vec3i.m_123342_(), (double)vec3i.m_123343_()).m_82490_(1.25);
                if (ship != null) {
                    Vector3d vector3d = new Vector3d();
                    ship.getShipToWorld().transformDirection((double)vec3i.m_123341_(), (double)vec3i.m_123342_(), (double)vec3i.m_123343_(), vector3d);
                    directionVec3 = VectorConversionsMCKt.toMinecraft((Vector3dc)vector3d);
                }
                BlockHitResult blockHitResult = level.m_45547_(new ClipContext(currentVec3, currentVec3.m_82549_(directionVec3), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
                BlockPos pos = blockHitResult.m_82425_();
                FanProcessingType segmentType = this.getTypeAt(i - 1);
                TransportedItemStackHandlerBehaviour behaviour = (TransportedItemStackHandlerBehaviour)BlockEntityBehaviour.get((BlockGetter)level, (BlockPos)pos, (BehaviourType)TransportedItemStackHandlerBehaviour.TYPE);
                if (behaviour == null) continue;
                Ship behaviourShip = VSGameUtilsKt.getShipManagingPos((Level)level, (BlockPos)pos);
                if (behaviourShip != null) {
                    Vector3d upVector3d = new Vector3d();
                    behaviourShip.getShipToWorld().transformDirection(0.0, 1.0, 0.0, upVector3d);
                    Vec3 vec3 = VectorConversionsMCKt.toMinecraft((Vector3dc)upVector3d);
                    double theta = vec3.m_82526_(directionVec3) / (vec3.m_82553_() * directionVec3.m_82553_());
                    double thetaDeg = Math.toDegrees(Math.acos(theta));
                    if (!(thetaDeg > 165.0)) continue;
                    FanProcessingType type = FanProcessingType.getAt((Level)level, (BlockPos)pos);
                    if (type.equals(null)) {
                        type = segmentType;
                    }
                    this.affectedItemHandlers.add((Pair<TransportedItemStackHandlerBehaviour, FanProcessingType>)Pair.of((Object)behaviour, (Object)type));
                    continue;
                }
                if (direction != Direction.DOWN) continue;
                FanProcessingType type = FanProcessingType.getAt((Level)level, (BlockPos)pos);
                if (type.equals(null)) {
                    type = segmentType;
                }
                this.affectedItemHandlers.add((Pair<TransportedItemStackHandlerBehaviour, FanProcessingType>)Pair.of((Object)behaviour, (Object)type));
            }
        }
    }

    @WrapOperation(method={"rebuild"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/kinetics/fan/AirCurrent;getFlowLimit(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;FLnet/minecraft/core/Direction;)F")})
    private float clipLimitWithCatalyst(Level world, BlockPos start, float max, Direction facing, Operation<Float> original) {
        Ship ship = VSGameUtilsKt.getShipManagingPos((Level)world, (BlockPos)start);
        if (ship != null) {
            Vector3d startVec = ship.getTransform().getShipToWorld().transformPosition(new Vector3d((double)start.m_123341_() + 0.5, (double)start.m_123342_() + 0.5, (double)start.m_123343_() + 0.5));
            Vector3d direction = ship.getTransform().getShipToWorld().transformDirection(VectorConversionsMCKt.toJOMLD((Vec3i)facing.m_122436_()));
            startVec.add(direction.x, direction.y, direction.z);
            direction.mul((double)max);
            Vec3 mcStart = VectorConversionsMCKt.toMinecraft((Vector3dc)startVec);
            BlockHitResult result = (BlockHitResult)ShipUtilsKt.clipIncludeShipsWrapper(world, new ClipContext(mcStart, VectorConversionsMCKt.toMinecraft((Vector3dc)startVec.add(direction.x, direction.y, direction.z)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, null), (Function2<? super Level, ? super ClipContext, ? extends HitResult>)((Function2)AirCurrentUtils::clip));
            return (float)result.m_82450_().m_82554_(mcStart);
        }
        BlockPos end = start.m_5484_(facing, (int)max);
        Vec3 centerStart = Vec3.m_82512_((Vec3i)start);
        BlockHitResult result = (BlockHitResult)ShipUtilsKt.clipIncludeShipsWrapper(world, new ClipContext(centerStart.m_82520_((double)facing.m_122429_(), (double)facing.m_122430_(), (double)facing.m_122431_()), Vec3.m_82512_((Vec3i)end), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, null), (Function2<? super Level, ? super ClipContext, ? extends HitResult>)((Function2)AirCurrentUtils::clip));
        return (float)result.m_82450_().m_82554_(centerStart);
    }

    @Unique
    private List<Entity> clipEntities(Level level, Vec3 start, Vec3 end) {
        List entityList = level.m_45933_(null, this.aabb);
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (Entity entity : entityList) {
            Optional hitVec3;
            AABB entityAABB = entity.m_20191_();
            if (entity instanceof ItemEntity) {
                entityAABB.m_82400_(0.75);
            }
            if (!(hitVec3 = entityAABB.m_82371_(start, end)).isPresent()) continue;
            entities.add(entity);
        }
        return entities;
    }

    @Unique
    private void transformWorldAABB() {
        Ship ship = VSGameUtilsKt.getShipManagingPos((Level)this.source.getAirCurrentWorld(), (BlockPos)this.source.getAirCurrentPos());
        if (ship != null) {
            this.min = ConversionUtilsKt.toWorld(this.source.getAirCurrentPos().m_252807_(), ship);
            Vector3d directionVec = ship.getTransform().getShipToWorld().transformDirection(VectorConversionsMCKt.toJOMLD((Vec3i)this.direction.m_122436_())).mul((double)(this.maxDistance + 1.0f));
            this.max = this.min.m_82549_(VectorConversionsMCKt.toMinecraft((Vector3dc)directionVec));
            this.aabb = VSGameUtilsKt.transformAabbToWorld((Level)this.source.getAirCurrentWorld(), (AABB)this.bounds).m_82400_(1.0);
        }
    }
}

