/*
 * Decompiled with CFR 0.152.
 */
package io.github.xiewuzhiying.vs_addition.util.math;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;
import org.joml.primitives.Intersectiond;
import org.joml.primitives.LineSegmentd;
import org.joml.primitives.Planed;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0006\n\u0002\b#\u001a!\u0010\u0006\u001a\u00020\u0005*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a!\u0010\u0006\u001a\u00020\u0005*\u00020\u00012\u0006\u0010\b\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\t\u001a\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b*\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000e\u001a\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00000\u000b*\u00020\n\u00a2\u0006\u0004\b\u000f\u0010\u000e\u001a\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u000b*\u00020\n\u00a2\u0006\u0004\b\u0010\u0010\u000e\u001a\u0011\u0010\u0011\u001a\u00020\u0003*\u00020\n\u00a2\u0006\u0004\b\u0011\u0010\u0012\u001a\u0011\u0010\u0013\u001a\u00020\u0003*\u00020\n\u00a2\u0006\u0004\b\u0013\u0010\u0012\u001a\u0011\u0010\u0014\u001a\u00020\n*\u00020\n\u00a2\u0006\u0004\b\u0014\u0010\u0015\u001a\u0019\u0010\u0016\u001a\u00020\u0005*\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017\u001a\u0019\u0010\u0019\u001a\u00020\u0005*\u00020\u00012\u0006\u0010\u0018\u001a\u00020\n\u00a2\u0006\u0004\b\u0019\u0010\u001a\u001aE\u0010#\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u001b\u00a2\u0006\u0004\b#\u0010$\u001a1\u0010%\u001a\u00020\u0005*\u00020\f2\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u001b\u00a2\u0006\u0004\b%\u0010&\u001a\u0019\u0010%\u001a\u00020\u0005*\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b%\u0010'\u001aE\u0010(\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u001b\u00a2\u0006\u0004\b(\u0010$\u001a1\u0010)\u001a\u00020\u0005*\u00020\f2\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u001b\u00a2\u0006\u0004\b)\u0010&\u001a\u0019\u0010)\u001a\u00020\u0005*\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b)\u0010'\u001aE\u0010*\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u001b\u00a2\u0006\u0004\b*\u0010$\u001a1\u0010+\u001a\u00020\u0005*\u00020\f2\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u001b\u00a2\u0006\u0004\b+\u0010&\u001a\u0019\u0010+\u001a\u00020\u0005*\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b+\u0010'\"\u001a\u0010,\u001a\u00020\u001b8\u0006X\u0086D\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/\"(\u00105\u001a\u00020\u0003*\u00020\u00002\u0006\u00100\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b1\u00102\"\u0004\b3\u00104\"(\u00108\u001a\u00020\u0003*\u00020\u00002\u0006\u00100\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b6\u00102\"\u0004\b7\u00104\"(\u0010=\u001a\u00020\u0003*\u00020\u00012\u0006\u00100\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<\u00a8\u0006>"}, d2={"Lorg/joml/primitives/LineSegmentd;", "Lorg/joml/primitives/Planed;", "plane", "Lorg/joml/Vector3d;", "dest", "", "intersect", "(Lorg/joml/primitives/LineSegmentd;Lorg/joml/primitives/Planed;Lorg/joml/Vector3d;)Z", "line", "(Lorg/joml/primitives/Planed;Lorg/joml/primitives/LineSegmentd;Lorg/joml/Vector3d;)Z", "Lorg/joml/primitives/AABBdc;", "", "Lorg/joml/Vector3dc;", "toPoints", "(Lorg/joml/primitives/AABBdc;)Ljava/util/List;", "toLineSegments", "toPlanes", "getMin", "(Lorg/joml/primitives/AABBdc;)Lorg/joml/Vector3d;", "getMax", "moveToOrigin", "(Lorg/joml/primitives/AABBdc;)Lorg/joml/primitives/AABBdc;", "testPlane", "(Lorg/joml/primitives/AABBdc;Lorg/joml/primitives/Planed;)Z", "aabb", "testAABB", "(Lorg/joml/primitives/Planed;Lorg/joml/primitives/AABBdc;)Z", "", "x", "y", "z", "a", "b", "c", "d", "isPointOnPlane", "(DDDDDDD)Z", "isOnPlane", "(Lorg/joml/Vector3dc;DDDD)Z", "(Lorg/joml/Vector3dc;Lorg/joml/primitives/Planed;)Z", "isPointInFrontOfPlane", "isInFrontOfPlane", "isPointBehindPlane", "isBehindPlane", "epsilon", "D", "getEpsilon", "()D", "value", "getStart", "(Lorg/joml/primitives/LineSegmentd;)Lorg/joml/Vector3d;", "setStart", "(Lorg/joml/primitives/LineSegmentd;Lorg/joml/Vector3d;)V", "start", "getEnd", "setEnd", "end", "getNormal", "(Lorg/joml/primitives/Planed;)Lorg/joml/Vector3d;", "setNormal", "(Lorg/joml/primitives/Planed;Lorg/joml/Vector3d;)V", "normal", "vs_addition_continue"})
public final class MathUtilsKt {
    private static final double epsilon = 1.0E-10;

    public static final double getEpsilon() {
        return epsilon;
    }

    @NotNull
    public static final Vector3d getStart(@NotNull LineSegmentd $this$start) {
        Intrinsics.checkNotNullParameter((Object)$this$start, (String)"<this>");
        return new Vector3d($this$start.aX, $this$start.aY, $this$start.aZ);
    }

    public static final void setStart(@NotNull LineSegmentd $this$start, @NotNull Vector3d value) {
        Intrinsics.checkNotNullParameter((Object)$this$start, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        $this$start.aX = value.x;
        $this$start.aY = value.y;
        $this$start.aZ = value.z;
    }

    @NotNull
    public static final Vector3d getEnd(@NotNull LineSegmentd $this$end) {
        Intrinsics.checkNotNullParameter((Object)$this$end, (String)"<this>");
        return new Vector3d($this$end.bX, $this$end.bY, $this$end.bZ);
    }

    public static final void setEnd(@NotNull LineSegmentd $this$end, @NotNull Vector3d value) {
        Intrinsics.checkNotNullParameter((Object)$this$end, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        $this$end.bX = value.x;
        $this$end.bY = value.y;
        $this$end.bZ = value.z;
    }

    public static final boolean intersect(@NotNull LineSegmentd $this$intersect, @NotNull Planed plane, @NotNull Vector3d dest) {
        Intrinsics.checkNotNullParameter((Object)$this$intersect, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)plane, (String)"plane");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        return Intersectiond.intersectLineSegmentPlane((double)$this$intersect.aX, (double)$this$intersect.aY, (double)$this$intersect.aZ, (double)$this$intersect.bX, (double)$this$intersect.bY, (double)$this$intersect.bZ, (double)plane.a, (double)plane.b, (double)plane.c, (double)plane.d, (Vector3d)dest);
    }

    @NotNull
    public static final Vector3d getNormal(@NotNull Planed $this$normal) {
        Intrinsics.checkNotNullParameter((Object)$this$normal, (String)"<this>");
        return new Vector3d($this$normal.a, $this$normal.b, $this$normal.c);
    }

    public static final void setNormal(@NotNull Planed $this$normal, @NotNull Vector3d value) {
        Intrinsics.checkNotNullParameter((Object)$this$normal, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        $this$normal.a = value.x;
        $this$normal.b = value.y;
        $this$normal.c = value.z;
    }

    public static final boolean intersect(@NotNull Planed $this$intersect, @NotNull LineSegmentd line, @NotNull Vector3d dest) {
        Intrinsics.checkNotNullParameter((Object)$this$intersect, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        return Intersectiond.intersectLineSegmentPlane((double)line.aX, (double)line.aY, (double)line.aZ, (double)line.bX, (double)line.bY, (double)line.bZ, (double)$this$intersect.a, (double)$this$intersect.b, (double)$this$intersect.c, (double)$this$intersect.d, (Vector3d)dest);
    }

    @NotNull
    public static final List<Vector3dc> toPoints(@NotNull AABBdc $this$toPoints) {
        Intrinsics.checkNotNullParameter((Object)$this$toPoints, (String)"<this>");
        double k2 = $this$toPoints.minX();
        double l = $this$toPoints.minY();
        double m = $this$toPoints.minZ();
        double n = $this$toPoints.maxX();
        double o = $this$toPoints.maxY();
        double p = $this$toPoints.maxZ();
        Object[] objectArray = new Vector3d[]{new Vector3d(k2, l, m), new Vector3d(n, l, m), new Vector3d(k2, o, m), new Vector3d(n, o, m), new Vector3d(k2, l, p), new Vector3d(n, l, p), new Vector3d(k2, o, p), new Vector3d(n, o, p)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public static final List<LineSegmentd> toLineSegments(@NotNull AABBdc $this$toLineSegments) {
        Intrinsics.checkNotNullParameter((Object)$this$toLineSegments, (String)"<this>");
        List<Vector3dc> points = MathUtilsKt.toPoints($this$toLineSegments);
        Object[] objectArray = new LineSegmentd[]{new LineSegmentd(points.get(0), points.get(1)), new LineSegmentd(points.get(1), points.get(3)), new LineSegmentd(points.get(3), points.get(2)), new LineSegmentd(points.get(2), points.get(0)), new LineSegmentd(points.get(4), points.get(5)), new LineSegmentd(points.get(5), points.get(7)), new LineSegmentd(points.get(7), points.get(6)), new LineSegmentd(points.get(6), points.get(4)), new LineSegmentd(points.get(0), points.get(4)), new LineSegmentd(points.get(1), points.get(5)), new LineSegmentd(points.get(3), points.get(7)), new LineSegmentd(points.get(2), points.get(6))};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public static final List<Planed> toPlanes(@NotNull AABBdc $this$toPlanes) {
        Intrinsics.checkNotNullParameter((Object)$this$toPlanes, (String)"<this>");
        List<Vector3dc> points = MathUtilsKt.toPoints($this$toPlanes);
        Object[] objectArray = new Planed[]{new Planed(points.get(4), points.get(5), points.get(0)), new Planed(points.get(0), points.get(1), points.get(2)), new Planed(points.get(1), points.get(5), points.get(3)), new Planed(points.get(5), points.get(4), points.get(7)), new Planed(points.get(4), points.get(0), points.get(6)), new Planed(points.get(2), points.get(3), points.get(6))};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public static final Vector3d getMin(@NotNull AABBdc $this$getMin) {
        Intrinsics.checkNotNullParameter((Object)$this$getMin, (String)"<this>");
        return new Vector3d($this$getMin.minX(), $this$getMin.minY(), $this$getMin.minZ());
    }

    @NotNull
    public static final Vector3d getMax(@NotNull AABBdc $this$getMax) {
        Intrinsics.checkNotNullParameter((Object)$this$getMax, (String)"<this>");
        return new Vector3d($this$getMax.maxX(), $this$getMax.maxY(), $this$getMax.maxZ());
    }

    @NotNull
    public static final AABBdc moveToOrigin(@NotNull AABBdc $this$moveToOrigin) {
        Intrinsics.checkNotNullParameter((Object)$this$moveToOrigin, (String)"<this>");
        Vector3d center = $this$moveToOrigin.center(new Vector3d());
        AABBd aabb = new AABBd($this$moveToOrigin);
        aabb.setMax((Vector3dc)MathUtilsKt.getMax((AABBdc)aabb).sub((Vector3dc)center));
        aabb.setMin((Vector3dc)MathUtilsKt.getMin((AABBdc)aabb).sub((Vector3dc)center));
        return (AABBdc)aabb;
    }

    public static final boolean testPlane(@NotNull AABBdc $this$testPlane, @NotNull Planed plane) {
        Intrinsics.checkNotNullParameter((Object)$this$testPlane, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)plane, (String)"plane");
        return Intersectiond.testAabPlane((double)$this$testPlane.minX(), (double)$this$testPlane.minY(), (double)$this$testPlane.minZ(), (double)$this$testPlane.maxX(), (double)$this$testPlane.maxY(), (double)$this$testPlane.maxZ(), (double)plane.a, (double)plane.b, (double)plane.c, (double)plane.d);
    }

    public static final boolean testAABB(@NotNull Planed $this$testAABB, @NotNull AABBdc aabb) {
        Intrinsics.checkNotNullParameter((Object)$this$testAABB, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)aabb, (String)"aabb");
        return Intersectiond.testAabPlane((double)aabb.minX(), (double)aabb.minY(), (double)aabb.minZ(), (double)aabb.maxX(), (double)aabb.maxY(), (double)aabb.maxZ(), (double)$this$testAABB.a, (double)$this$testAABB.b, (double)$this$testAABB.c, (double)$this$testAABB.d);
    }

    public static final boolean isPointOnPlane(double x, double y, double z, double a2, double b, double c, double d) {
        return Math.abs(a2 * x + b * y + c * z + d) < epsilon;
    }

    public static final boolean isOnPlane(@NotNull Vector3dc $this$isOnPlane, double a2, double b, double c, double d) {
        Intrinsics.checkNotNullParameter((Object)$this$isOnPlane, (String)"<this>");
        return MathUtilsKt.isPointOnPlane($this$isOnPlane.x(), $this$isOnPlane.y(), $this$isOnPlane.z(), a2, b, c, d);
    }

    public static final boolean isOnPlane(@NotNull Vector3dc $this$isOnPlane, @NotNull Planed plane) {
        Intrinsics.checkNotNullParameter((Object)$this$isOnPlane, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)plane, (String)"plane");
        return MathUtilsKt.isOnPlane($this$isOnPlane, plane.a, plane.b, plane.c, plane.d);
    }

    public static final boolean isPointInFrontOfPlane(double x, double y, double z, double a2, double b, double c, double d) {
        return a2 * x + b * y + c * z + d > 0.0;
    }

    public static final boolean isInFrontOfPlane(@NotNull Vector3dc $this$isInFrontOfPlane, double a2, double b, double c, double d) {
        Intrinsics.checkNotNullParameter((Object)$this$isInFrontOfPlane, (String)"<this>");
        return MathUtilsKt.isPointInFrontOfPlane($this$isInFrontOfPlane.x(), $this$isInFrontOfPlane.y(), $this$isInFrontOfPlane.z(), a2, b, c, d);
    }

    public static final boolean isInFrontOfPlane(@NotNull Vector3dc $this$isInFrontOfPlane, @NotNull Planed plane) {
        Intrinsics.checkNotNullParameter((Object)$this$isInFrontOfPlane, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)plane, (String)"plane");
        return MathUtilsKt.isInFrontOfPlane($this$isInFrontOfPlane, plane.a, plane.b, plane.c, plane.d);
    }

    public static final boolean isPointBehindPlane(double x, double y, double z, double a2, double b, double c, double d) {
        return a2 * x + b * y + c * z + d < 0.0;
    }

    public static final boolean isBehindPlane(@NotNull Vector3dc $this$isBehindPlane, double a2, double b, double c, double d) {
        Intrinsics.checkNotNullParameter((Object)$this$isBehindPlane, (String)"<this>");
        return MathUtilsKt.isPointBehindPlane($this$isBehindPlane.x(), $this$isBehindPlane.y(), $this$isBehindPlane.z(), a2, b, c, d);
    }

    public static final boolean isBehindPlane(@NotNull Vector3dc $this$isBehindPlane, @NotNull Planed plane) {
        Intrinsics.checkNotNullParameter((Object)$this$isBehindPlane, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)plane, (String)"plane");
        return MathUtilsKt.isBehindPlane($this$isBehindPlane, plane.a, plane.b, plane.c, plane.d);
    }
}

