/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.client.event;

import invoker54.invocore.client.util.ClientUtil;
import invoker54.reviveme.client.VanillaKeybindHandler;
import invoker54.reviveme.common.capability.FallenData;
import invoker54.reviveme.common.config.ReviveMeConfig;
import invoker54.reviveme.common.network.payload.SelfReviveMsg;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ComputeFovModifierEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@EventBusSubscriber(modid="revive_me", value={Dist.CLIENT})
public class FallenPlayerActionsEvent {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Minecraft inst = Minecraft.getInstance();
    public static int timeHeld = 0;

    @SubscribeEvent
    public static void forceDeath(PlayerTickEvent.Pre event) {
        if (!event.getEntity().level().isClientSide) {
            return;
        }
        if (event.getEntity() != ClientUtil.getPlayer()) {
            return;
        }
        FallenData cap = FallenData.get((LivingEntity)FallenPlayerActionsEvent.inst.player);
        if (!cap.isFallen()) {
            return;
        }
        if (!VanillaKeybindHandler.useHeld && !VanillaKeybindHandler.attackHeld) {
            timeHeld = 0;
            return;
        }
        if (VanillaKeybindHandler.attackHeld) {
            ++timeHeld;
            if (!ClientUtil.getPlayer().swinging) {
                ClientUtil.getPlayer().swing(InteractionHand.MAIN_HAND);
            }
            if (timeHeld == 40) {
                PacketDistributor.sendToServer((CustomPacketPayload)new SelfReviveMsg(0), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        } else if (VanillaKeybindHandler.useHeld && cap.canSelfRevive()) {
            ClientUtil.getPlayer().swing(InteractionHand.MAIN_HAND);
            if (++timeHeld == 40) {
                PacketDistributor.sendToServer((CustomPacketPayload)new SelfReviveMsg(1), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        timeHeld = Math.min(timeHeld, 41);
    }

    @SubscribeEvent
    public static void modifyFOV(ComputeFovModifierEvent event) {
        Player player = event.getPlayer();
        FallenData cap = FallenData.get((LivingEntity)player);
        if (!cap.isFallen()) {
            return;
        }
        float f = 1.0f;
        if (player.getAbilities().flying) {
            f *= 1.1f;
        }
        f = (float)((double)f * ((player.getAttributeValue(Attributes.MOVEMENT_SPEED) / (double)player.getAbilities().getWalkingSpeed() + 1.0) / 2.0));
        if (player.getAbilities().getWalkingSpeed() == 0.0f || Float.isNaN(f) || Float.isInfinite(f)) {
            f = 1.0f;
        }
        int i = timeHeld;
        float f1 = Math.min((float)i / 40.0f, 1.0f);
        f1 *= f1;
        event.setNewFovModifier(f *= 1.0f - f1 * 0.15f);
    }

    @SubscribeEvent
    public static void openInventory(ScreenEvent.Opening event) {
        if (ClientUtil.getWorld() == null) {
            return;
        }
        if (ClientUtil.getPlayer() == null) {
            return;
        }
        if (!FallenData.get((LivingEntity)ClientUtil.getPlayer()).isFallen()) {
            return;
        }
        if (!(event.getScreen() instanceof InventoryScreen)) {
            return;
        }
        if (ReviveMeConfig.interactWithInventory != ReviveMeConfig.INTERACT_WITH_INVENTORY.NO) {
            return;
        }
        event.setCanceled(true);
    }
}

