/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.client.event;

import com.mojang.blaze3d.vertex.PoseStack;
import invoker54.invocore.client.util.ClientUtil;
import invoker54.invocore.client.util.InvoText;
import invoker54.invocore.client.util.InvoZone;
import invoker54.invocore.client.util.TextUtil;
import invoker54.reviveme.ReviveMe;
import invoker54.reviveme.common.capability.FallenData;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;

@EventBusSubscriber(modid="revive_me", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class ReviveScreenEvent {
    private static final Minecraft inst = Minecraft.getInstance();
    public static InvoText beingRevivedText = InvoText.translate((String)"reviveScreen.being_revived", (Object[])new Object[0]);
    public static InvoText revivingText = InvoText.translate((String)"reviveScreen.reviving", (Object[])new Object[0]);
    public static final int bgColor = new Color(35, 35, 35, 255).getRGB();
    public static final int revColor = new Color(77, 77, 77, 121).getRGB();
    public static final int progressColor = new Color(247, 247, 247, 255).getRGB();

    @SubscribeEvent
    public static void registerReviveScreen(RegisterGuiLayersEvent event) {
        event.registerBelow(VanillaGuiLayers.CHAT, ReviveMe.makeResource("revive_screen"), (guiGraphics, tracker) -> {
            InvoText titleText;
            FallenData cap = FallenData.get((LivingEntity)ReviveScreenEvent.inst.player);
            PoseStack stack = guiGraphics.pose();
            if (cap.getOtherPlayer() == null) {
                return;
            }
            InvoZone workZone = new InvoZone(0.0f, (float)guiGraphics.guiWidth(), 0.0f, (float)guiGraphics.guiHeight());
            if (cap.isFallen()) {
                ClientUtil.blitColor((PoseStack)stack, (InvoZone)workZone, (int)0x60500000);
                titleText = beingRevivedText;
            } else {
                ClientUtil.blitColor((PoseStack)stack, (InvoZone)workZone, (int)revColor);
                titleText = revivingText;
            }
            InvoZone textZone = workZone.copy().splitHeight(5.0f, 1.0f);
            textZone.setY(textZone.down()).setHeight(16.0f);
            TextUtil.renderText((PoseStack)stack, (Component)titleText.getText(), (boolean)true, (int)1, (InvoZone)textZone, (TextUtil.txtAlignment)TextUtil.txtAlignment.MIDDLE);
            InvoZone barZone = workZone.copy().setHeight(16.0f).splitWidth(2.0f, 1.0f).center(workZone);
            ClientUtil.blitColor((PoseStack)stack, (InvoZone)barZone, (int)bgColor);
            float progress = cap.getProgress(true);
            ClientUtil.blitColor((PoseStack)stack, (InvoZone)barZone.copy().splitWidth(1.0f, progress).inflate(0.0f, -2.0f).center(barZone), (int)progressColor);
        });
    }
}

