/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import invoker54.reviveme.common.capability.FallenData;
import invoker54.reviveme.common.event.FallEvent;
import invoker54.reviveme.common.event.FallenTimerEvent;
import invoker54.reviveme.init.NetworkInit;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FixCommand {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"revivemefix").requires(commandSource -> commandSource.hasPermission(2))).executes(FixCommand::fixPlayer)).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(FixCommand::fixPlayer)));
    }

    private static int fixPlayer(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        ServerPlayer caller;
        try {
            caller = EntityArgument.getPlayer(commandContext, (String)"player");
        }
        catch (Exception e) {
            if (!((CommandSourceStack)commandContext.getSource()).isPlayer()) {
                return 1;
            }
            caller = ((CommandSourceStack)commandContext.getSource()).getPlayer();
        }
        FallenData cap = FallenData.get((LivingEntity)caller);
        if (!caller.isAlive()) {
            return 1;
        }
        caller.setInvulnerable(false);
        NetworkInit.sendMessage(Component.translatable((String)"revive_me.commands.fix"), true, (Entity)caller);
        if (cap.isFallen()) {
            DamageSource damageSource = cap.getDamageSource();
            if (damageSource == null) {
                damageSource = caller.damageSources().fellOutOfWorld();
            }
            if (cap.shouldDie()) {
                cap.kill((Player)caller);
                return 1;
            }
            cap.setFallen(false);
            FallEvent.cancelEvent((Player)caller, damageSource);
        } else {
            FallenTimerEvent.revivePlayer((Player)caller, true);
        }
        return 1;
    }
}

