/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.common.event;

import invoker54.invocore.common.ModLogger;
import invoker54.reviveme.client.event.FallScreenEvent;
import invoker54.reviveme.common.capability.FallenData;
import invoker54.reviveme.common.config.ReviveMeConfig;
import invoker54.reviveme.common.network.payload.SyncClientCapMsg;
import invoker54.reviveme.common.network.payload.SyncConfigMsg;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="revive_me")
public class CapabilityEvents {
    private static final ModLogger LOGGER = ModLogger.getLogger(FallScreenEvent.class, (AtomicBoolean)ReviveMeConfig.debugMode);

    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        FallenData cap = FallenData.get((LivingEntity)event.getEntity());
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)event.getEntity(), (CustomPacketPayload)new SyncClientCapMsg(event.getEntity().getUUID(), cap.writeNBT()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)event.getEntity()), (CustomPacketPayload)new SyncConfigMsg(ReviveMeConfig.serialize()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @SubscribeEvent
    public static void onLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!ReviveMeConfig.dieOnDisconnect) {
            return;
        }
        Player player = event.getEntity();
        if (!player.isAlive()) {
            return;
        }
        FallenData cap = FallenData.get((LivingEntity)player);
        if (!cap.isFallen()) {
            return;
        }
        cap.kill(player);
    }

    @SubscribeEvent
    public static void onStartTrack(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (!(entity instanceof Player)) {
            return;
        }
        Player targPlayer = (Player)entity;
        FallenData cap = FallenData.get((LivingEntity)targPlayer);
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)event.getEntity()), (CustomPacketPayload)new SyncClientCapMsg(event.getTarget().getUUID(), cap.writeNBT()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @SubscribeEvent
    public static void onWorldJoin(EntityJoinLevelEvent event) {
        if (event.getLevel().isClientSide) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        FallenData cap = FallenData.get((LivingEntity)player);
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)event.getEntity()), (CustomPacketPayload)new SyncClientCapMsg(event.getEntity().getUUID(), cap.writeNBT()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

