/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.common.event;

import invoker54.invocore.common.ModLogger;
import invoker54.reviveme.common.capability.FallenData;
import invoker54.reviveme.common.config.ReviveMeConfig;
import invoker54.reviveme.common.network.payload.SyncClientCapMsg;
import invoker54.reviveme.init.MobEffectInit;
import invoker54.reviveme.init.NetworkInit;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;

public class FallEvent {
    private static final ModLogger LOGGER = ModLogger.getLogger(FallEvent.class, (AtomicBoolean)ReviveMeConfig.debugMode);

    public static boolean cancelEvent(Player player, DamageSource source) {
        FallenData instance = FallenData.get((LivingEntity)player);
        instance.refreshSelfReviveTypes(player);
        if (!instance.canSelfRevive() && !player.getServer().isDedicatedServer() && player.getServer().getPlayerCount() == 1) {
            return false;
        }
        if (!instance.isFallen()) {
            NetworkInit.sendMessage(Component.translatable((String)"revive_me.chat.player_fallen", (Object[])new Object[]{player.getDisplayName()}), false, (Entity)player);
            instance.setFallen(true);
            player.setHealth(1.0f);
            player.getFoodData().setFoodLevel(0);
            instance.setDamageSource(source);
            instance.SetTimeLeft(player.level().getGameTime(), ReviveMeConfig.timeLeft.intValue());
            if (player.hasEffect(MobEffectInit.FALLEN_EFFECT)) {
                instance.setPenaltyMultiplier(player.getEffect(MobEffectInit.FALLEN_EFFECT).getAmplifier() + 1);
                player.removeEffect(MobEffectInit.FALLEN_EFFECT);
            }
            if (ReviveMeConfig.revertEffectsOnRevive) {
                instance.saveEffects(player);
            }
            instance.removeOriginalEffects(player);
            FallEvent.modifyPotionEffects(player);
            player.stopRiding();
            player.stopUsingItem();
            player.closeContainer();
            if (instance.getOtherPlayer() != null) {
                Player otherPlayer = player.level().getPlayerByUUID(instance.getOtherPlayer());
                if (otherPlayer != null) {
                    FallenData otherCap = FallenData.get((LivingEntity)otherPlayer);
                    otherCap.resumeFallTimer();
                    otherCap.setOtherPlayer(null);
                    PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)otherPlayer, (CustomPacketPayload)new SyncClientCapMsg(otherPlayer.getUUID(), otherCap.writeNBT()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                instance.setOtherPlayer(null);
            }
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)player, (CustomPacketPayload)new SyncClientCapMsg(player.getUUID(), instance.writeNBT()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            player.setHealth(0.0f);
            for (Entity entity : ((ServerLevel)player.level()).getAllEntities()) {
                Mob mob;
                if (!(entity instanceof Mob) || (mob = (Mob)entity).getTarget() == null || mob.getTarget().getId() != player.getId()) continue;
                if (mob instanceof NeutralMob) {
                    ((NeutralMob)mob).playerDied(player);
                }
                mob.aiStep();
            }
            player.setHealth(1.0f);
        } else {
            instance.setFallen(false);
        }
        return instance.isFallen();
    }

    public static void modifyPotionEffects(Player player) {
        for (String string : ReviveMeConfig.downedEffects) {
            try {
                String[] array = string.split(":");
                ResourceLocation effectLocation = ResourceLocation.fromNamespaceAndPath((String)array[0], (String)array[1]);
                int tier = Integer.parseInt(array[2]);
                Optional effect = BuiltInRegistries.MOB_EFFECT.getHolder(effectLocation);
                if (effect.isEmpty()) {
                    LOGGER.error("Incorrect MOD ID or Potion Effect: " + string);
                    continue;
                }
                MobEffectInstance effectInstance = player.getEffect((Holder)effect.get());
                if (effectInstance != null) continue;
                player.addEffect(new MobEffectInstance((Holder)effect.get(), Integer.MAX_VALUE, tier));
            }
            catch (Exception e) {
                LOGGER.error("This string couldn't be parsed: " + string);
            }
        }
    }
}

