/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.common.event;

import invoker54.reviveme.common.capability.FallenData;
import invoker54.reviveme.common.config.ReviveMeConfig;
import invoker54.reviveme.common.network.payload.SyncClientCapMsg;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="revive_me")
public class ReviverEvents {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onHitWhileReviving(LivingDamageEvent.Pre event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player reviverPlayer = (Player)livingEntity;
        FallenData reviveCap = FallenData.get((LivingEntity)reviverPlayer);
        if (reviveCap.isFallen()) {
            return;
        }
        if (!reviveCap.isReviver(reviveCap.getOtherPlayer())) {
            return;
        }
        Player fallenEntity = reviverPlayer.level().getPlayerByUUID(reviveCap.getOtherPlayer());
        if (fallenEntity == null) {
            return;
        }
        FallenData fallCap = FallenData.get((LivingEntity)fallenEntity);
        reviveCap.setProgress(reviverPlayer.level().getGameTime(), ReviveMeConfig.reviveTime);
        fallCap.setProgress(reviverPlayer.level().getGameTime(), ReviveMeConfig.reviveTime);
        CompoundTag nbt = new CompoundTag();
        nbt.put(reviverPlayer.getStringUUID(), (Tag)reviveCap.writeNBT());
        nbt.put(fallenEntity.getStringUUID(), (Tag)fallCap.writeNBT());
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)fallenEntity), (CustomPacketPayload)new SyncClientCapMsg(reviverPlayer.getStringUUID(), reviveCap.writeNBT()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)reviverPlayer), (CustomPacketPayload)new SyncClientCapMsg(fallenEntity.getStringUUID(), fallCap.writeNBT()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

