/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.common.potion;

import invoker54.invocore.common.ModLogger;
import invoker54.reviveme.common.capability.FallenData;
import invoker54.reviveme.common.config.ReviveMeConfig;
import invoker54.reviveme.init.MobEffectInit;
import java.awt.Color;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.EffectCure;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;

public class KillRevivePotionEffect
extends MobEffect {
    public static ModLogger LOGGERT = ModLogger.getLogger(KillRevivePotionEffect.class, (AtomicBoolean)ReviveMeConfig.debugMode);
    public static final int effectColor = new Color(35, 5, 5, 255).getRGB();

    public KillRevivePotionEffect(MobEffectCategory category) {
        super(category, effectColor);
    }

    public void fillEffectCures(Set<EffectCure> cures, MobEffectInstance effectInstance) {
        cures.clear();
    }

    @EventBusSubscriber(modid="revive_me")
    public static class PotionEvents {
        @SubscribeEvent
        public static void killMobEvent(LivingDeathEvent event) {
            Entity sourceEntity = event.getSource().getEntity();
            if (!(sourceEntity instanceof Player)) {
                return;
            }
            Player entity = (Player)sourceEntity;
            MobEffectInstance instance = entity.getEffect(MobEffectInit.KILL_REVIVE_EFFECT);
            if (instance == null) {
                return;
            }
            entity.removeEffect(MobEffectInit.KILL_REVIVE_EFFECT);
            if (instance.getAmplifier() > 0) {
                entity.removeEffect(MobEffectInit.KILL_REVIVE_EFFECT);
                entity.addEffect(new MobEffectInstance(MobEffectInit.KILL_REVIVE_EFFECT, instance.getDuration(), instance.getAmplifier() - 1));
            }
        }

        @SubscribeEvent
        public static void expireEvent(MobEffectEvent.Expired event) {
            PotionEvents.removeEffect(event.getEntity(), event.getEffectInstance(), false);
        }

        @SubscribeEvent
        public static void removeEvent(MobEffectEvent.Remove event) {
            PotionEvents.removeEffect(event.getEntity(), event.getEffectInstance(), true);
        }

        public static void removeEffect(LivingEntity entity, MobEffectInstance effect, boolean completed) {
            if (effect == null) {
                return;
            }
            if (!(effect.getEffect().value() instanceof KillRevivePotionEffect)) {
                return;
            }
            if (!(entity instanceof Player)) {
                return;
            }
            FallenData cap = FallenData.get(entity);
            if (cap.isFallen()) {
                return;
            }
            if (completed) {
                return;
            }
            entity.setHealth(1.0E-8f);
            entity.hurt(entity.damageSources().fellOutOfWorld(), 1.0f);
        }
    }
}

