/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.mixin;

import invoker54.reviveme.common.capability.FallenData;
import invoker54.reviveme.common.config.ReviveMeConfig;
import invoker54.reviveme.common.event.FallEvent;
import invoker54.reviveme.common.network.payload.SyncClientCapMsg;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CommonHooks.class})
public class CommonHooksMixin {
    @Inject(remap=false, method={"onInteractEntity(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void onInteractEntity(Player player, Entity target, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        if (target.level().isClientSide) {
            return;
        }
        FallenData reviverCap = FallenData.get((LivingEntity)player);
        if (reviverCap.isFallen()) {
            return;
        }
        if (player.isDiscrete()) {
            return;
        }
        if (!(target instanceof Player)) {
            return;
        }
        Player targPlayer = (Player)target;
        FallenData targCap = FallenData.get((LivingEntity)targPlayer);
        if (!targCap.isFallen() || targCap.getOtherPlayer() != null) {
            return;
        }
        if (!targCap.hasEnough(player)) {
            return;
        }
        targCap.setProgress(player.level().getGameTime(), ReviveMeConfig.reviveTime);
        targCap.setOtherPlayer(player.getUUID());
        reviverCap.setProgress(player.level().getGameTime(), ReviveMeConfig.reviveTime);
        reviverCap.setOtherPlayer(targPlayer.getUUID());
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)player, (CustomPacketPayload)new SyncClientCapMsg(player.getUUID(), reviverCap.writeNBT()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)targPlayer, (CustomPacketPayload)new SyncClientCapMsg(targPlayer.getUUID(), targCap.writeNBT()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        cir.setReturnValue((Object)InteractionResult.FAIL);
    }

    @Inject(remap=false, method={"onLivingDeath"}, at={@At(value="HEAD")}, cancellable=true)
    private static void onLivingDeath(LivingEntity entity, DamageSource src, CallbackInfoReturnable<Boolean> cir) {
        boolean cancelled;
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        if (((ServerPlayer)entity).gameMode.getGameModeForPlayer() == GameType.CREATIVE) {
            return;
        }
        if (ReviveMeConfig.runDeathEventFirst) {
            cancelled = ((LivingDeathEvent)NeoForge.EVENT_BUS.post((Event)new LivingDeathEvent(entity, src))).isCanceled();
            if (!cancelled) {
                cancelled = FallEvent.cancelEvent((Player)entity, src);
            }
        } else {
            cancelled = FallEvent.cancelEvent((Player)entity, src);
            if (!cancelled) {
                cancelled = ((LivingDeathEvent)NeoForge.EVENT_BUS.post((Event)new LivingDeathEvent(entity, src))).isCanceled();
            }
        }
        cir.setReturnValue((Object)cancelled);
    }
}

