/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.mixin;

import invoker54.reviveme.common.capability.FallenData;
import invoker54.reviveme.common.config.ReviveMeConfig;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.PlayerTeam;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Shadow
    public Level level;
    @Unique
    private FallenData revive_Me$cap;

    @Shadow
    public abstract int getId();

    @Shadow
    @Nullable
    public abstract PlayerTeam getTeam();

    @Unique
    private FallenData revive_Me$getCap() {
        if (this.revive_Me$cap != null) {
            return this.revive_Me$cap;
        }
        Entity entity = this.level.getEntity(this.getId());
        if (!(entity instanceof Player)) {
            return null;
        }
        this.revive_Me$cap = FallenData.get((LivingEntity)((Player)entity));
        return this.revive_Me$cap;
    }

    @Inject(method={"getTeamColor"}, at={@At(value="HEAD")}, cancellable=true)
    private void getTeamColor(CallbackInfoReturnable<Integer> cir) {
        if (!this.level.isClientSide) {
            return;
        }
        FallenData cap = this.revive_Me$getCap();
        if (cap == null) {
            return;
        }
        if (!cap.isFallen()) {
            return;
        }
        double timePassed = (double)cap.callForHelpTicks() / 20.0;
        PlayerTeam team = this.getTeam();
        int preColor = timePassed < 3.0 && timePassed % 1.0 < 0.5 ? 0xFFFFFF : (team != null && team.getColor().getColor() != null ? team.getColor().getColor().intValue() : new Color(248, 80, 29, 255).getRGB());
        Color postColor = new Color(preColor);
        if (ReviveMeConfig.timeLeft != 0 && preColor != 0xFFFFFF) {
            float percentLeft = Math.max(0.0f, Math.min(cap.GetTimeLeft(true), 1.0f));
            postColor = new Color(Math.round((float)postColor.getRed() * percentLeft), Math.round((float)postColor.getGreen() * percentLeft), Math.round((float)postColor.getBlue() * percentLeft));
        }
        cir.setReturnValue((Object)postColor.getRGB());
    }

    @Inject(method={"getPose"}, at={@At(value="HEAD")}, cancellable=true)
    private void getPose(CallbackInfoReturnable<Pose> cir) {
        if (!this.level.isClientSide) {
            return;
        }
        Entity entity = this.level.getEntity(this.getId());
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!FallenData.get((LivingEntity)player).isFallen()) {
            return;
        }
        switch (ReviveMeConfig.fallenPose) {
            case CROUCH: {
                cir.setReturnValue((Object)Pose.CROUCHING);
                break;
            }
            case PRONE: {
                cir.setReturnValue((Object)Pose.SWIMMING);
                break;
            }
            case SLEEP: {
                cir.setReturnValue((Object)Pose.SLEEPING);
            }
        }
    }

    @Inject(method={"hasPose"}, at={@At(value="HEAD")}, cancellable=true)
    private void hasPose(Pose pose, CallbackInfoReturnable<Boolean> cir) {
        if (!this.level.isClientSide) {
            return;
        }
        Entity entity = this.level.getEntity(this.getId());
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!FallenData.get((LivingEntity)player).isFallen()) {
            return;
        }
        switch (ReviveMeConfig.fallenPose) {
            case CROUCH: {
                cir.setReturnValue((Object)(pose == Pose.CROUCHING ? 1 : 0));
                break;
            }
            case PRONE: {
                cir.setReturnValue((Object)(pose == Pose.SWIMMING ? 1 : 0));
                break;
            }
            case SLEEP: {
                cir.setReturnValue((Object)(pose == Pose.SLEEPING ? 1 : 0));
            }
        }
    }

    @Inject(method={"isInvulnerable"}, at={@At(value="HEAD")}, cancellable=true)
    private void isInvulnerable(CallbackInfoReturnable<Boolean> cir) {
        if (this.revive_Me$getCap() == null) {
            return;
        }
        if (!this.revive_Me$getCap().isFallen()) {
            return;
        }
        cir.setReturnValue((Object)true);
    }
}

