/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.client.event;

import invoker54.invocore.client.util.ClientUtil;
import invoker54.invocore.common.ModLogger;
import invoker54.reviveme.client.VanillaKeybindHandler;
import invoker54.reviveme.common.capability.FallenCapability;
import invoker54.reviveme.common.config.ReviveMeConfig;
import invoker54.reviveme.common.network.NetworkHandler;
import invoker54.reviveme.common.network.message.SelfReviveMsg;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Hand;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="reviveme", value={Dist.CLIENT})
public class FallenPlayerActionsEvent {
    private static final ModLogger LOGGER = ModLogger.getLogger(FallenPlayerActionsEvent.class, (AtomicBoolean)ReviveMeConfig.debugMode);
    private static final Minecraft inst = Minecraft.func_71410_x();
    public static int timeHeld = 0;

    @SubscribeEvent
    public static void forceDeath(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.SERVER) {
            return;
        }
        if (event.type != TickEvent.Type.PLAYER) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        if (event.player != ClientUtil.getPlayer()) {
            return;
        }
        FallenCapability cap = FallenCapability.GetFallCap((LivingEntity)FallenPlayerActionsEvent.inst.field_71439_g);
        if (!cap.isFallen()) {
            return;
        }
        if (!VanillaKeybindHandler.useHeld && !VanillaKeybindHandler.attackHeld) {
            timeHeld = 0;
            return;
        }
        if (VanillaKeybindHandler.attackHeld) {
            ++timeHeld;
            if (!ClientUtil.getPlayer().field_82175_bq) {
                ClientUtil.getPlayer().func_184609_a(Hand.MAIN_HAND);
            }
            if (timeHeld == 40) {
                NetworkHandler.INSTANCE.sendToServer((Object)new SelfReviveMsg(0));
            }
        } else if (VanillaKeybindHandler.useHeld && cap.canSelfRevive()) {
            ClientUtil.getPlayer().func_184609_a(Hand.MAIN_HAND);
            if (++timeHeld == 40) {
                NetworkHandler.INSTANCE.sendToServer((Object)new SelfReviveMsg(1));
            }
        }
        timeHeld = Math.min(timeHeld, 41);
    }

    @SubscribeEvent
    public static void modifyFOV(FOVUpdateEvent event) {
        PlayerEntity player = event.getEntity();
        FallenCapability cap = FallenCapability.GetFallCap((LivingEntity)player);
        if (!cap.isFallen()) {
            return;
        }
        float f = 1.0f;
        if (player.field_71075_bZ.field_75100_b) {
            f *= 1.1f;
        }
        f = (float)((double)f * ((player.func_233637_b_(Attributes.field_233821_d_) / (double)player.field_71075_bZ.func_75094_b() + 1.0) / 2.0));
        if (player.field_71075_bZ.func_75094_b() == 0.0f || Float.isNaN(f) || Float.isInfinite(f)) {
            f = 1.0f;
        }
        int i = timeHeld;
        float f1 = Math.min((float)i / 40.0f, 1.0f);
        f1 *= f1;
        event.setNewfov(f *= 1.0f - f1 * 0.15f);
    }

    @SubscribeEvent
    public static void openInventory(GuiOpenEvent event) {
        if (ClientUtil.getWorld() == null) {
            return;
        }
        if (ClientUtil.getPlayer() == null) {
            return;
        }
        if (!FallenCapability.GetFallCap((LivingEntity)ClientUtil.getPlayer()).isFallen()) {
            return;
        }
        if (!(event.getGui() instanceof InventoryScreen)) {
            return;
        }
        if (ReviveMeConfig.interactWithInventory != ReviveMeConfig.INTERACT_WITH_INVENTORY.NO) {
            return;
        }
        event.setGui(null);
    }
}

