/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.common.capability;

import invoker54.invocore.client.util.CommonUtil;
import invoker54.invocore.common.MathUtil;
import invoker54.invocore.common.ModLogger;
import invoker54.reviveme.common.api.FallenProvider;
import invoker54.reviveme.common.config.ReviveMeConfig;
import invoker54.reviveme.common.event.FallenTimerEvent;
import invoker54.reviveme.common.network.NetworkHandler;
import invoker54.reviveme.common.network.message.SyncClientCapMsg;
import invoker54.reviveme.init.EffectInit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class FallenCapability {
    private static final ModLogger LOGGER = ModLogger.getLogger(FallenCapability.class, (AtomicBoolean)ReviveMeConfig.debugMode);
    public static final String FALLEN_BOOL = "isFallenREVIVE";
    public static final String FELL_START_LONG = "fellStartREVIVE";
    public static final String FELL_END_DOUBLE = "fellEndREVIVE";
    public static final String REVIVE_START_LONG = "revStartREVIVE";
    public static final String REVIVE_END_INT = "revEndREVIVE";
    public static final String OTHERPLAYER_UUID = "otherPlayerREVIVE";
    public static final String PENALTY_MULTIPLIER_INT = "penaltyMultiplierIntREVIVE";
    public static final String CALLED_FOR_HELP_LONG = "calledForHelpLong";
    public static final String SAVED_EFFECTS_TAG = "savedEffectsTag";
    public static final String DOWNED_BY_PLAYER_BOOL = "DOWNED_BY_PLAYER_BOOL";
    public static final String IS_EFFECTS_REMOVED = "IS_EFFECTS_REMOVED";
    public static final String SELF_REVIVE_OPTIONS_STRING = "SELF_REVIVE_OPTIONS_STRING";
    public static final String SACRIFICEITEMS_COMPOUND = "SACRIFICEITEMS_COMPOUND";
    public static final String STATUS_EFFECTS_COMPOUND = "STATUS_EFFECTS_COMPOUND";
    public static final String SELF_REVIVE_COUNT_INT = "SELF_REVIVE_COUNT_INT";
    protected World level;
    protected long revStart = 0L;
    protected int revEnd = 0;
    protected long fellStart = 0L;
    protected double fellEnd = 0.0;
    protected DamageSource damageSource = DamageSource.field_76380_i;
    protected boolean isFallen = false;
    protected long fallenTick = 0L;
    protected UUID otherPlayer = null;
    protected long calledForHelpTime = 0L;
    protected int penaltyMultiplier = 0;
    protected CompoundNBT savedEffectsTag = new CompoundNBT();
    protected List<SELFREVIVETYPE> selfReviveTypeList = new ArrayList<SELFREVIVETYPE>(ReviveMeConfig.selfReviveOptions);
    protected List<ItemStack> sacrificialItems = new ArrayList<ItemStack>();
    protected List<Effect> negativeStatusEffects = new ArrayList<Effect>();
    protected int selfReviveCount = 0;
    protected boolean isDownedByPlayer = false;
    protected boolean isEffectsRemoved = false;

    public FallenCapability(World level) {
        this.level = level;
    }

    public FallenCapability() {
    }

    public static FallenCapability GetFallCap(LivingEntity player) {
        return (FallenCapability)player.getCapability(FallenProvider.FALLENDATA).orElseGet(FallenCapability::new);
    }

    public void removeOriginalEffects(PlayerEntity player) {
        if (this.isEffectsRemoved) {
            return;
        }
        try {
            player.func_195061_cb();
            this.isEffectsRemoved = true;
        }
        catch (Exception e) {
            LOGGER.warn("Effect removal failed, remove effects later...");
            e.printStackTrace();
        }
    }

    public boolean canSelfRevive() {
        if (ReviveMeConfig.maxSelfRevives != -1 && this.getSelfReviveCount() >= ReviveMeConfig.maxSelfRevives) {
            return false;
        }
        return !ReviveMeConfig.disableSelfReviveIfPlayerDowned || !this.isDownedByPlayer;
    }

    public void callForHelp() {
        this.calledForHelpTime = this.level.func_82737_E();
    }

    public boolean isCallingForHelp() {
        return this.callForHelpCooldown() != 1.0;
    }

    public long callForHelpTicks() {
        return this.level.func_82737_E() - this.calledForHelpTime;
    }

    public double callForHelpCooldown() {
        long timePassed = this.callForHelpTicks();
        return Math.min((double)timePassed / (ReviveMeConfig.reviveHelpDuration * 20.0), 1.0);
    }

    public float getPenaltyAmount(PlayerEntity player) {
        Double actualAmount = ReviveMeConfig.penaltyAmount;
        if (actualAmount > 0.0 && actualAmount < 1.0) {
            actualAmount = actualAmount * this.countReviverPenaltyAmount(player);
        }
        if (player.func_184812_l_()) {
            actualAmount = 0.0;
        }
        return Math.round(actualAmount);
    }

    public void kill(PlayerEntity player) {
        player.func_184185_a(SoundEvents.field_187798_ea, 1.0f, (player.func_70681_au().nextFloat() - player.func_70681_au().nextFloat()) * 0.2f + 1.0f);
        player.func_110142_aN().func_94547_a(this.getDamageSource(), 1.0f, 1.0f);
        if (this.damageSource.func_76346_g() instanceof PlayerEntity) {
            player.func_230246_e_((PlayerEntity)this.damageSource.func_76346_g());
        }
        if (this.damageSource.func_76346_g() instanceof MobEntity) {
            player.func_70604_c((LivingEntity)((MobEntity)this.damageSource.func_76346_g()));
        }
        player.func_70645_a(this.damageSource);
        player.func_70606_j(0.0f);
    }

    public double countReviverPenaltyAmount(PlayerEntity reviver) {
        switch (ReviveMeConfig.penaltyType) {
            case NONE: {
                return 0.0;
            }
            case HEALTH: {
                return reviver.func_110143_aJ() + reviver.func_110139_bj();
            }
            case EXPERIENCE: {
                return reviver.field_71068_ca;
            }
            case FOOD: {
                return (float)reviver.func_71024_bL().func_75116_a() + Math.max(reviver.func_71024_bL().func_75115_e(), 0.0f);
            }
            case ITEM: {
                ItemStack penaltyStack = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(ReviveMeConfig.penaltyItem)));
                if (!ReviveMeConfig.penaltyItemData.isEmpty()) {
                    penaltyStack.func_196082_o().func_197643_a(ReviveMeConfig.penaltyItemData);
                }
                int count = 0;
                for (int a = 0; a < reviver.field_71071_by.func_70302_i_(); ++a) {
                    ItemStack containerStack = reviver.field_71071_by.func_70301_a(a);
                    if (!penaltyStack.func_77969_a(containerStack) || !ItemStack.func_77970_a((ItemStack)containerStack, (ItemStack)penaltyStack)) continue;
                    count += containerStack.func_190916_E();
                }
                return count;
            }
        }
        return 0.0;
    }

    public boolean hasEnough(PlayerEntity reviver) {
        if (reviver.func_184812_l_()) {
            return true;
        }
        if (ReviveMeConfig.penaltyType == PENALTYPE.NONE) {
            return true;
        }
        return this.countReviverPenaltyAmount(reviver) - (double)this.getPenaltyAmount(reviver) >= 0.0;
    }

    public void setDamageSource(DamageSource damageSource) {
        this.damageSource = damageSource;
        this.isDownedByPlayer = this.damageSource.func_76346_g() instanceof PlayerEntity;
    }

    public DamageSource getDamageSource() {
        return this.damageSource;
    }

    public float GetTimeLeft(boolean divideByMax) {
        double maxSeconds = this.getPenaltyTicks(this.fellEnd);
        if (ReviveMeConfig.timeLeft == 0) {
            maxSeconds = 0.0;
        }
        if (divideByMax) {
            return (float)(1.0 - (double)(this.level.func_82737_E() - this.fellStart) / maxSeconds);
        }
        return (float)(((double)this.fellStart + maxSeconds - (double)this.level.func_82737_E()) / 20.0);
    }

    public float getKillTime(boolean divideByMax) {
        if (ReviveMeConfig.pvpTimer == -1) {
            return -1.0f;
        }
        double maxSeconds = this.getPenaltyTicks(ReviveMeConfig.pvpTimer * 20);
        if (divideByMax) {
            return (float)Math.max(0.0, 1.0 - (double)(this.level.func_82737_E() - this.fellStart) / maxSeconds);
        }
        return (float)Math.max(0.0, ((double)this.fellStart + maxSeconds - (double)this.level.func_82737_E()) / 20.0);
    }

    public boolean shouldDie() {
        return ReviveMeConfig.timeLeft != 0 && this.GetTimeLeft(false) <= 0.0f;
    }

    public boolean canDie() {
        return this.fallenTick != this.level.func_82737_E();
    }

    public void SetTimeLeft(long timeStart, double maxSeconds) {
        this.fellStart = timeStart;
        this.fellEnd = (long)(maxSeconds * 20.0);
    }

    public void resumeFallTimer() {
        this.fellStart = this.level.func_82737_E() - (this.revStart - this.fellStart);
    }

    public boolean isFallen() {
        return this.isFallen;
    }

    public void setFallen(boolean fallen) {
        this.isFallen = fallen;
        if (!fallen) {
            this.setProgress(0L, 1);
            this.SetTimeLeft(0L, 1.0);
            this.setOtherPlayer(null);
            this.calledForHelpTime = 0L;
            this.isEffectsRemoved = false;
        } else {
            this.fallenTick = this.level.func_82737_E();
        }
    }

    public boolean isDownedByPlayer() {
        return this.isDownedByPlayer;
    }

    public UUID getOtherPlayer() {
        return this.otherPlayer;
    }

    public boolean isReviver(UUID targUUID) {
        if (targUUID == null) {
            return false;
        }
        if (this.getOtherPlayer() == null) {
            return false;
        }
        return this.getOtherPlayer().equals(targUUID);
    }

    public void setOtherPlayer(UUID playerID) {
        this.otherPlayer = playerID;
    }

    public void setProgress(long timeStart, int seconds) {
        this.revStart = timeStart;
        this.revEnd = seconds * 20;
    }

    public float getProgress(boolean divideByMax) {
        long passedTicks = Math.min((long)this.revEnd, this.level.func_82737_E() - this.revStart);
        return divideByMax ? (float)passedTicks / (float)this.revEnd : (float)passedTicks;
    }

    public SELFREVIVETYPE getSelfReviveOption(int mouseButton) {
        return this.selfReviveTypeList.get(mouseButton);
    }

    public void useReviveOption(SELFREVIVETYPE selectedOption, PlayerEntity player) {
        PlayerInventory playerInv = player.field_71071_by;
        double penaltyPercentage = this.getSelfPenaltyPercentage();
        ++this.selfReviveCount;
        this.selfReviveTypeList.remove((Object)selectedOption);
        this.selfReviveTypeList.add(selectedOption);
        switch (selectedOption) {
            case CHANCE: {
                if ((double)player.field_70170_p.field_73012_v.nextFloat() < ReviveMeConfig.reviveChance * (1.0 - penaltyPercentage)) {
                    FallenTimerEvent.revivePlayer(player, false);
                    return;
                }
                if (ReviveMeConfig.reviveChanceKillOnFail) break;
                player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187635_cQ, SoundCategory.PLAYERS, MathUtil.randomFloat((float)0.7f, (float)1.0f), MathUtil.randomFloat((float)0.8f, (float)1.0f));
                if (!this.canSelfRevive() && !player.func_184102_h().func_71262_S() && player.func_184102_h().func_71233_x() == 1) break;
                this.refreshSelfReviveTypes(player);
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_218657_a(player.func_189512_bd(), this.writeNBT());
                NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SyncClientCapMsg((INBT)nbt));
                return;
            }
            case RANDOM_ITEMS: {
                if (this.getItemList().isEmpty()) break;
                FallenTimerEvent.revivePlayer(player, false);
                block8: for (ItemStack sacrificeStack : this.getItemList()) {
                    int count = FallenCapability.countItem(playerInv, sacrificeStack);
                    int amountToLose = (int)Math.round(Math.max(1.0, (double)count * (ReviveMeConfig.sacrificialItemPercent * (1.0 + penaltyPercentage))));
                    for (int a = 0; a < playerInv.func_70302_i_(); ++a) {
                        ItemStack containerStack;
                        if (!ReviveMeConfig.sacrificialItemTakesHotbar && (a < 9 || a == 40) || !sacrificeStack.func_77969_a(containerStack = playerInv.func_70301_a(a)) || !ItemStack.func_77970_a((ItemStack)sacrificeStack, (ItemStack)containerStack)) continue;
                        int takeAway = Math.min(amountToLose, containerStack.func_190916_E());
                        containerStack.func_190920_e(containerStack.func_190916_E() - takeAway);
                        if ((amountToLose -= takeAway) == 0) continue block8;
                    }
                }
                this.sacrificialItems.clear();
                return;
            }
            case SPECIFIC_ITEM: {
                Pair<Integer, List<ItemStack>> specificPair = this.getSpecificItem(player);
                if ((Integer)specificPair.getKey() < ReviveMeConfig.specificItemCount) break;
                FallenTimerEvent.revivePlayer(player, false);
                int amountLeft = (Integer)specificPair.getKey();
                ItemStack defaultStack = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(ReviveMeConfig.specificItem)));
                if (!ReviveMeConfig.specificItemData.isEmpty()) {
                    defaultStack.func_196082_o().func_197643_a(ReviveMeConfig.specificItemData);
                }
                for (int a = 0; a < playerInv.func_70302_i_(); ++a) {
                    ItemStack containerStack = playerInv.func_70301_a(a);
                    if (!defaultStack.func_77969_a(containerStack) || !ItemStack.func_77970_a((ItemStack)defaultStack, (ItemStack)containerStack)) continue;
                    int takeAway = Math.min(amountLeft, containerStack.func_190916_E());
                    containerStack.func_190920_e(containerStack.func_190916_E() - takeAway);
                    if ((amountLeft -= takeAway) == 0) break;
                }
                return;
            }
            case KILL: {
                FallenTimerEvent.revivePlayer(player, false);
                int seconds = (int)((double)(ReviveMeConfig.reviveKillTime * 20) * (1.0 - penaltyPercentage));
                int killCount = ReviveMeConfig.reviveKillAmount;
                player.func_195064_c(new EffectInstance(EffectInit.KILL_REVIVE_EFFECT, seconds, killCount - 1));
                return;
            }
            case STATUS_EFFECTS: {
                double invulnTime = ReviveMeConfig.reviveInvulnTime;
                if (ReviveMeConfig.disableReviveEffects) {
                    ReviveMeConfig.reviveInvulnTime = 0.0;
                }
                FallenTimerEvent.revivePlayer(player, false);
                ReviveMeConfig.reviveInvulnTime = invulnTime;
                int amp = 0;
                int duration = (int)((double)(20 * ReviveMeConfig.negativeEffectsTime) * (1.0 + penaltyPercentage));
                if (this.negativeStatusEffects.size() == 1) {
                    amp = 1;
                }
                for (Effect effect : this.negativeStatusEffects) {
                    player.func_195064_c(new EffectInstance(effect, duration, amp));
                }
                return;
            }
            case EXPERIENCE: {
                if (player.field_71068_ca < ReviveMeConfig.minReviveXPLevel) break;
                FallenTimerEvent.revivePlayer(player, false);
                player.func_82242_a((int)(-((double)player.field_71068_ca * ReviveMeConfig.reviveXPLossPercentage * (1.0 + penaltyPercentage))));
                return;
            }
        }
        this.kill(player);
    }

    public void resetSelfReviveCount() {
        this.selfReviveCount = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void refreshSelfReviveTypes(PlayerEntity player) {
        if (!this.selfReviveTypeList.containsAll(ReviveMeConfig.selfReviveOptions) || this.selfReviveTypeList.size() != ReviveMeConfig.selfReviveOptions.size()) {
            this.selfReviveTypeList = new ArrayList<SELFREVIVETYPE>(ReviveMeConfig.selfReviveOptions);
        }
        if (ReviveMeConfig.randomizeSelfReviveOptions) {
            Collections.shuffle(this.selfReviveTypeList);
        }
        if (this.selfReviveTypeList.contains((Object)SELFREVIVETYPE.RANDOM_ITEMS)) {
            this.setSacrificialItems(player.field_71071_by);
        }
        if (this.selfReviveTypeList.contains((Object)SELFREVIVETYPE.STATUS_EFFECTS)) {
            this.negativeStatusEffects.clear();
            this.negativeStatusEffects.addAll(CommonUtil.pickRandomObjectsFromList((int)(Math.random() > 0.5 ? 1 : 2), ReviveMeConfig.harmfulEffects));
        }
        int count = 0;
        if (!ReviveMeConfig.onlyUseAvailableOptions) return;
        int a = 0;
        while (a < this.selfReviveTypeList.size()) {
            block11: {
                if (count == 2) {
                    return;
                }
                switch (this.selfReviveTypeList.get(a)) {
                    case RANDOM_ITEMS: {
                        if (!this.getItemList().isEmpty()) break;
                        break block11;
                    }
                    case SPECIFIC_ITEM: {
                        if ((Integer)this.getSpecificItem(player).getKey() != 0) break;
                        break block11;
                    }
                    case EXPERIENCE: {
                        if (player.field_71068_ca < ReviveMeConfig.minReviveXPLevel) break block11;
                    }
                }
                this.selfReviveTypeList.add(0, this.selfReviveTypeList.remove(a));
                ++count;
            }
            ++a;
        }
    }

    public Pair<Integer, List<ItemStack>> getSpecificItem(PlayerEntity player) {
        ItemStack defaultStack = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(ReviveMeConfig.specificItem)));
        if (!ReviveMeConfig.specificItemData.isEmpty()) {
            defaultStack.func_196082_o().func_197643_a(ReviveMeConfig.specificItemData);
        }
        PlayerInventory playerInv = player.field_71071_by;
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        int countNeeded = ReviveMeConfig.specificItemCount;
        int count = 0;
        for (int a = 0; a < playerInv.func_70302_i_(); ++a) {
            ItemStack containerStack = playerInv.func_70301_a(a);
            if (!defaultStack.func_77969_a(containerStack) || !ItemStack.func_77970_a((ItemStack)containerStack, (ItemStack)defaultStack)) continue;
            stackList.add(containerStack);
            if ((count += containerStack.func_190916_E()) >= countNeeded) break;
        }
        if (count == 0) {
            stackList.add(defaultStack);
        }
        count = Math.min(count, countNeeded);
        return Pair.of((Object)count, stackList);
    }

    public List<Effect> getNegativeStatusEffects() {
        return new ArrayList<Effect>(this.negativeStatusEffects);
    }

    public double getSelfPenaltyPercentage() {
        return (double)this.getSelfReviveCount() * ReviveMeConfig.selfPenaltyPercentage;
    }

    public int getSelfReviveCount() {
        return this.selfReviveCount;
    }

    public void setSacrificialItems(PlayerInventory inventory) {
        if (inventory == null) {
            return;
        }
        Pair<Integer, List<ItemStack>> specificPair = this.getSpecificItem(inventory.field_70458_d);
        ArrayList<ItemStack> playerItems = new ArrayList<ItemStack>();
        for (int a = 0; a < inventory.field_70462_a.size(); ++a) {
            ItemStack newStack;
            if (!ReviveMeConfig.sacrificialItemTakesHotbar && (a < 9 || a == 40) || !(newStack = inventory.func_70301_a(a)).func_77985_e() || ((List)specificPair.getValue()).contains(newStack) || playerItems.stream().anyMatch(listStack -> listStack.func_77969_a(newStack) && ItemStack.func_77970_a((ItemStack)listStack, (ItemStack)newStack)) || newStack.func_190926_b()) continue;
            playerItems.add(this.level.field_73012_v.nextInt(Math.max(1, playerItems.size())), newStack.func_77946_l());
        }
        while (playerItems.size() > 4) {
            playerItems.remove(this.level.field_73012_v.nextInt(playerItems.size()));
        }
        this.sacrificialItems = playerItems;
    }

    public ArrayList<ItemStack> getItemList() {
        return new ArrayList<ItemStack>(this.sacrificialItems);
    }

    public boolean isSacrificialItem(ItemStack mainStack) {
        if (!this.canSelfRevive()) {
            return false;
        }
        return this.sacrificialItems.stream().anyMatch(sacrificialStack -> sacrificialStack.func_77969_a(mainStack) && ItemStack.func_77970_a((ItemStack)mainStack, (ItemStack)sacrificialStack));
    }

    public static int countItem(PlayerInventory inventory, ItemStack sacrificialStack) {
        int count = 0;
        for (int a = 0; a < inventory.func_70302_i_(); ++a) {
            ItemStack containerStack;
            if (!ReviveMeConfig.sacrificialItemTakesHotbar && (a < 9 || a == 40) || !sacrificialStack.func_77969_a(containerStack = inventory.func_70301_a(a)) || !ItemStack.func_77970_a((ItemStack)sacrificialStack, (ItemStack)containerStack)) continue;
            count += containerStack.func_190916_E();
        }
        return count;
    }

    public int getPenaltyMultiplier() {
        return this.penaltyMultiplier;
    }

    public long getPenaltyTicks(double ticks) {
        double multiplier = (double)this.getPenaltyMultiplier() * ReviveMeConfig.timeReductionPenalty;
        if (ReviveMeConfig.timeReductionPenalty == -1.0) {
            multiplier = (double)this.getPenaltyMultiplier() * ticks;
        } else if (ReviveMeConfig.timeReductionPenalty < 1.0) {
            multiplier *= ticks;
        } else if (ReviveMeConfig.timeReductionPenalty >= 1.0) {
            multiplier *= 20.0;
        }
        return (long)Math.max(0.0, ticks - multiplier);
    }

    public void setPenaltyMultiplier(int newMultiplier) {
        this.penaltyMultiplier = newMultiplier;
    }

    public void saveEffects(PlayerEntity player) {
        CompoundNBT effectsTag = new CompoundNBT();
        for (EffectInstance effectInstance : new ArrayList(player.func_70651_bq())) {
            if (effectInstance.func_76459_b() <= 20) continue;
            CompoundNBT savedEffectTag = new CompoundNBT();
            effectInstance.func_82719_a(savedEffectTag);
            effectsTag.func_218657_a(effectsTag.func_186856_d() + "", (INBT)savedEffectTag);
        }
        this.savedEffectsTag = effectsTag;
    }

    public void loadEffects(PlayerEntity player) {
        for (String key : this.savedEffectsTag.func_150296_c()) {
            EffectInstance instance = EffectInstance.func_82722_b((CompoundNBT)this.savedEffectsTag.func_74775_l(key));
            if (instance == null) continue;
            player.func_195064_c(instance);
        }
        this.savedEffectsTag = new CompoundNBT();
    }

    public INBT writeNBT() {
        CompoundNBT cNBT = new CompoundNBT();
        cNBT.func_74772_a(FELL_START_LONG, this.fellStart);
        cNBT.func_74780_a(FELL_END_DOUBLE, this.fellEnd / 20.0);
        cNBT.func_74757_a(FALLEN_BOOL, this.isFallen);
        cNBT.func_74772_a(REVIVE_START_LONG, this.revStart);
        cNBT.func_74768_a(REVIVE_END_INT, this.revEnd / 20);
        String selfReviveListString = "";
        for (SELFREVIVETYPE selfrevivetype : this.selfReviveTypeList) {
            selfReviveListString = selfReviveListString.concat(selfrevivetype.name() + ",");
        }
        cNBT.func_74778_a(SELF_REVIVE_OPTIONS_STRING, selfReviveListString);
        CompoundNBT statusEffectNBT = new CompoundNBT();
        int count = 0;
        for (Effect effect : this.negativeStatusEffects) {
            statusEffectNBT.func_74774_a(Integer.toString(count), (byte)Effect.func_188409_a((Effect)effect));
            ++count;
        }
        cNBT.func_218657_a(STATUS_EFFECTS_COMPOUND, (INBT)statusEffectNBT);
        CompoundNBT itemCompound = new CompoundNBT();
        for (ItemStack item : this.sacrificialItems) {
            itemCompound.func_218657_a(itemCompound.func_186856_d() + "", (INBT)item.serializeNBT());
        }
        cNBT.func_218657_a(SACRIFICEITEMS_COMPOUND, (INBT)itemCompound);
        cNBT.func_74768_a(PENALTY_MULTIPLIER_INT, this.penaltyMultiplier);
        cNBT.func_74772_a(CALLED_FOR_HELP_LONG, this.calledForHelpTime);
        cNBT.func_218657_a(SAVED_EFFECTS_TAG, (INBT)this.savedEffectsTag);
        if (this.otherPlayer != null) {
            cNBT.func_186854_a(OTHERPLAYER_UUID, this.otherPlayer);
        }
        cNBT.func_74768_a(SELF_REVIVE_COUNT_INT, this.selfReviveCount);
        cNBT.func_74757_a(DOWNED_BY_PLAYER_BOOL, this.isDownedByPlayer());
        cNBT.func_74757_a(IS_EFFECTS_REMOVED, this.isEffectsRemoved);
        return cNBT;
    }

    public void readNBT(INBT nbt) {
        CompoundNBT cNBT = (CompoundNBT)nbt;
        this.SetTimeLeft(cNBT.func_74763_f(FELL_START_LONG), cNBT.func_74769_h(FELL_END_DOUBLE));
        this.setFallen(cNBT.func_74767_n(FALLEN_BOOL));
        this.setProgress(cNBT.func_74763_f(REVIVE_START_LONG), cNBT.func_74762_e(REVIVE_END_INT));
        this.selfReviveTypeList.clear();
        for (String s : cNBT.func_74779_i(SELF_REVIVE_OPTIONS_STRING).split(",")) {
            try {
                this.selfReviveTypeList.add(SELFREVIVETYPE.valueOf(s));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.selfReviveTypeList.isEmpty()) {
            this.selfReviveTypeList.addAll(ReviveMeConfig.selfReviveOptions);
        }
        this.negativeStatusEffects.clear();
        CompoundNBT statusEffectNBT = cNBT.func_74775_l(STATUS_EFFECTS_COMPOUND);
        for (String s : statusEffectNBT.func_150296_c()) {
            this.negativeStatusEffects.add(Effect.func_188412_a((int)statusEffectNBT.func_74771_c(s)));
        }
        this.sacrificialItems.clear();
        CompoundNBT itemCompound = cNBT.func_74775_l(SACRIFICEITEMS_COMPOUND);
        if (!itemCompound.isEmpty()) {
            for (String key : itemCompound.func_150296_c()) {
                ItemStack sacrificeStack = ItemStack.func_199557_a((CompoundNBT)itemCompound.func_74775_l(key));
                if (sacrificeStack.func_190926_b()) continue;
                this.sacrificialItems.add(sacrificeStack);
            }
        }
        this.penaltyMultiplier = cNBT.func_74762_e(PENALTY_MULTIPLIER_INT);
        this.calledForHelpTime = cNBT.func_74763_f(CALLED_FOR_HELP_LONG);
        this.savedEffectsTag = cNBT.func_74775_l(SAVED_EFFECTS_TAG);
        if (cNBT.func_186855_b(OTHERPLAYER_UUID)) {
            this.setOtherPlayer(cNBT.func_186857_a(OTHERPLAYER_UUID));
        } else {
            this.setOtherPlayer(null);
        }
        this.selfReviveCount = cNBT.func_74762_e(SELF_REVIVE_COUNT_INT);
        this.isDownedByPlayer = cNBT.func_74767_n(DOWNED_BY_PLAYER_BOOL);
        this.isEffectsRemoved = cNBT.func_74767_n(IS_EFFECTS_REMOVED);
    }

    public static class FallenNBTStorage
    implements Capability.IStorage<FallenCapability> {
        @Nullable
        public INBT writeNBT(Capability<FallenCapability> capability, FallenCapability instance, Direction side) {
            return instance.writeNBT();
        }

        public void readNBT(Capability<FallenCapability> capability, FallenCapability instance, Direction side, INBT nbt) {
            instance.readNBT(nbt);
        }
    }

    public static enum SELFREVIVETYPE {
        CHANCE,
        RANDOM_ITEMS,
        SPECIFIC_ITEM,
        KILL,
        STATUS_EFFECTS,
        EXPERIENCE;

    }

    public static enum PENALTYPE {
        NONE,
        HEALTH,
        EXPERIENCE,
        FOOD,
        ITEM;

    }
}

