/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.common.config;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import invoker54.invocore.common.ModLogger;
import invoker54.reviveme.common.capability.FallenCapability;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectType;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="reviveme", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ReviveMeConfig {
    public static final CommonConfig COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final ModLogger LOGGER;
    public static Integer timeLeft;
    public static Integer reviveTime;
    public static Double revivedHealth;
    public static Double revivedFood;
    public static FallenCapability.PENALTYPE penaltyType;
    public static Double penaltyAmount;
    public static String penaltyItem;
    public static CompoundNBT penaltyItemData;
    public static boolean cancelReviveOnDamage;
    public static Double reviveInvulnTime;
    public static List<FallenCapability.SELFREVIVETYPE> selfReviveOptions;
    public static Integer maxSelfRevives;
    public static boolean disableSelfReviveIfPlayerDowned;
    public static boolean randomizeSelfReviveOptions;
    public static boolean onlyUseAvailableOptions;
    public static Double selfPenaltyPercentage;
    public static Double reviveChance;
    public static boolean reviveChanceKillOnFail;
    public static Double sacrificialItemPercent;
    public static boolean sacrificialItemTakesHotbar;
    public static String specificItem;
    public static boolean showSpecificItemName;
    public static Integer specificItemCount;
    public static CompoundNBT specificItemData;
    public static Integer reviveKillAmount;
    public static Integer reviveKillTime;
    public static List<Effect> harmfulEffects;
    public static Integer negativeEffectsTime;
    public static boolean disableReviveEffects;
    public static double reviveXPLossPercentage;
    public static Integer minReviveXPLevel;
    public static Double fallenPenaltyTimer;
    public static boolean runDeathEventFirst;
    public static boolean canGiveUp;
    public static boolean dieOnDisconnect;
    public static Double reviveHelpDuration;
    public static Double reviveGlowMaxDistance;
    public static Double deathTimerMaxDistance;
    public static FALLEN_POSE fallenPose;
    public static JUMP canJump;
    public static boolean canMove;
    public static INTERACT_WITH_INVENTORY interactWithInventory;
    public static double timeReductionPenalty;
    public static Integer pvpTimer;
    public static boolean revertEffectsOnRevive;
    public static List<String> downedEffects;
    public static List<String> blockedCommands;
    public static List<String> allowedKeybinds;
    public static boolean silenceRegularMessages;
    public static boolean silenceCommandMessages;
    public static boolean universalChatMessages;
    public static final AtomicBoolean debugMode;
    public static Boolean compactReviveUI;
    public static Double soundLevel;
    private static boolean isDirty;

    public static void bakeConfig() {
        timeLeft = (Integer)ReviveMeConfig.COMMON.timeLeft.get();
        reviveTime = (Integer)ReviveMeConfig.COMMON.reviveTime.get();
        revivedHealth = (Double)ReviveMeConfig.COMMON.revivedHealth.get();
        revivedFood = (Double)ReviveMeConfig.COMMON.revivedFood.get();
        penaltyType = (FallenCapability.PENALTYPE)((Object)ReviveMeConfig.COMMON.penaltyType.get());
        penaltyAmount = (Double)ReviveMeConfig.COMMON.penaltyAmount.get();
        penaltyItem = (String)ReviveMeConfig.COMMON.penaltyItem.get();
        try {
            penaltyItemData = JsonToNBT.func_180713_a((String)((String)ReviveMeConfig.COMMON.penaltyItemData.get()));
        }
        catch (CommandSyntaxException e2) {
            LOGGER.error("There's a typo somewhere in 'Revive_Item_Data' config for Self Revival! (Revive Me! Mod)");
            LOGGER.error(e2.getMessage());
            penaltyItemData = new CompoundNBT();
        }
        cancelReviveOnDamage = (Boolean)ReviveMeConfig.COMMON.cancelReviveOnDamage.get();
        reviveInvulnTime = (Double)ReviveMeConfig.COMMON.reviveInvulnTime.get();
        selfReviveOptions = ((List)ReviveMeConfig.COMMON.selfReviveOptions.get()).stream().map(FallenCapability.SELFREVIVETYPE::valueOf).collect(Collectors.toList());
        if (selfReviveOptions.isEmpty()) {
            selfReviveOptions.add(FallenCapability.SELFREVIVETYPE.CHANCE);
        }
        if (selfReviveOptions.size() == 1) {
            selfReviveOptions.add(selfReviveOptions.get(0));
        }
        maxSelfRevives = (Integer)ReviveMeConfig.COMMON.maxSelfRevives.get();
        disableSelfReviveIfPlayerDowned = (Boolean)ReviveMeConfig.COMMON.disableSelfReviveIfPlayerDowned.get();
        randomizeSelfReviveOptions = (Boolean)ReviveMeConfig.COMMON.randomizeSelfReviveOptions.get();
        onlyUseAvailableOptions = (Boolean)ReviveMeConfig.COMMON.onlyUseAvailableOptions.get();
        selfPenaltyPercentage = (Double)ReviveMeConfig.COMMON.selfPenaltyPercentage.get();
        reviveChance = (Double)ReviveMeConfig.COMMON.reviveChance.get();
        reviveChanceKillOnFail = (Boolean)ReviveMeConfig.COMMON.reviveChanceKillOnFail.get();
        sacrificialItemPercent = (Double)ReviveMeConfig.COMMON.sacrificialItemPercent.get();
        sacrificialItemTakesHotbar = (Boolean)ReviveMeConfig.COMMON.sacrificialItemTakesHotbar.get();
        specificItem = (String)ReviveMeConfig.COMMON.specificItem.get();
        showSpecificItemName = (Boolean)ReviveMeConfig.COMMON.showSpecificItemName.get();
        specificItemCount = (Integer)ReviveMeConfig.COMMON.specificItemCount.get();
        try {
            specificItemData = JsonToNBT.func_180713_a((String)((String)ReviveMeConfig.COMMON.specificItemData.get()));
        }
        catch (CommandSyntaxException e3) {
            LOGGER.error("There's a typo somewhere in 'Item_Data' config for Self Revival! (Revive Me! Mod)");
            LOGGER.error(e3.getMessage());
            specificItemData = new CompoundNBT();
        }
        reviveKillAmount = (Integer)ReviveMeConfig.COMMON.reviveKillAmount.get();
        reviveKillTime = (Integer)ReviveMeConfig.COMMON.reviveKillTime.get();
        List harmfulEffectsBlackList = (List)ReviveMeConfig.COMMON.harmfulEffectsBlackList.get();
        Stream<Effect> negativeEffects = ForgeRegistries.POTIONS.getValues().stream().filter(e -> e.func_220303_e() == EffectType.HARMFUL);
        harmfulEffects = harmfulEffectsBlackList.contains("//") ? negativeEffects.filter(a -> harmfulEffectsBlackList.stream().anyMatch(b -> !b.isEmpty() && a.getRegistryName().toString().contains((CharSequence)b))).collect(Collectors.toList()) : negativeEffects.filter(a -> harmfulEffectsBlackList.stream().anyMatch(b -> b.isEmpty() || !a.getRegistryName().toString().contains((CharSequence)b))).collect(Collectors.toList());
        negativeEffectsTime = (Integer)ReviveMeConfig.COMMON.negativeEffectsTime.get();
        disableReviveEffects = (Boolean)ReviveMeConfig.COMMON.disableReviveEffects.get();
        reviveXPLossPercentage = (Double)ReviveMeConfig.COMMON.reviveXPLossPercentage.get();
        minReviveXPLevel = (Integer)ReviveMeConfig.COMMON.minReviveXPLevel.get();
        fallenPenaltyTimer = (Double)ReviveMeConfig.COMMON.fallenPenaltyTimer.get();
        runDeathEventFirst = (Boolean)ReviveMeConfig.COMMON.runDeathEventFirst.get();
        canGiveUp = (Boolean)ReviveMeConfig.COMMON.canGiveUp.get();
        dieOnDisconnect = (Boolean)ReviveMeConfig.COMMON.dieOnDisconnect.get();
        reviveHelpDuration = (Double)ReviveMeConfig.COMMON.reviveHelpDuration.get();
        reviveGlowMaxDistance = (Double)ReviveMeConfig.COMMON.reviveGlowMaxDistance.get();
        deathTimerMaxDistance = (Double)ReviveMeConfig.COMMON.deathTimerMaxDistance.get();
        fallenPose = (FALLEN_POSE)((Object)ReviveMeConfig.COMMON.fallenPose.get());
        canJump = (JUMP)((Object)ReviveMeConfig.COMMON.canJump.get());
        canMove = (Boolean)ReviveMeConfig.COMMON.canMove.get();
        interactWithInventory = (INTERACT_WITH_INVENTORY)((Object)ReviveMeConfig.COMMON.interactWithInventory.get());
        timeReductionPenalty = (Double)ReviveMeConfig.COMMON.timeReductionPenalty.get();
        pvpTimer = (Integer)ReviveMeConfig.COMMON.pvpTimer.get();
        revertEffectsOnRevive = (Boolean)ReviveMeConfig.COMMON.revertEffectsOnRevive.get();
        downedEffects = (List)ReviveMeConfig.COMMON.downedEffects.get();
        blockedCommands = (List)ReviveMeConfig.COMMON.blockedCommands.get();
        allowedKeybinds = (List)ReviveMeConfig.COMMON.allowedKeybinds.get();
        compactReviveUI = (Boolean)ReviveMeConfig.COMMON.compactReviveUI.get();
        soundLevel = (Double)ReviveMeConfig.COMMON.soundLevel.get();
        silenceRegularMessages = (Boolean)ReviveMeConfig.COMMON.silenceRegularMessages.get();
        silenceCommandMessages = (Boolean)ReviveMeConfig.COMMON.silenceCommandMessages.get();
        universalChatMessages = (Boolean)ReviveMeConfig.COMMON.universalChatMessages.get();
        debugMode.set((Boolean)ReviveMeConfig.COMMON.debugMode.get());
    }

    /*
     * WARNING - void declaration
     */
    public static CompoundNBT serialize() {
        void var3_6;
        CompoundNBT mainTag = new CompoundNBT();
        mainTag.func_74768_a("timeLeft", timeLeft.intValue());
        mainTag.func_74778_a("penaltyType", penaltyType.name());
        mainTag.func_74780_a("penaltyAmount", penaltyAmount.doubleValue());
        mainTag.func_74778_a("penaltyItem", penaltyItem);
        mainTag.func_218657_a("penaltyItemData", (INBT)penaltyItemData);
        String allSelfReviveOptions = "";
        for (FallenCapability.SELFREVIVETYPE sELFREVIVETYPE : selfReviveOptions) {
            allSelfReviveOptions = allSelfReviveOptions.concat(sELFREVIVETYPE.name() + ",");
        }
        mainTag.func_74778_a("selfReviveOptions", allSelfReviveOptions);
        mainTag.func_74768_a("maxSelfRevives", maxSelfRevives.intValue());
        mainTag.func_74757_a("disableSelfReviveIfPlayerDowned", disableSelfReviveIfPlayerDowned);
        mainTag.func_74757_a("randomizeSelfReviveOptions", randomizeSelfReviveOptions);
        mainTag.func_74780_a("selfPenaltyPercentage", selfPenaltyPercentage.doubleValue());
        mainTag.func_74780_a("reviveChance", reviveChance.doubleValue());
        mainTag.func_74780_a("sacrificialItemPercent", sacrificialItemPercent.doubleValue());
        mainTag.func_74778_a("specificItem", specificItem);
        mainTag.func_74757_a("showSpecificItemName", showSpecificItemName);
        mainTag.func_74768_a("specificItemCount", specificItemCount.intValue());
        mainTag.func_218657_a("specificItemData", (INBT)specificItemData);
        mainTag.func_74768_a("reviveKillAmount", reviveKillAmount.intValue());
        mainTag.func_74768_a("reviveKillTime", reviveKillTime.intValue());
        mainTag.func_74768_a("negativeEffectsTime", negativeEffectsTime.intValue());
        mainTag.func_74780_a("reviveXPLossPercentage", reviveXPLossPercentage);
        mainTag.func_74768_a("minReviveXPLevel", minReviveXPLevel.intValue());
        mainTag.func_74757_a("runDeathEventFirst", runDeathEventFirst);
        mainTag.func_74757_a("canGiveUp", canGiveUp);
        mainTag.func_74780_a("reviveHelpDuration", reviveHelpDuration.doubleValue());
        mainTag.func_74780_a("reviveGlowMaxDistance", reviveGlowMaxDistance.doubleValue());
        mainTag.func_74780_a("deathTimerMaxDistance", deathTimerMaxDistance.doubleValue());
        mainTag.func_74778_a("fallenPose", fallenPose.toString());
        mainTag.func_74778_a("canJump", canJump.toString());
        mainTag.func_74757_a("canMove", canMove);
        mainTag.func_74778_a("interactWithInventory", interactWithInventory.toString());
        mainTag.func_74780_a("timeReductionPenalty", timeReductionPenalty);
        mainTag.func_74768_a("pvpTimer", pvpTimer.intValue());
        String allBlockedCommands = "";
        for (String string : blockedCommands) {
            allBlockedCommands = allBlockedCommands.concat(string + ",");
        }
        mainTag.func_74778_a("blockedCommands", allBlockedCommands);
        String string = "";
        for (String s : allowedKeybinds) {
            String string2 = var3_6.concat(s + ",");
        }
        mainTag.func_74778_a("allowedKeybinds", (String)var3_6);
        return mainTag;
    }

    public static void deserialize(CompoundNBT mainTag) {
        timeLeft = mainTag.func_74762_e("timeLeft");
        penaltyType = FallenCapability.PENALTYPE.valueOf(mainTag.func_74779_i("penaltyType"));
        penaltyAmount = mainTag.func_74769_h("penaltyAmount");
        penaltyItem = mainTag.func_74779_i("penaltyItem");
        penaltyItemData = mainTag.func_74775_l("penaltyItemData");
        String[] allSelfReviveOptions = mainTag.func_74779_i("selfReviveOptions").split(",");
        selfReviveOptions.clear();
        for (String reviveType : allSelfReviveOptions) {
            selfReviveOptions.add(FallenCapability.SELFREVIVETYPE.valueOf(reviveType));
        }
        maxSelfRevives = mainTag.func_74762_e("maxSelfRevives");
        disableSelfReviveIfPlayerDowned = mainTag.func_74767_n("disableSelfReviveIfPlayerDowned");
        randomizeSelfReviveOptions = mainTag.func_74767_n("randomizeSelfReviveOptions");
        selfPenaltyPercentage = mainTag.func_74769_h("selfPenaltyPercentage");
        reviveChance = mainTag.func_74769_h("reviveChance");
        sacrificialItemPercent = mainTag.func_74769_h("sacrificialItemPercent");
        specificItem = mainTag.func_74779_i("specificItem");
        showSpecificItemName = mainTag.func_74767_n("showSpecificItemName");
        specificItemCount = mainTag.func_74762_e("specificItemCount");
        specificItemData = mainTag.func_74775_l("specificItemData");
        reviveKillAmount = mainTag.func_74762_e("reviveKillAmount");
        reviveKillTime = mainTag.func_74762_e("reviveKillTime");
        negativeEffectsTime = mainTag.func_74762_e("negativeEffectsTime");
        reviveXPLossPercentage = mainTag.func_74769_h("reviveXPLossPercentage");
        minReviveXPLevel = mainTag.func_74762_e("minReviveXPLevel");
        runDeathEventFirst = mainTag.func_74767_n("runDeathEventFirst");
        canGiveUp = mainTag.func_74767_n("canGiveUp");
        reviveHelpDuration = mainTag.func_74769_h("reviveHelpDuration");
        reviveGlowMaxDistance = mainTag.func_74769_h("reviveGlowMaxDistance");
        deathTimerMaxDistance = mainTag.func_74769_h("deathTimerMaxDistance");
        fallenPose = FALLEN_POSE.valueOf(mainTag.func_74779_i("fallenPose"));
        canJump = JUMP.valueOf(mainTag.func_74779_i("canJump"));
        canMove = mainTag.func_74767_n("canMove");
        interactWithInventory = INTERACT_WITH_INVENTORY.valueOf(mainTag.func_74779_i("interactWithInventory"));
        timeReductionPenalty = mainTag.func_74769_h("timeReductionPenalty");
        pvpTimer = mainTag.func_74762_e("pvpTimer");
        blockedCommands = Arrays.asList(mainTag.func_74779_i("blockedCommands").split(","));
        allowedKeybinds = Arrays.asList(mainTag.func_74779_i("allowedKeybinds").split(","));
    }

    @SubscribeEvent
    public static void onConfigChanged(ModConfig.ModConfigEvent eventConfig) {
        if (eventConfig.getConfig().getSpec() == COMMON_SPEC) {
            ReviveMeConfig.bakeConfig();
            ReviveMeConfig.markDirty(true);
        }
    }

    public static void markDirty(boolean dirty) {
        isDirty = dirty;
    }

    public static boolean isDirty() {
        return isDirty;
    }

    static {
        LOGGER = ModLogger.getLogger(ReviveMeConfig.class, (AtomicBoolean)debugMode);
        selfReviveOptions = new ArrayList<FallenCapability.SELFREVIVETYPE>();
        harmfulEffects = new ArrayList<Effect>();
        debugMode = new AtomicBoolean(true);
        compactReviveUI = false;
        soundLevel = 0.0;
        isDirty = false;
        Pair specPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (CommonConfig)specPair.getLeft();
    }

    public static class CommonConfig {
        public final ForgeConfigSpec.ConfigValue<Integer> timeLeft;
        public final ForgeConfigSpec.ConfigValue<Integer> reviveTime;
        public final ForgeConfigSpec.ConfigValue<Double> revivedHealth;
        public final ForgeConfigSpec.ConfigValue<Double> revivedFood;
        public final ForgeConfigSpec.EnumValue<FallenCapability.PENALTYPE> penaltyType;
        public final ForgeConfigSpec.ConfigValue<Double> penaltyAmount;
        public final ForgeConfigSpec.ConfigValue<String> penaltyItem;
        public final ForgeConfigSpec.ConfigValue<String> penaltyItemData;
        public final ForgeConfigSpec.ConfigValue<Boolean> cancelReviveOnDamage;
        public final ForgeConfigSpec.ConfigValue<Double> reviveInvulnTime;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> selfReviveOptions;
        public final ForgeConfigSpec.ConfigValue<Integer> maxSelfRevives;
        public final ForgeConfigSpec.ConfigValue<Boolean> disableSelfReviveIfPlayerDowned;
        public final ForgeConfigSpec.ConfigValue<Boolean> randomizeSelfReviveOptions;
        public final ForgeConfigSpec.ConfigValue<Boolean> onlyUseAvailableOptions;
        public final ForgeConfigSpec.ConfigValue<Double> selfPenaltyPercentage;
        public final ForgeConfigSpec.ConfigValue<Double> reviveChance;
        public final ForgeConfigSpec.ConfigValue<Boolean> reviveChanceKillOnFail;
        public final ForgeConfigSpec.ConfigValue<Double> sacrificialItemPercent;
        public final ForgeConfigSpec.ConfigValue<Boolean> sacrificialItemTakesHotbar;
        public final ForgeConfigSpec.ConfigValue<String> specificItem;
        public final ForgeConfigSpec.ConfigValue<Boolean> showSpecificItemName;
        public final ForgeConfigSpec.ConfigValue<Integer> specificItemCount;
        public final ForgeConfigSpec.ConfigValue<String> specificItemData;
        public final ForgeConfigSpec.ConfigValue<Integer> reviveKillAmount;
        public final ForgeConfigSpec.ConfigValue<Integer> reviveKillTime;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> harmfulEffectsBlackList;
        public final ForgeConfigSpec.ConfigValue<Integer> negativeEffectsTime;
        public final ForgeConfigSpec.ConfigValue<Boolean> disableReviveEffects;
        public final ForgeConfigSpec.ConfigValue<Double> reviveXPLossPercentage;
        public final ForgeConfigSpec.ConfigValue<Integer> minReviveXPLevel;
        public final ForgeConfigSpec.ConfigValue<Double> fallenPenaltyTimer;
        public final ForgeConfigSpec.ConfigValue<Boolean> runDeathEventFirst;
        public final ForgeConfigSpec.ConfigValue<Boolean> canGiveUp;
        public final ForgeConfigSpec.ConfigValue<Boolean> dieOnDisconnect;
        public final ForgeConfigSpec.ConfigValue<Double> reviveHelpDuration;
        public final ForgeConfigSpec.ConfigValue<Double> reviveGlowMaxDistance;
        public final ForgeConfigSpec.ConfigValue<Double> deathTimerMaxDistance;
        public final ForgeConfigSpec.ConfigValue<FALLEN_POSE> fallenPose;
        public final ForgeConfigSpec.ConfigValue<JUMP> canJump;
        public final ForgeConfigSpec.ConfigValue<Boolean> canMove;
        public final ForgeConfigSpec.ConfigValue<INTERACT_WITH_INVENTORY> interactWithInventory;
        public final ForgeConfigSpec.ConfigValue<Double> timeReductionPenalty;
        public final ForgeConfigSpec.ConfigValue<Integer> pvpTimer;
        public final ForgeConfigSpec.ConfigValue<Boolean> revertEffectsOnRevive;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> downedEffects;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> blockedCommands;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> allowedKeybinds;
        public final ForgeConfigSpec.ConfigValue<Boolean> compactReviveUI;
        public final ForgeConfigSpec.ConfigValue<Double> soundLevel;
        public final ForgeConfigSpec.ConfigValue<Boolean> silenceRegularMessages;
        public final ForgeConfigSpec.ConfigValue<Boolean> silenceCommandMessages;
        public final ForgeConfigSpec.ConfigValue<Boolean> universalChatMessages;
        public final ForgeConfigSpec.ConfigValue<Boolean> debugMode;

        public CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.push("Self-Revive Settings");
            builder.push("General Settings");
            ArrayList<String> defaultSelfReviveList = new ArrayList<String>(Arrays.asList(FallenCapability.SELFREVIVETYPE.SPECIFIC_ITEM.name(), FallenCapability.SELFREVIVETYPE.RANDOM_ITEMS.name(), FallenCapability.SELFREVIVETYPE.CHANCE.name(), FallenCapability.SELFREVIVETYPE.KILL.name(), FallenCapability.SELFREVIVETYPE.STATUS_EFFECTS.name(), FallenCapability.SELFREVIVETYPE.EXPERIENCE.name()));
            this.selfReviveOptions = builder.comment("List of all your self-revive options (Duplicate options are allowed). Self-revive options refresh from this list when the revive penalty ends. OPTIONS: CHANCE, RANDOM_ITEMS, SPECIFIC_ITEM, KILL, STATUS_EFFECTS, EXPERIENCE").defineList("SELF_REVIVE_OPTIONS", new ArrayList<String>(defaultSelfReviveList), defaultSelfReviveList::contains);
            this.maxSelfRevives = builder.comment("Max self revives (setting to 0 will disable self-revive) (setting to -1 will disable the self-revive max) (In multiplayer self-revive will only be disabled when you reach the max) Refreshes when penalty timer ends.").defineInRange("Max_Self_revives", 3, -1, Integer.MAX_VALUE);
            this.disableSelfReviveIfPlayerDowned = builder.comment("If self-revive should be disabled if a player places you in the fallen state").define("Disable_Self_Revive_On_PVP", false);
            this.randomizeSelfReviveOptions = builder.comment("If the chosen self-revive options are picked randomly.").define("Randomize_Self_Revive_Options", true);
            this.onlyUseAvailableOptions = builder.comment("If the mod should only pick self-revive options that you would meet the requirements for (when possible)").define("Only_Use_Available_Options", false);
            this.selfPenaltyPercentage = builder.comment("Increases the cost of self-revival options each time you self-revive. Stacks additively. Resets to 0 on fallen penalty timer expiration.").defineInRange("Self_Penalty_Percentage", 0.25, 0.0, 1.0);
            builder.pop();
            builder.push("Revive Type Settings");
            builder.push("Chance");
            this.reviveChance = builder.comment("How high your chance is to revive. (Affected by penalty)").defineInRange("Revive_Chance", 0.75, 0.0, 1.0);
            this.reviveChanceKillOnFail = builder.comment("If you should die instantly if you fail the chance check.").define("Kill_On_Fail", false);
            builder.pop();
            builder.push("Random Items");
            this.sacrificialItemPercent = builder.comment("Percentage to lose for sacrificial items. (Affected by penalty)").defineInRange("Item_Loss_Percentage", 0.25, 0.0, 1.0);
            this.sacrificialItemTakesHotbar = builder.comment("Should check hotbar when sacrificing items").define("Include_Hotbar_Items", false);
            builder.pop();
            builder.push("Specific Item");
            this.specificItem = builder.comment("Item that you wish to sacrifice. Usage: MODID:ITEM").define("Item_ID", (Object)"minecraft:golden_apple");
            this.showSpecificItemName = builder.comment("If the item name should show").define("Show_Item_Name", true);
            this.specificItemCount = builder.comment("How much of the specific item is needed.").defineInRange("Item_Count", 3, 0, Integer.MAX_VALUE);
            this.specificItemData = builder.comment("NBT Data for the specific item (Don't forget the curly brackets! {})").define("Item_Data", (Object)"{}", s -> {
                if (s == null) {
                    return false;
                }
                if (s.equals("{}")) {
                    return true;
                }
                try {
                    return !JsonToNBT.func_180713_a((String)((String)s)).isEmpty();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            });
            builder.pop();
            builder.push("Kill");
            this.reviveKillAmount = builder.comment("Amount of Living Entities you must kill before the death timer runs out.").defineInRange("Kill_Count", 2, 0, Integer.MAX_VALUE);
            this.reviveKillTime = builder.comment("Time in SECONDS you have to kill the needed amount of Living Entities. (Affected by penalty)").defineInRange("Kill_Time", 20, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.push("Status Effects");
            this.harmfulEffectsBlackList = builder.comment("List of harmful effects that shouldn't be chosen. Add \"//\" to make it a whitelist instead. You can also use parts of an effect Usage: (ModId:PotionEffect) 'minecraft:slowness' or 'slowness' or 'minecraft'").defineList("Harmful_Effects_Blacklist", Arrays.asList("minecraft:bad_omen", "minecraft:unluck", "minecraft:instant_damage", "reviveme:kill_revive_effect"), a -> !a.toString().isEmpty() && (a.equals("//") || ForgeRegistries.POTIONS.getValues().stream().filter(effect -> effect.func_220303_e() == EffectType.HARMFUL).map(e -> e.getRegistryName().toString()).collect(Collectors.toList()).contains(a)));
            this.negativeEffectsTime = builder.comment("How long the harmful effects will last for. (Affected by penalty)").defineInRange("Effect_Duration", 12, 0, Integer.MAX_VALUE);
            this.disableReviveEffects = builder.comment("If Revive effects should be disabled when reviving with this self-revive type.").define("Disable_Revive_Effects", true);
            builder.pop();
            builder.push("XP");
            this.reviveXPLossPercentage = builder.comment("Percentage of XP you should lose to revive. (Affected by penalty)").defineInRange("XP_Loss_Percentage", (double)0.4f, 0.0, 1.0);
            this.minReviveXPLevel = builder.comment("The minimum amount of XP levels needed.").defineInRange("Minimum_XP_Level", 15, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.pop();
            builder.pop();
            builder.push("Fallen State Settings");
            builder.push("General Settings");
            this.runDeathEventFirst = builder.comment("If the regular Death Event should run first before this mod does (if Death event runs first and player death is cancelled, Revive-Me code will not execute. Same thing vice-versa.)").define("Run_Death_Event_First", true);
            this.canGiveUp = builder.comment("If you can give up and die").define("Can_Give_Up", true);
            this.dieOnDisconnect = builder.comment("If you should die instantly if you disconnect while in the fallen state").define("Die_On_Disconnect", false);
            this.interactWithInventory = builder.comment("If the player can use their inventory while fallen").defineEnum("Interact_With_Inventory", (Enum)INTERACT_WITH_INVENTORY.LOOK_ONLY);
            this.downedEffects = builder.comment("Potion effects the player has while fallen (ModId:PotionEffect:Amplification)(minecraft:slowness:0)").define("Downed_Effects", new ArrayList(ImmutableList.of((Object)"minecraft:slowness:3")));
            this.blockedCommands = builder.comment("Commands the player isn't allowed to use while fallen. Type \"/\" to block all commands. Type \"//\" to make this a whitelist.").define("Blocked_Commands", new ArrayList());
            this.allowedKeybinds = builder.comment("Keybinds that you can use while in the fallen state. (You can put a piece or the full name of a keybind. (Check the translation json for keybinding names (en_us.json for example))\nExample of binding: 'key.fullscreen' or 'fullscreen' will let you use the 'Toggle Fullscreen' keybinding while in the fallen state)").define("Allowed_Keybinds", new ArrayList());
            this.reviveHelpDuration = builder.comment("How long the Help call effects will last in SECONDS").defineInRange("Revive_Help_Duration", 10.0, 1.0, Double.MAX_VALUE);
            this.reviveGlowMaxDistance = builder.comment("How far you can see glowing players").defineInRange("Revive_Glow_Max_Distance", 80.0, 0.0, Double.MAX_VALUE);
            this.deathTimerMaxDistance = builder.comment("How far you can see the death timer for a player in the fallen state.").defineInRange("Death_Timer_Max_Distance", 40.0, 0.0, Double.MAX_VALUE);
            builder.pop();
            builder.push("Timer Settings");
            this.timeLeft = builder.comment("How long you have before death. Setting to 0 will disable the timer").defineInRange("Time_Left", 60, 0, Integer.MAX_VALUE);
            this.timeReductionPenalty = builder.comment("How much time (in seconds) your death timer loses each time you fall. (Less than 1 is a percentage of max death time, -1 will take away the max)").defineInRange("Time_Reduction_Penalty", 5.0, -1.0, Double.MAX_VALUE);
            this.fallenPenaltyTimer = builder.comment("how long the revive penalty effects will last in SECONDS").defineInRange("Revive_Penalty_Timer", 45.0, 0.0, Double.MAX_VALUE);
            this.pvpTimer = builder.comment("How much time (in seconds) must pass before you may be killed by other players. Affected by time reduction penalty. Setting to -1 will disable this").defineInRange("PVP_Timer", 10, -1, Integer.MAX_VALUE);
            builder.pop();
            builder.push("Movement Settings");
            this.fallenPose = builder.comment("What pose you have whilst fallen").defineEnum("Fallen_Pose", (Enum)FALLEN_POSE.CROUCH);
            this.canJump = builder.comment("If the player may jump while fallen").defineEnum("Can_Jump", (Enum)JUMP.YES);
            this.canMove = builder.comment("If the player may move while fallen").define("Can_Move", true);
            builder.pop();
            builder.pop();
            builder.push("Revive Settings");
            builder.push("Revivee Settings");
            this.revivedHealth = builder.comment("How much health you will be revived with, -1 is max health, Less than 1 is percentage").defineInRange("Revive_Health", 10.0, -1.0, 2.147483647E9);
            this.revivedFood = builder.comment("How much food you will be revived with, -1 is max food, Less than 1 is percentage").defineInRange("Revive_Food", 6.0, -1.0, 2.147483647E9);
            this.reviveInvulnTime = builder.comment("How many seconds of invulnerability you have on revive").defineInRange("Revive_Invuln_Time", 5.0, 0.0, 3.4028234663852886E38);
            this.revertEffectsOnRevive = builder.comment("Give back all of the potion effects the player had before entering the fallen state").define("Revert_Effects_On_Revive", false);
            builder.pop();
            builder.push("Reviver Settings");
            this.reviveTime = builder.comment("How long to revive someone").defineInRange("Revive_Time", 3, 0, Integer.MAX_VALUE);
            this.penaltyType = builder.comment("What the reviver will lose").defineEnum("Penalty_Type", (Enum)FallenCapability.PENALTYPE.FOOD);
            this.penaltyAmount = builder.comment("Amount that will be taken from reviver, Numbers below 1 and greater than 0 will turn it into a percentage").define("Penalty_Amount", (Object)10.0);
            this.penaltyItem = builder.comment("Item used to revive fallen players (Only if you selected ITEM as penalty type). Usage: MODID:ITEM").define("Revive_Item", (Object)"minecraft:golden_apple");
            this.penaltyItemData = builder.comment("Item data used to revive fallen players (Only if you selected ITEM as penalty type) (Don't forget the curly brackets! {}).").define("Revive_Item_Data", (Object)"{}", s -> {
                if (s == null) {
                    return false;
                }
                if (s.equals("{}")) {
                    return true;
                }
                try {
                    return !JsonToNBT.func_180713_a((String)((String)s)).isEmpty();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            });
            this.cancelReviveOnDamage = builder.comment("If revive should be cancelled when taking damage").define("Cancel_Revive_On_Damage", false);
            builder.pop();
            builder.pop();
            builder.push("Chat Settings");
            this.silenceRegularMessages = builder.comment("Silence the revive and fallen chat messages").define("Silence_Regular_Messages", false);
            this.silenceCommandMessages = builder.comment("Silence command chat messages").define("Silence_Command_Messages", false);
            this.universalChatMessages = builder.comment("If chat messages from this mod should be sent to everyone. If false, will only send to those nearby").define("Universal_Chat_Messages", true);
            builder.pop();
            builder.push("Client Settings");
            this.compactReviveUI = builder.comment("Makes self-revive UI smaller, more compact").define("Compact_UI", false);
            this.soundLevel = builder.comment("Controls how loud Revive Me! sounds are").defineInRange("Sound_Level", (double)0.7f, 0.0, 1.0);
            builder.pop();
            this.debugMode = builder.comment("If debug mode should be activated (just for testing and troubleshooting)").define("Debug_Mode", false);
        }
    }

    public static enum INTERACT_WITH_INVENTORY {
        NO,
        LOOK_ONLY,
        YES;

    }

    public static enum JUMP {
        YES,
        LIQUID_ONLY,
        NO;

    }

    public static enum FALLEN_POSE {
        CROUCH,
        PRONE,
        SLEEP;

    }
}

