/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.common.event;

import invoker54.invocore.common.ModLogger;
import invoker54.reviveme.ReviveMe;
import invoker54.reviveme.client.event.FallScreenEvent;
import invoker54.reviveme.common.api.FallenProvider;
import invoker54.reviveme.common.capability.FallenCapability;
import invoker54.reviveme.common.config.ReviveMeConfig;
import invoker54.reviveme.common.network.NetworkHandler;
import invoker54.reviveme.common.network.message.SyncClientCapMsg;
import invoker54.reviveme.common.network.message.SyncConfigMsg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="reviveme")
public class CapabilityEvents {
    public static final Map<UUID, ArrayList<UUID>> playerTracking = new HashMap<UUID, ArrayList<UUID>>();
    private static final ModLogger LOGGER = ModLogger.getLogger(FallScreenEvent.class, (AtomicBoolean)ReviveMeConfig.debugMode);

    @SubscribeEvent
    public static void AttachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            event.addCapability(ReviveMe.FALLEN_LOC, (ICapabilityProvider)new FallenProvider(((Entity)event.getObject()).field_70170_p));
        }
    }

    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        UUID playerUUID = event.getPlayer().func_110124_au();
        playerTracking.putIfAbsent(playerUUID, new ArrayList());
        FallenCapability cap = FallenCapability.GetFallCap((LivingEntity)event.getPlayer());
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a(playerUUID.toString(), cap.writeNBT());
        NetworkHandler.sendToPlayer(event.getPlayer(), new SyncClientCapMsg((INBT)nbt));
        NetworkHandler.sendToPlayer(event.getPlayer(), new SyncConfigMsg(ReviveMeConfig.serialize()));
    }

    @SubscribeEvent
    public static void onLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        playerTracking.remove(event.getPlayer().func_110124_au());
        if (!ReviveMeConfig.dieOnDisconnect) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        if (!player.func_70089_S()) {
            return;
        }
        FallenCapability cap = FallenCapability.GetFallCap((LivingEntity)player);
        if (!cap.isFallen()) {
            return;
        }
        cap.kill(player);
    }

    @SubscribeEvent
    public static void onStartTrack(PlayerEvent.StartTracking event) {
        if (!(event.getTarget() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity targPlayer = (PlayerEntity)event.getTarget();
        FallenCapability cap = FallenCapability.GetFallCap((LivingEntity)targPlayer);
        playerTracking.putIfAbsent(targPlayer.func_110124_au(), new ArrayList());
        playerTracking.get(targPlayer.func_110124_au()).add(event.getPlayer().func_110124_au());
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a(targPlayer.func_189512_bd(), cap.writeNBT());
        NetworkHandler.sendToPlayer(event.getPlayer(), new SyncClientCapMsg((INBT)nbt));
    }

    @SubscribeEvent
    public static void onStopTrack(PlayerEvent.StopTracking event) {
        if (!(event.getTarget() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity targPlayer = (PlayerEntity)event.getTarget();
        if (playerTracking.get(targPlayer.func_110124_au()) == null) {
            return;
        }
        playerTracking.get(targPlayer.func_110124_au()).remove(event.getPlayer().func_110124_au());
    }

    @SubscribeEvent
    public static void onWorldJoin(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntity();
        FallenCapability cap = FallenCapability.GetFallCap((LivingEntity)player);
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a(player.func_189512_bd(), cap.writeNBT());
        NetworkHandler.sendToPlayer(player, new SyncClientCapMsg((INBT)nbt));
    }
}

