/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.common.event;

import invoker54.invocore.common.ModLogger;
import invoker54.reviveme.common.capability.FallenCapability;
import invoker54.reviveme.common.config.ReviveMeConfig;
import invoker54.reviveme.common.network.NetworkHandler;
import invoker54.reviveme.common.network.message.SyncClientCapMsg;
import invoker54.reviveme.init.EffectInit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="reviveme")
public class FallEvent {
    private static final ModLogger LOGGER = ModLogger.getLogger(FallEvent.class, (AtomicBoolean)ReviveMeConfig.debugMode);

    public static boolean cancelEvent(PlayerEntity player, DamageSource source) {
        FallenCapability instance = FallenCapability.GetFallCap((LivingEntity)player);
        instance.refreshSelfReviveTypes(player);
        if (!instance.canSelfRevive() && !player.func_184102_h().func_71262_S() && player.func_184102_h().func_71233_x() == 1) {
            return false;
        }
        if (!instance.isFallen()) {
            NetworkHandler.sendMessage(new StringTextComponent(player.func_200200_C_().getString()).func_230529_a_((ITextComponent)new TranslationTextComponent("revive-me.chat.player_fallen")), false, (Entity)player);
            instance.setFallen(true);
            player.func_70606_j(1.0f);
            player.func_71024_bL().func_75114_a(0);
            instance.setDamageSource(source);
            instance.SetTimeLeft(player.field_70170_p.func_82737_E(), ReviveMeConfig.timeLeft.intValue());
            if (player.func_70644_a(EffectInit.FALLEN_EFFECT)) {
                instance.setPenaltyMultiplier(player.func_70660_b(EffectInit.FALLEN_EFFECT).func_76458_c() + 1);
                player.func_195063_d(EffectInit.FALLEN_EFFECT);
            }
            if (ReviveMeConfig.revertEffectsOnRevive) {
                instance.saveEffects(player);
            }
            instance.removeOriginalEffects(player);
            FallEvent.modifyPotionEffects(player);
            player.func_184210_p();
            player.func_184602_cy();
            player.func_71053_j();
            CompoundNBT nbt = new CompoundNBT();
            if (instance.getOtherPlayer() != null) {
                PlayerEntity otherPlayer = player.field_70170_p.func_217371_b(instance.getOtherPlayer());
                if (otherPlayer != null) {
                    FallenCapability otherCap = FallenCapability.GetFallCap((LivingEntity)otherPlayer);
                    otherCap.resumeFallTimer();
                    otherCap.setOtherPlayer(null);
                    nbt.func_218657_a(otherPlayer.func_189512_bd(), otherCap.writeNBT());
                }
                instance.setOtherPlayer(null);
            }
            nbt.func_218657_a(player.func_189512_bd(), instance.writeNBT());
            player.func_70606_j(0.0f);
            for (Entity entity : ((ServerWorld)player.field_70170_p).func_241136_z_()) {
                MobEntity mob;
                if (!(entity instanceof MobEntity) || (mob = (MobEntity)entity).func_70638_az() == null || mob.func_70638_az().func_145782_y() != player.func_145782_y()) continue;
                if (mob instanceof IAngerable) {
                    ((IAngerable)mob).func_233681_b_(player);
                }
                mob.func_70636_d();
            }
            player.func_70606_j(1.0f);
            NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SyncClientCapMsg((INBT)nbt));
        } else {
            instance.setFallen(false);
        }
        return instance.isFallen();
    }

    public static void modifyPotionEffects(PlayerEntity player) {
        for (String string : ReviveMeConfig.downedEffects) {
            try {
                String[] array = string.split(":");
                ResourceLocation effectLocation = new ResourceLocation(array[0], array[1]);
                int tier = Integer.parseInt(array[2]);
                Effect effect = (Effect)ForgeRegistries.POTIONS.getValue(effectLocation);
                if (effect == null) {
                    LOGGER.error("Incorrect MOD ID or Potion Effect: " + string);
                    continue;
                }
                EffectInstance effectInstance = player.func_70660_b(effect);
                if (effectInstance != null) continue;
                player.func_195064_c(new EffectInstance(effect, Integer.MAX_VALUE, tier));
            }
            catch (Exception e) {
                LOGGER.error("This string couldn't be parsed: " + string);
            }
        }
    }
}

