/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.common.event;

import invoker54.invocore.client.util.InvoText;
import invoker54.invocore.common.MathUtil;
import invoker54.invocore.common.ModLogger;
import invoker54.reviveme.common.capability.FallenCapability;
import invoker54.reviveme.common.config.ReviveMeConfig;
import invoker54.reviveme.common.event.FallEvent;
import invoker54.reviveme.common.network.NetworkHandler;
import invoker54.reviveme.common.network.message.SyncClientCapMsg;
import invoker54.reviveme.init.EffectInit;
import invoker54.reviveme.init.SoundInit;
import invoker54.reviveme.mixin.FoodMixin;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SUpdateHealthPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.FoodStats;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.GameType;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="reviveme")
public class FallenTimerEvent {
    private static final ModLogger LOGGER = ModLogger.getLogger(FallenTimerEvent.class, (AtomicBoolean)ReviveMeConfig.debugMode);

    @SubscribeEvent
    public static void changeGamemode(PlayerEvent.PlayerChangeGameModeEvent event) {
        PlayerEntity player = event.getPlayer();
        if (!FallenCapability.GetFallCap((LivingEntity)player).isFallen()) {
            return;
        }
        if (event.getNewGameMode() != GameType.CREATIVE && event.getNewGameMode() != GameType.SPECTATOR) {
            return;
        }
        FallenTimerEvent.revivePlayer(player, false);
    }

    @SubscribeEvent
    public static void TickDownTimer(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.CLIENT) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        if (event.player.func_233643_dh_()) {
            return;
        }
        FallenCapability cap = FallenCapability.GetFallCap((LivingEntity)event.player);
        if (!cap.isFallen() || cap.getOtherPlayer() != null) {
            return;
        }
        if (event.player.func_70051_ag()) {
            event.player.func_70031_b(false);
        }
        if (event.player.func_110143_aJ() != 1.0f) {
            event.player.func_70606_j(1.0f);
        }
        event.player.func_71024_bL().func_75114_a(0);
        cap.removeOriginalEffects(event.player);
        FallEvent.modifyPotionEffects(event.player);
        if (!cap.shouldDie()) {
            return;
        }
        cap.kill(event.player);
    }

    @SubscribeEvent
    public static void TickProgress(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        if (event.side != LogicalSide.SERVER) {
            return;
        }
        FallenCapability cap = FallenCapability.GetFallCap((LivingEntity)event.player);
        if (cap.getOtherPlayer() == null) {
            return;
        }
        if (cap.getProgress(true) < 1.0f) {
            return;
        }
        if (!cap.isFallen()) {
            return;
        }
        PlayerEntity fellPlayer = event.player;
        ServerPlayerEntity reviver = fellPlayer.func_184102_h().func_184103_al().func_177451_a(cap.getOtherPlayer());
        FallenTimerEvent.takeFromReviver((PlayerEntity)reviver, fellPlayer);
        FallenTimerEvent.revivePlayer(fellPlayer, false);
    }

    public static void takeFromReviver(PlayerEntity reviver, PlayerEntity fallen) {
        if (reviver == null) {
            return;
        }
        FallenCapability cap = FallenCapability.GetFallCap((LivingEntity)fallen);
        if (!reviver.func_184812_l_()) {
            int amount = (int)cap.getPenaltyAmount(reviver);
            int leftoverAmount = 0;
            block0 : switch (ReviveMeConfig.penaltyType) {
                case NONE: {
                    break;
                }
                case HEALTH: {
                    leftoverAmount = Math.max(0, Math.round((float)amount - reviver.func_110139_bj()));
                    reviver.func_110149_m(reviver.func_110139_bj() - (float)amount);
                    reviver.func_70606_j(Math.max(1.0f, reviver.func_110143_aJ() - (float)leftoverAmount));
                    break;
                }
                case EXPERIENCE: {
                    reviver.func_82242_a(-amount);
                    break;
                }
                case FOOD: {
                    FoodStats food = reviver.func_71024_bL();
                    leftoverAmount = Math.max(0, Math.round((float)amount - food.func_75115_e()));
                    ((FoodMixin)food).setSaturationLevel(Math.max(0.0f, food.func_75115_e() - (float)amount));
                    food.func_75114_a(Math.max(0, food.func_75116_a() - leftoverAmount));
                    ((ServerPlayerEntity)reviver).field_71135_a.func_147359_a((IPacket)new SUpdateHealthPacket(reviver.func_110143_aJ(), reviver.func_71024_bL().func_75116_a(), reviver.func_71024_bL().func_75115_e()));
                    break;
                }
                case ITEM: {
                    ItemStack penaltyStack = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(ReviveMeConfig.penaltyItem)));
                    if (!ReviveMeConfig.penaltyItemData.isEmpty()) {
                        penaltyStack.func_196082_o().func_197643_a(ReviveMeConfig.penaltyItemData);
                    }
                    PlayerInventory playerInv = reviver.field_71071_by;
                    for (int a = 0; a < playerInv.func_70302_i_(); ++a) {
                        ItemStack currStack = playerInv.func_70301_a(a);
                        if (!penaltyStack.func_77969_a(currStack) || !ItemStack.func_77970_a((ItemStack)penaltyStack, (ItemStack)currStack)) continue;
                        int takeAway = Math.min(amount, currStack.func_190916_E());
                        currStack.func_190920_e(currStack.func_190916_E() - takeAway);
                        if ((amount -= takeAway) == 0) break block0;
                    }
                    break;
                }
            }
        }
        cap = FallenCapability.GetFallCap((LivingEntity)reviver);
        cap.setOtherPlayer(null);
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a(reviver.func_189512_bd(), cap.writeNBT());
        NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> reviver), (Object)new SyncClientCapMsg((INBT)nbt));
    }

    public static void revivePlayer(PlayerEntity fallen, boolean isCommand) {
        FallenCapability cap = FallenCapability.GetFallCap((LivingEntity)fallen);
        float healAmount = ReviveMeConfig.revivedHealth <= 0.0 ? fallen.func_110138_aP() : (ReviveMeConfig.revivedHealth > 0.0 && ReviveMeConfig.revivedHealth < 1.0 ? (float)((double)fallen.func_110138_aP() * ReviveMeConfig.revivedHealth) : ReviveMeConfig.revivedHealth.floatValue());
        fallen.func_70606_j(healAmount);
        float foodAmount = ReviveMeConfig.revivedFood < 0.0 ? 40.0f : (ReviveMeConfig.revivedFood >= 0.0 && ReviveMeConfig.revivedFood < 1.0 ? (float)(40.0 * ReviveMeConfig.revivedFood) : ReviveMeConfig.revivedFood.floatValue());
        fallen.func_71024_bL().func_75114_a((int)Math.min(foodAmount, 20.0f));
        ((FoodMixin)fallen.func_71024_bL()).setSaturationLevel(Math.max(0.0f, foodAmount - 20.0f));
        fallen.func_195061_cb();
        cap.loadEffects(fallen);
        fallen.func_195064_c(new EffectInstance(EffectInit.FALLEN_EFFECT, (int)(ReviveMeConfig.fallenPenaltyTimer * 20.0), cap.getPenaltyMultiplier()));
        if (ReviveMeConfig.reviveInvulnTime != 0.0) {
            fallen.func_195064_c(new EffectInstance(Effects.field_76429_m, (int)(ReviveMeConfig.reviveInvulnTime * 20.0), 5));
            fallen.func_195064_c(new EffectInstance(Effects.field_76426_n, (int)(ReviveMeConfig.reviveInvulnTime * 20.0), 5));
        }
        cap.setFallen(false);
        fallen.func_213301_b(Pose.STANDING);
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a(fallen.func_189512_bd(), cap.writeNBT());
        fallen.field_70170_p.func_184148_a(null, fallen.func_226277_ct_(), fallen.func_226278_cu_(), fallen.func_226281_cx_(), SoundInit.REVIVED, SoundCategory.PLAYERS, 1.0f, MathUtil.randomFloat((float)0.7f, (float)1.0f));
        if (!fallen.field_70170_p.field_72995_K) {
            InvoText reviveTxt = InvoText.translate((String)"revive-me.commands.revive_pass", (Object[])new Object[]{fallen.func_145748_c_()});
            NetworkHandler.sendMessage(reviveTxt.getText(), isCommand, (Entity)fallen);
            NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> fallen), (Object)new SyncClientCapMsg((INBT)nbt));
        }
    }
}

