/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.common.network.message;

import invoker54.reviveme.common.capability.FallenCapability;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class SelfReviveMsg {
    public int selectedOption;

    public SelfReviveMsg(int selectedOption) {
        this.selectedOption = selectedOption;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.selectedOption);
    }

    public static SelfReviveMsg decode(PacketBuffer buf) {
        return new SelfReviveMsg(buf.readInt());
    }

    public static void handle(SelfReviveMsg msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayerEntity player = context.getSender();
            if (player == null) {
                return;
            }
            if (!player.func_70089_S()) {
                return;
            }
            FallenCapability cap = FallenCapability.GetFallCap((LivingEntity)player);
            if (!cap.canSelfRevive()) {
                cap.kill((PlayerEntity)player);
            } else {
                cap.useReviveOption(cap.getSelfReviveOption(msg.selectedOption), (PlayerEntity)player);
            }
        });
        context.setPacketHandled(true);
    }
}

