/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.common.potion;

import invoker54.reviveme.common.capability.FallenCapability;
import invoker54.reviveme.init.EffectInit;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class KillRevivePotionEffect
extends Effect {
    public static final int effectColor = new Color(35, 5, 5, 255).getRGB();
    public static DamageSource killReviveDamageSource = new DamageSource("revive-me.damage_source.kill_revive").func_76348_h().func_76359_i().func_151518_m();

    public KillRevivePotionEffect(EffectType category) {
        super(category, effectColor);
    }

    public List<ItemStack> getCurativeItems() {
        return new ArrayList<ItemStack>();
    }

    @Mod.EventBusSubscriber(modid="reviveme")
    public static class PotionEvents {
        @SubscribeEvent
        public static void killMobEvent(LivingDeathEvent event) {
            Entity sourceEntity = event.getSource().func_76346_g();
            if (!(sourceEntity instanceof PlayerEntity)) {
                return;
            }
            LivingEntity entity = (LivingEntity)sourceEntity;
            EffectInstance instance = entity.func_70660_b(EffectInit.KILL_REVIVE_EFFECT);
            if (instance == null) {
                return;
            }
            entity.func_195063_d(EffectInit.KILL_REVIVE_EFFECT);
            if (instance.func_76458_c() > 0) {
                entity.func_195063_d(EffectInit.KILL_REVIVE_EFFECT);
                entity.func_195064_c(new EffectInstance(EffectInit.KILL_REVIVE_EFFECT, instance.func_76459_b(), instance.func_76458_c() - 1));
            }
        }

        @SubscribeEvent
        public static void expireEvent(PotionEvent.PotionExpiryEvent event) {
            PotionEvents.removeEffect(event.getEntityLiving(), event.getPotionEffect(), false);
        }

        @SubscribeEvent
        public static void removeEvent(PotionEvent.PotionRemoveEvent event) {
            PotionEvents.removeEffect(event.getEntityLiving(), event.getPotionEffect(), true);
        }

        public static void removeEffect(LivingEntity entity, EffectInstance effect, boolean completed) {
            if (effect == null) {
                return;
            }
            if (!(effect.func_188419_a() instanceof KillRevivePotionEffect)) {
                return;
            }
            if (!(entity instanceof PlayerEntity)) {
                return;
            }
            FallenCapability cap = FallenCapability.GetFallCap(entity);
            if (cap.isFallen()) {
                return;
            }
            if (completed) {
                return;
            }
            entity.func_70606_j(1.0E-8f);
            entity.func_70097_a(killReviveDamageSource, 1.0f);
        }
    }
}

