/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.mixin;

import invoker54.invocore.common.ModLogger;
import invoker54.reviveme.common.capability.FallenCapability;
import invoker54.reviveme.common.config.ReviveMeConfig;
import invoker54.reviveme.common.event.FallEvent;
import invoker54.reviveme.common.network.NetworkHandler;
import invoker54.reviveme.common.network.message.SyncClientCapMsg;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.world.GameType;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.PacketDistributor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ForgeHooks.class})
public abstract class ForgeHooksMixin {
    @Unique
    private static ModLogger LOGGERT = ModLogger.getLogger(ForgeHooksMixin.class, (AtomicBoolean)ReviveMeConfig.debugMode);

    @Inject(remap=false, method={"onInteractEntity(Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/entity/Entity;Lnet/minecraft/util/Hand;)Lnet/minecraft/util/ActionResultType;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void onInteractEntity(PlayerEntity player, Entity target, Hand hand, CallbackInfoReturnable<ActionResultType> cir) {
        if (target.field_70170_p.field_72995_K) {
            return;
        }
        FallenCapability myCap = FallenCapability.GetFallCap((LivingEntity)player);
        if (myCap.isFallen()) {
            return;
        }
        if (player.func_226273_bm_()) {
            return;
        }
        if (!(target instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity targPlayer = (PlayerEntity)target;
        FallenCapability targCap = FallenCapability.GetFallCap((LivingEntity)targPlayer);
        if (!targCap.isFallen() || targCap.getOtherPlayer() != null) {
            return;
        }
        if (!targCap.hasEnough(player)) {
            return;
        }
        targCap.setProgress(player.field_70170_p.func_82737_E(), ReviveMeConfig.reviveTime);
        targCap.setOtherPlayer(player.func_110124_au());
        myCap.setProgress(player.field_70170_p.func_82737_E(), ReviveMeConfig.reviveTime);
        myCap.setOtherPlayer(targPlayer.func_110124_au());
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a(player.func_189512_bd(), myCap.writeNBT());
        nbt.func_218657_a(targPlayer.func_189512_bd(), targCap.writeNBT());
        NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> targPlayer), (Object)new SyncClientCapMsg((INBT)nbt));
        cir.setReturnValue((Object)ActionResultType.FAIL);
    }

    @Inject(remap=false, method={"onLivingDeath"}, at={@At(value="HEAD")}, cancellable=true)
    private static void onLivingDeath(LivingEntity entity, DamageSource src, CallbackInfoReturnable<Boolean> cir) {
        boolean cancelled;
        if (!(entity instanceof ServerPlayerEntity)) {
            return;
        }
        if (((ServerPlayerEntity)entity).field_71134_c.func_73081_b() == GameType.CREATIVE) {
            return;
        }
        if (!FallenCapability.GetFallCap(entity).canDie()) {
            entity.func_70606_j(1.0f);
            cancelled = true;
        } else if (ReviveMeConfig.runDeathEventFirst) {
            cancelled = MinecraftForge.EVENT_BUS.post((Event)new LivingDeathEvent(entity, src));
            if (!cancelled) {
                cancelled = FallEvent.cancelEvent((PlayerEntity)entity, src);
            }
        } else {
            cancelled = FallEvent.cancelEvent((PlayerEntity)entity, src);
            if (!cancelled) {
                cancelled = MinecraftForge.EVENT_BUS.post((Event)new LivingDeathEvent(entity, src));
            }
        }
        cir.setReturnValue((Object)cancelled);
    }
}

