/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.mixin;

import invoker54.invocore.client.util.ClientUtil;
import invoker54.invocore.common.ModLogger;
import invoker54.reviveme.client.VanillaKeybindHandler;
import invoker54.reviveme.common.capability.FallenCapability;
import invoker54.reviveme.common.config.ReviveMeConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.LivingEntity;
import net.minecraftforge.client.settings.KeyBindingMap;
import net.minecraftforge.client.settings.KeyModifier;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={KeyBindingMap.class})
public class KeyBindingMapMixin {
    @Shadow
    @Final
    private static EnumMap<KeyModifier, Map<InputMappings.Input, Collection<KeyBinding>>> map;
    @Unique
    private static final ModLogger LOGGERT;

    @Inject(method={"getBinding"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void getBinding(InputMappings.Input keyCode, KeyModifier keyModifier, CallbackInfoReturnable<KeyBinding> cir) {
        if (ClientUtil.getWorld() == null) {
            return;
        }
        if (ClientUtil.getPlayer() == null) {
            return;
        }
        if (!FallenCapability.GetFallCap((LivingEntity)ClientUtil.getPlayer()).isFallen()) {
            return;
        }
        Collection<KeyBinding> bindings = map.get(keyModifier).get(keyCode);
        if (bindings != null) {
            for (KeyBinding binding : bindings) {
                if (!binding.isActiveAndMatches(keyCode) || !VanillaKeybindHandler.isAllowedKeybind(binding)) continue;
                cir.setReturnValue((Object)binding);
                return;
            }
        }
        cir.setReturnValue(null);
    }

    @Inject(method={"lookupAll"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void lookupAll(InputMappings.Input keyCode, CallbackInfoReturnable<List<KeyBinding>> cir) {
        if (ClientUtil.getWorld() == null) {
            return;
        }
        if (ClientUtil.getPlayer() == null) {
            return;
        }
        if (!FallenCapability.GetFallCap((LivingEntity)ClientUtil.getPlayer()).isFallen()) {
            return;
        }
        ArrayList<KeyBinding> matchingBindings = new ArrayList<KeyBinding>();
        for (Map<InputMappings.Input, Collection<KeyBinding>> bindingsMap : map.values()) {
            Collection<KeyBinding> bindings = bindingsMap.get(keyCode);
            if (bindings == null) continue;
            matchingBindings.addAll(bindings);
        }
        for (KeyBinding binding : new ArrayList(matchingBindings)) {
            if (VanillaKeybindHandler.isAllowedKeybind(binding)) continue;
            matchingBindings.remove(binding);
        }
        cir.setReturnValue(matchingBindings);
    }

    static {
        LOGGERT = ModLogger.getLogger(KeyBindingMapMixin.class, (AtomicBoolean)ReviveMeConfig.debugMode);
    }
}

