/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.common.capability;

import invoker54.invocore.common.ModLogger;
import invoker54.invocore.common.util.CommonUtil;
import invoker54.invocore.common.util.MathUtil;
import invoker54.reviveme.common.api.FallenProvider;
import invoker54.reviveme.common.config.ReviveMeConfig;
import invoker54.reviveme.common.event.FallenTimerEvent;
import invoker54.reviveme.common.network.NetworkHandler;
import invoker54.reviveme.common.network.message.SyncClientCapMsg;
import invoker54.reviveme.init.MobEffectInit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class FallenCapability {
    private static final ModLogger LOGGER = ModLogger.getLogger(FallenCapability.class, (AtomicBoolean)ReviveMeConfig.debugMode);
    public static final String FALLEN_BOOL = "isFallenREVIVE";
    public static final String FELL_START_LONG = "fellStartREVIVE";
    public static final String FELL_END_DOUBLE = "fellEndREVIVE";
    public static final String REVIVE_START_LONG = "revStartREVIVE";
    public static final String REVIVE_END_INT = "revEndREVIVE";
    public static final String OTHERPLAYER_UUID = "otherPlayerREVIVE";
    public static final String PENALTY_MULTIPLIER_INT = "penaltyMultiplierIntREVIVE";
    public static final String CALLED_FOR_HELP_LONG = "calledForHelpLong";
    public static final String SAVED_EFFECTS_TAG = "savedEffectsTag";
    public static final String DOWNED_BY_PLAYER_BOOL = "DOWNED_BY_PLAYER_BOOL";
    public static final String IS_EFFECTS_REMOVED = "IS_EFFECTS_REMOVED";
    public static final String SELF_REVIVE_OPTIONS_STRING = "SELF_REVIVE_OPTIONS_STRING";
    public static final String SACRIFICEITEMS_COMPOUND = "SACRIFICEITEMS_COMPOUND";
    public static final String STATUS_EFFECTS_COMPOUND = "STATUS_EFFECTS_COMPOUND";
    public static final String SELF_REVIVE_COUNT_INT = "SELF_REVIVE_COUNT_INT";
    protected Level level;
    protected long revStart = 0L;
    protected int revEnd = 0;
    protected long fellStart = 0L;
    protected double fellEnd = 0.0;
    protected DamageSource damageSource = DamageSource.f_19317_;
    protected boolean isFallen = false;
    protected long fallenTick = 0L;
    protected UUID otherPlayer = null;
    protected long calledForHelpTime = 0L;
    protected int penaltyMultiplier = 0;
    protected CompoundTag savedEffectsTag = new CompoundTag();
    protected List<SELFREVIVETYPE> selfReviveTypeList = new ArrayList<SELFREVIVETYPE>(ReviveMeConfig.selfReviveOptions);
    protected List<ItemStack> sacrificialItems = new ArrayList<ItemStack>();
    protected List<MobEffect> negativeStatusEffects = new ArrayList<MobEffect>();
    protected int selfReviveCount = 0;
    protected boolean isDownedByPlayer = false;
    protected boolean isEffectsRemoved = false;

    public FallenCapability(Level level) {
        this.level = level;
    }

    public FallenCapability() {
    }

    public static FallenCapability GetFallCap(LivingEntity player) {
        return (FallenCapability)player.getCapability(FallenProvider.FALLENDATA).orElseGet(FallenCapability::new);
    }

    public void removeOriginalEffects(Player player) {
        if (this.isEffectsRemoved) {
            return;
        }
        try {
            player.m_21219_();
            this.isEffectsRemoved = true;
        }
        catch (Exception e) {
            LOGGER.warn("Effect removal failed, remove effects later...");
            e.printStackTrace();
        }
    }

    public boolean canSelfRevive() {
        if (ReviveMeConfig.maxSelfRevives != -1 && this.getSelfReviveCount() >= ReviveMeConfig.maxSelfRevives) {
            return false;
        }
        return !ReviveMeConfig.disableSelfReviveIfPlayerDowned || !this.isDownedByPlayer;
    }

    public void callForHelp() {
        this.calledForHelpTime = this.level.m_46467_();
    }

    public boolean isCallingForHelp() {
        return this.callForHelpCooldown() != 1.0;
    }

    public long callForHelpTicks() {
        return this.level.m_46467_() - this.calledForHelpTime;
    }

    public double callForHelpCooldown() {
        long timePassed = this.callForHelpTicks();
        return Math.min((double)timePassed / (ReviveMeConfig.reviveHelpDuration * 20.0), 1.0);
    }

    public float getPenaltyAmount(Player player) {
        Double actualAmount = ReviveMeConfig.penaltyAmount;
        if (actualAmount > 0.0 && actualAmount < 1.0) {
            actualAmount = actualAmount * this.countReviverPenaltyAmount(player);
        }
        if (player.m_7500_()) {
            actualAmount = 0.0;
        }
        return Math.round(actualAmount);
    }

    public void kill(Player player) {
        player.m_5496_(SoundEvents.f_12322_, 1.0f, (player.m_217043_().m_188501_() - player.m_217043_().m_188501_()) * 0.2f + 1.0f);
        player.m_21231_().m_19289_(this.getDamageSource(), 1.0f, 1.0f);
        if (this.damageSource.m_7639_() instanceof Player) {
            player.m_6598_((Player)this.damageSource.m_7639_());
        }
        if (this.damageSource.m_7639_() instanceof Mob) {
            player.m_6703_((LivingEntity)((Mob)this.damageSource.m_7639_()));
        }
        player.m_6667_(this.damageSource);
        player.m_21153_(0.0f);
    }

    public double countReviverPenaltyAmount(Player reviver) {
        switch (ReviveMeConfig.penaltyType) {
            case NONE: {
                return 0.0;
            }
            case HEALTH: {
                return reviver.m_21223_() + reviver.m_6103_();
            }
            case EXPERIENCE: {
                return reviver.f_36078_;
            }
            case FOOD: {
                return (float)reviver.m_36324_().m_38702_() + Math.max(reviver.m_36324_().m_38722_(), 0.0f);
            }
            case ITEM: {
                ItemStack penaltyStack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(ReviveMeConfig.penaltyItem)));
                if (!ReviveMeConfig.penaltyItemData.m_128456_()) {
                    penaltyStack.m_41784_().m_128391_(ReviveMeConfig.penaltyItemData);
                }
                int count = 0;
                for (int a = 0; a < reviver.m_150109_().m_6643_(); ++a) {
                    ItemStack containerStack = reviver.m_150109_().m_8020_(a);
                    if (!penaltyStack.m_41656_(containerStack) || !ItemStack.m_41658_((ItemStack)containerStack, (ItemStack)penaltyStack)) continue;
                    count += containerStack.m_41613_();
                }
                return count;
            }
        }
        return 0.0;
    }

    public boolean hasEnough(Player reviver) {
        if (reviver.m_7500_()) {
            return true;
        }
        if (ReviveMeConfig.penaltyType == PENALTYPE.NONE) {
            return true;
        }
        return this.countReviverPenaltyAmount(reviver) - (double)this.getPenaltyAmount(reviver) >= 0.0;
    }

    public void setDamageSource(DamageSource damageSource) {
        this.damageSource = damageSource;
        this.isDownedByPlayer = this.damageSource.m_7639_() instanceof Player;
    }

    public DamageSource getDamageSource() {
        return this.damageSource;
    }

    public float GetTimeLeft(boolean divideByMax) {
        double maxSeconds = this.getPenaltyTicks(this.fellEnd);
        if (ReviveMeConfig.timeLeft == 0) {
            maxSeconds = 0.0;
        }
        if (divideByMax) {
            return (float)(1.0 - (double)(this.level.m_46467_() - this.fellStart) / maxSeconds);
        }
        return (float)(((double)this.fellStart + maxSeconds - (double)this.level.m_46467_()) / 20.0);
    }

    public float getKillTime(boolean divideByMax) {
        if (ReviveMeConfig.pvpTimer == -1) {
            return -1.0f;
        }
        double maxSeconds = this.getPenaltyTicks(ReviveMeConfig.pvpTimer * 20);
        if (divideByMax) {
            return (float)Math.max(0.0, 1.0 - (double)(this.level.m_46467_() - this.fellStart) / maxSeconds);
        }
        return (float)Math.max(0.0, ((double)this.fellStart + maxSeconds - (double)this.level.m_46467_()) / 20.0);
    }

    public boolean shouldDie() {
        return ReviveMeConfig.timeLeft != 0 && this.GetTimeLeft(false) <= 0.0f;
    }

    public boolean canDie() {
        return this.fallenTick != this.level.m_46467_();
    }

    public void SetTimeLeft(long timeStart, double maxSeconds) {
        this.fellStart = timeStart;
        this.fellEnd = (long)(maxSeconds * 20.0);
    }

    public void resumeFallTimer() {
        this.fellStart = this.level.m_46467_() - (this.revStart - this.fellStart);
    }

    public boolean isFallen() {
        return this.isFallen;
    }

    public void setFallen(boolean fallen) {
        this.isFallen = fallen;
        if (!fallen) {
            this.setProgress(0L, 1);
            this.SetTimeLeft(0L, 1.0);
            this.setOtherPlayer(null);
            this.calledForHelpTime = 0L;
            this.isEffectsRemoved = false;
        } else {
            this.fallenTick = this.level.m_46467_();
        }
    }

    public boolean isDownedByPlayer() {
        return this.isDownedByPlayer;
    }

    public UUID getOtherPlayer() {
        return this.otherPlayer;
    }

    public boolean isReviver(UUID targUUID) {
        if (targUUID == null) {
            return false;
        }
        if (this.getOtherPlayer() == null) {
            return false;
        }
        return this.getOtherPlayer().equals(targUUID);
    }

    public void setOtherPlayer(UUID playerID) {
        this.otherPlayer = playerID;
    }

    public void setProgress(long timeStart, int seconds) {
        this.revStart = timeStart;
        this.revEnd = seconds * 20;
    }

    public float getProgress(boolean divideByMax) {
        long passedTicks = Math.min((long)this.revEnd, this.level.m_46467_() - this.revStart);
        return divideByMax ? (float)passedTicks / (float)this.revEnd : (float)passedTicks;
    }

    public SELFREVIVETYPE getSelfReviveOption(int mouseButton) {
        return this.selfReviveTypeList.get(mouseButton);
    }

    public void useReviveOption(SELFREVIVETYPE selectedOption, Player player) {
        Inventory playerInv = player.m_150109_();
        double penaltyPercentage = this.getSelfPenaltyPercentage();
        ++this.selfReviveCount;
        this.selfReviveTypeList.remove((Object)selectedOption);
        this.selfReviveTypeList.add(selectedOption);
        switch (selectedOption) {
            case CHANCE: {
                if ((double)player.f_19853_.f_46441_.m_188501_() < ReviveMeConfig.reviveChance * (1.0 - penaltyPercentage)) {
                    FallenTimerEvent.revivePlayer(player, false);
                    return;
                }
                if (ReviveMeConfig.reviveChanceKillOnFail) break;
                player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS, MathUtil.randomFloat((float)0.7f, (float)1.0f), MathUtil.randomFloat((float)0.8f, (float)1.0f));
                if (!this.canSelfRevive() && !player.m_20194_().m_6982_() && player.m_20194_().m_7416_() == 1) break;
                this.refreshSelfReviveTypes(player);
                CompoundTag nbt = new CompoundTag();
                nbt.m_128365_(player.m_20149_(), this.writeNBT());
                NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SyncClientCapMsg((Tag)nbt));
                return;
            }
            case RANDOM_ITEMS: {
                if (this.getItemList().isEmpty()) break;
                FallenTimerEvent.revivePlayer(player, false);
                block8: for (ItemStack sacrificeStack : this.getItemList()) {
                    int count = FallenCapability.countItem(playerInv, sacrificeStack);
                    int amountToLose = (int)Math.round(Math.max(1.0, (double)count * (ReviveMeConfig.sacrificialItemPercent * (1.0 + penaltyPercentage))));
                    for (int a = 0; a < playerInv.m_6643_(); ++a) {
                        ItemStack containerStack;
                        if (!ReviveMeConfig.sacrificialItemTakesHotbar && (a < 9 || a == 40) || !sacrificeStack.m_41656_(containerStack = playerInv.m_8020_(a)) || !ItemStack.m_41658_((ItemStack)sacrificeStack, (ItemStack)containerStack)) continue;
                        int takeAway = Math.min(amountToLose, containerStack.m_41613_());
                        containerStack.m_41764_(containerStack.m_41613_() - takeAway);
                        if ((amountToLose -= takeAway) == 0) continue block8;
                    }
                }
                this.sacrificialItems.clear();
                return;
            }
            case SPECIFIC_ITEM: {
                Pair<Integer, List<ItemStack>> specificPair = this.getSpecificItem(player);
                if ((Integer)specificPair.getKey() < ReviveMeConfig.specificItemCount) break;
                FallenTimerEvent.revivePlayer(player, false);
                int amountLeft = (Integer)specificPair.getKey();
                ItemStack defaultStack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(ReviveMeConfig.specificItem)));
                if (!ReviveMeConfig.specificItemData.m_128456_()) {
                    defaultStack.m_41784_().m_128391_(ReviveMeConfig.specificItemData);
                }
                for (int a = 0; a < playerInv.m_6643_(); ++a) {
                    ItemStack containerStack = playerInv.m_8020_(a);
                    if (!defaultStack.m_41656_(containerStack) || !ItemStack.m_41658_((ItemStack)defaultStack, (ItemStack)containerStack)) continue;
                    int takeAway = Math.min(amountLeft, containerStack.m_41613_());
                    containerStack.m_41764_(containerStack.m_41613_() - takeAway);
                    if ((amountLeft -= takeAway) == 0) break;
                }
                return;
            }
            case KILL: {
                FallenTimerEvent.revivePlayer(player, false);
                int seconds = (int)((double)(ReviveMeConfig.reviveKillTime * 20) * (1.0 - penaltyPercentage));
                int killCount = ReviveMeConfig.reviveKillAmount;
                player.m_7292_(new MobEffectInstance(MobEffectInit.KILL_REVIVE_EFFECT, seconds, killCount - 1));
                return;
            }
            case STATUS_EFFECTS: {
                double invulnTime = ReviveMeConfig.reviveInvulnTime;
                if (ReviveMeConfig.disableReviveEffects) {
                    ReviveMeConfig.reviveInvulnTime = 0.0;
                }
                FallenTimerEvent.revivePlayer(player, false);
                ReviveMeConfig.reviveInvulnTime = invulnTime;
                int amp = 0;
                int duration = (int)((double)(20 * ReviveMeConfig.negativeEffectsTime) * (1.0 + penaltyPercentage));
                if (this.negativeStatusEffects.size() == 1) {
                    amp = 1;
                }
                for (MobEffect effect : this.negativeStatusEffects) {
                    player.m_7292_(new MobEffectInstance(effect, duration, amp));
                }
                return;
            }
            case EXPERIENCE: {
                if (player.f_36078_ < ReviveMeConfig.minReviveXPLevel) break;
                FallenTimerEvent.revivePlayer(player, false);
                player.m_6749_((int)(-((double)player.f_36078_ * ReviveMeConfig.reviveXPLossPercentage * (1.0 + penaltyPercentage))));
                return;
            }
        }
        this.kill(player);
    }

    public void resetSelfReviveCount() {
        this.selfReviveCount = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void refreshSelfReviveTypes(Player player) {
        if (!this.selfReviveTypeList.containsAll(ReviveMeConfig.selfReviveOptions) || this.selfReviveTypeList.size() != ReviveMeConfig.selfReviveOptions.size()) {
            this.selfReviveTypeList = new ArrayList<SELFREVIVETYPE>(ReviveMeConfig.selfReviveOptions);
        }
        if (ReviveMeConfig.randomizeSelfReviveOptions) {
            Collections.shuffle(this.selfReviveTypeList);
        }
        if (this.selfReviveTypeList.contains((Object)SELFREVIVETYPE.RANDOM_ITEMS)) {
            this.setSacrificialItems(player.m_150109_());
        }
        if (this.selfReviveTypeList.contains((Object)SELFREVIVETYPE.STATUS_EFFECTS)) {
            this.negativeStatusEffects.clear();
            this.negativeStatusEffects.addAll(CommonUtil.pickRandomObjectsFromList((int)(Math.random() > 0.5 ? 1 : 2), ReviveMeConfig.harmfulEffects));
        }
        int count = 0;
        if (!ReviveMeConfig.onlyUseAvailableOptions) return;
        int a = 0;
        while (a < this.selfReviveTypeList.size()) {
            block11: {
                if (count == 2) {
                    return;
                }
                switch (this.selfReviveTypeList.get(a)) {
                    case RANDOM_ITEMS: {
                        if (!this.getItemList().isEmpty()) break;
                        break block11;
                    }
                    case SPECIFIC_ITEM: {
                        if ((Integer)this.getSpecificItem(player).getKey() != 0) break;
                        break block11;
                    }
                    case EXPERIENCE: {
                        if (player.f_36078_ < ReviveMeConfig.minReviveXPLevel) break block11;
                    }
                }
                this.selfReviveTypeList.add(0, this.selfReviveTypeList.remove(a));
                ++count;
            }
            ++a;
        }
    }

    public Pair<Integer, List<ItemStack>> getSpecificItem(Player player) {
        ItemStack defaultStack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(ReviveMeConfig.specificItem)));
        if (!ReviveMeConfig.specificItemData.m_128456_()) {
            defaultStack.m_41784_().m_128391_(ReviveMeConfig.specificItemData);
        }
        Inventory playerInv = player.m_150109_();
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        int countNeeded = ReviveMeConfig.specificItemCount;
        int count = 0;
        for (int a = 0; a < playerInv.m_6643_(); ++a) {
            ItemStack containerStack = playerInv.m_8020_(a);
            if (!defaultStack.m_41656_(containerStack) || !ItemStack.m_41658_((ItemStack)containerStack, (ItemStack)defaultStack)) continue;
            stackList.add(containerStack);
            if ((count += containerStack.m_41613_()) >= countNeeded) break;
        }
        if (count == 0) {
            stackList.add(defaultStack);
        }
        count = Math.min(count, countNeeded);
        return Pair.of((Object)count, stackList);
    }

    public List<MobEffect> getNegativeStatusEffects() {
        return new ArrayList<MobEffect>(this.negativeStatusEffects);
    }

    public double getSelfPenaltyPercentage() {
        return (double)this.getSelfReviveCount() * ReviveMeConfig.selfPenaltyPercentage;
    }

    public int getSelfReviveCount() {
        return this.selfReviveCount;
    }

    public void setSacrificialItems(Inventory inventory) {
        if (inventory == null) {
            return;
        }
        Pair<Integer, List<ItemStack>> specificPair = this.getSpecificItem(inventory.f_35978_);
        ArrayList<ItemStack> playerItems = new ArrayList<ItemStack>();
        for (int a = 0; a < inventory.f_35974_.size(); ++a) {
            ItemStack newStack;
            if (!ReviveMeConfig.sacrificialItemTakesHotbar && (a < 9 || a == 40) || !(newStack = inventory.m_8020_(a)).m_41753_() || ((List)specificPair.getValue()).contains(newStack) || playerItems.stream().anyMatch(listStack -> listStack.m_41656_(newStack) && ItemStack.m_41658_((ItemStack)listStack, (ItemStack)newStack)) || newStack.m_41619_()) continue;
            playerItems.add(this.level.f_46441_.m_188503_(Math.max(1, playerItems.size())), newStack.m_41777_());
        }
        while (playerItems.size() > 4) {
            playerItems.remove(this.level.f_46441_.m_188503_(playerItems.size()));
        }
        this.sacrificialItems = playerItems;
    }

    public ArrayList<ItemStack> getItemList() {
        return new ArrayList<ItemStack>(this.sacrificialItems);
    }

    public boolean isSacrificialItem(ItemStack mainStack) {
        if (!this.canSelfRevive()) {
            return false;
        }
        return this.sacrificialItems.stream().anyMatch(sacrificialStack -> sacrificialStack.m_41656_(mainStack) && ItemStack.m_41658_((ItemStack)mainStack, (ItemStack)sacrificialStack));
    }

    public static int countItem(Inventory inventory, ItemStack sacrificialStack) {
        int count = 0;
        for (int a = 0; a < inventory.m_6643_(); ++a) {
            ItemStack containerStack;
            if (!ReviveMeConfig.sacrificialItemTakesHotbar && (a < 9 || a == 40) || !sacrificialStack.m_41656_(containerStack = inventory.m_8020_(a)) || !ItemStack.m_41658_((ItemStack)sacrificialStack, (ItemStack)containerStack)) continue;
            count += containerStack.m_41613_();
        }
        return count;
    }

    public int getPenaltyMultiplier() {
        return this.penaltyMultiplier;
    }

    public long getPenaltyTicks(double ticks) {
        double multiplier = (double)this.getPenaltyMultiplier() * ReviveMeConfig.timeReductionPenalty;
        if (ReviveMeConfig.timeReductionPenalty == -1.0) {
            multiplier = (double)this.getPenaltyMultiplier() * ticks;
        } else if (ReviveMeConfig.timeReductionPenalty < 1.0) {
            multiplier *= ticks;
        } else if (ReviveMeConfig.timeReductionPenalty >= 1.0) {
            multiplier *= 20.0;
        }
        return (long)Math.max(0.0, ticks - multiplier);
    }

    public void setPenaltyMultiplier(int newMultiplier) {
        this.penaltyMultiplier = newMultiplier;
    }

    public void saveEffects(Player player) {
        CompoundTag effectsTag = new CompoundTag();
        for (MobEffectInstance effectInstance : new ArrayList(player.m_21220_())) {
            if (effectInstance.m_19557_() <= 20) continue;
            CompoundTag savedEffectTag = new CompoundTag();
            effectInstance.m_19555_(savedEffectTag);
            effectsTag.m_128365_("" + effectsTag.m_128440_(), (Tag)savedEffectTag);
        }
        this.savedEffectsTag = effectsTag;
    }

    public void loadEffects(Player player) {
        for (String key : this.savedEffectsTag.m_128431_()) {
            MobEffectInstance instance = MobEffectInstance.m_19560_((CompoundTag)this.savedEffectsTag.m_128469_(key));
            if (instance == null) continue;
            player.m_7292_(instance);
        }
        this.savedEffectsTag = new CompoundTag();
    }

    public Tag writeNBT() {
        CompoundTag cNBT = new CompoundTag();
        cNBT.m_128356_(FELL_START_LONG, this.fellStart);
        cNBT.m_128347_(FELL_END_DOUBLE, this.fellEnd / 20.0);
        cNBT.m_128379_(FALLEN_BOOL, this.isFallen);
        cNBT.m_128356_(REVIVE_START_LONG, this.revStart);
        cNBT.m_128405_(REVIVE_END_INT, this.revEnd / 20);
        String selfReviveListString = "";
        for (SELFREVIVETYPE selfrevivetype : this.selfReviveTypeList) {
            selfReviveListString = selfReviveListString.concat(selfrevivetype.name() + ",");
        }
        cNBT.m_128359_(SELF_REVIVE_OPTIONS_STRING, selfReviveListString);
        CompoundTag statusEffectNBT = new CompoundTag();
        int count = 0;
        for (MobEffect effect : this.negativeStatusEffects) {
            statusEffectNBT.m_128344_(Integer.toString(count), (byte)MobEffect.m_19459_((MobEffect)effect));
            ++count;
        }
        cNBT.m_128365_(STATUS_EFFECTS_COMPOUND, (Tag)statusEffectNBT);
        CompoundTag itemCompound = new CompoundTag();
        for (ItemStack item : this.sacrificialItems) {
            itemCompound.m_128365_("" + itemCompound.m_128440_(), (Tag)item.serializeNBT());
        }
        cNBT.m_128365_(SACRIFICEITEMS_COMPOUND, (Tag)itemCompound);
        cNBT.m_128405_(PENALTY_MULTIPLIER_INT, this.penaltyMultiplier);
        cNBT.m_128356_(CALLED_FOR_HELP_LONG, this.calledForHelpTime);
        cNBT.m_128365_(SAVED_EFFECTS_TAG, (Tag)this.savedEffectsTag);
        if (this.otherPlayer != null) {
            cNBT.m_128362_(OTHERPLAYER_UUID, this.otherPlayer);
        }
        cNBT.m_128405_(SELF_REVIVE_COUNT_INT, this.selfReviveCount);
        cNBT.m_128379_(DOWNED_BY_PLAYER_BOOL, this.isDownedByPlayer());
        cNBT.m_128379_(IS_EFFECTS_REMOVED, this.isEffectsRemoved);
        return cNBT;
    }

    public void readNBT(Tag nbt) {
        CompoundTag cNBT = (CompoundTag)nbt;
        this.SetTimeLeft(cNBT.m_128454_(FELL_START_LONG), cNBT.m_128459_(FELL_END_DOUBLE));
        this.setFallen(cNBT.m_128471_(FALLEN_BOOL));
        this.setProgress(cNBT.m_128454_(REVIVE_START_LONG), cNBT.m_128451_(REVIVE_END_INT));
        this.selfReviveTypeList.clear();
        for (String s : cNBT.m_128461_(SELF_REVIVE_OPTIONS_STRING).split(",")) {
            try {
                this.selfReviveTypeList.add(SELFREVIVETYPE.valueOf(s));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.selfReviveTypeList.isEmpty()) {
            this.selfReviveTypeList.addAll(ReviveMeConfig.selfReviveOptions);
        }
        this.negativeStatusEffects.clear();
        CompoundTag statusEffectNBT = cNBT.m_128469_(STATUS_EFFECTS_COMPOUND);
        for (String s : statusEffectNBT.m_128431_()) {
            this.negativeStatusEffects.add(MobEffect.m_19453_((int)statusEffectNBT.m_128445_(s)));
        }
        this.sacrificialItems.clear();
        CompoundTag itemCompound = cNBT.m_128469_(SACRIFICEITEMS_COMPOUND);
        if (!itemCompound.m_128456_()) {
            for (String key : itemCompound.m_128431_()) {
                ItemStack sacrificeStack = ItemStack.m_41712_((CompoundTag)itemCompound.m_128469_(key));
                if (sacrificeStack.m_41619_()) continue;
                this.sacrificialItems.add(sacrificeStack);
            }
        }
        this.penaltyMultiplier = cNBT.m_128451_(PENALTY_MULTIPLIER_INT);
        this.calledForHelpTime = cNBT.m_128454_(CALLED_FOR_HELP_LONG);
        this.savedEffectsTag = cNBT.m_128469_(SAVED_EFFECTS_TAG);
        if (cNBT.m_128403_(OTHERPLAYER_UUID)) {
            this.setOtherPlayer(cNBT.m_128342_(OTHERPLAYER_UUID));
        } else {
            this.setOtherPlayer(null);
        }
        this.selfReviveCount = cNBT.m_128451_(SELF_REVIVE_COUNT_INT);
        this.isDownedByPlayer = cNBT.m_128471_(DOWNED_BY_PLAYER_BOOL);
        this.isEffectsRemoved = cNBT.m_128471_(IS_EFFECTS_REMOVED);
    }

    public static enum PENALTYPE {
        NONE,
        HEALTH,
        EXPERIENCE,
        FOOD,
        ITEM;

    }

    public static enum SELFREVIVETYPE {
        CHANCE,
        RANDOM_ITEMS,
        SPECIFIC_ITEM,
        KILL,
        STATUS_EFFECTS,
        EXPERIENCE;

    }
}

