/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.common.event;

import invoker54.invocore.common.ModLogger;
import invoker54.reviveme.common.capability.FallenCapability;
import invoker54.reviveme.common.config.ReviveMeConfig;
import invoker54.reviveme.common.network.NetworkHandler;
import invoker54.reviveme.common.network.message.SyncClientCapMsg;
import invoker54.reviveme.init.MobEffectInit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="reviveme")
public class FallEvent {
    private static final ModLogger LOGGER = ModLogger.getLogger(FallEvent.class, (AtomicBoolean)ReviveMeConfig.debugMode);

    public static boolean cancelEvent(Player player, DamageSource source) {
        FallenCapability instance = FallenCapability.GetFallCap((LivingEntity)player);
        instance.refreshSelfReviveTypes(player);
        if (!instance.canSelfRevive() && !player.m_20194_().m_6982_() && player.m_20194_().m_7416_() == 1) {
            return false;
        }
        if (!instance.isFallen()) {
            NetworkHandler.sendMessage(Component.m_237113_((String)player.m_7755_().getString()).m_7220_((Component)Component.m_237115_((String)"revive-me.chat.player_fallen")), false, (Entity)player);
            instance.setFallen(true);
            player.m_21153_(1.0f);
            player.m_36324_().m_38705_(0);
            instance.setDamageSource(source);
            instance.SetTimeLeft(player.f_19853_.m_46467_(), ReviveMeConfig.timeLeft.intValue());
            if (player.m_21023_(MobEffectInit.FALLEN_EFFECT)) {
                instance.setPenaltyMultiplier(player.m_21124_(MobEffectInit.FALLEN_EFFECT).m_19564_() + 1);
                player.m_21195_(MobEffectInit.FALLEN_EFFECT);
            }
            if (ReviveMeConfig.revertEffectsOnRevive) {
                instance.saveEffects(player);
            }
            instance.removeOriginalEffects(player);
            FallEvent.modifyPotionEffects(player);
            player.m_8127_();
            player.m_5810_();
            player.m_6915_();
            CompoundTag nbt = new CompoundTag();
            if (instance.getOtherPlayer() != null) {
                Player otherPlayer = player.f_19853_.m_46003_(instance.getOtherPlayer());
                if (otherPlayer != null) {
                    FallenCapability otherCap = FallenCapability.GetFallCap((LivingEntity)otherPlayer);
                    otherCap.resumeFallTimer();
                    otherCap.setOtherPlayer(null);
                    nbt.m_128365_(otherPlayer.m_20149_(), otherCap.writeNBT());
                }
                instance.setOtherPlayer(null);
            }
            nbt.m_128365_(player.m_20149_(), instance.writeNBT());
            player.m_21153_(0.0f);
            for (Entity entity : ((ServerLevel)player.f_19853_).m_8583_()) {
                Mob mob;
                if (!(entity instanceof Mob) || (mob = (Mob)entity).m_5448_() == null || mob.m_5448_().m_19879_() != player.m_19879_()) continue;
                if (mob instanceof NeutralMob) {
                    ((NeutralMob)mob).m_21676_(player);
                }
                mob.m_8107_();
            }
            player.m_21153_(1.0f);
            NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SyncClientCapMsg((Tag)nbt));
        } else {
            instance.setFallen(false);
        }
        return instance.isFallen();
    }

    public static void modifyPotionEffects(Player player) {
        for (String string : ReviveMeConfig.downedEffects) {
            try {
                String[] array = string.split(":");
                ResourceLocation effectLocation = new ResourceLocation(array[0], array[1]);
                int tier = Integer.parseInt(array[2]);
                MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectLocation);
                if (effect == null) {
                    LOGGER.error("Incorrect MOD ID or Potion Effect: " + string);
                    continue;
                }
                MobEffectInstance effectInstance = player.m_21124_(effect);
                if (effectInstance != null) continue;
                player.m_7292_(new MobEffectInstance(effect, Integer.MAX_VALUE, tier));
            }
            catch (Exception e) {
                LOGGER.error("This string couldn't be parsed: " + string);
            }
        }
    }
}

