/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.common.event;

import invoker54.invocore.client.util.InvoText;
import invoker54.invocore.common.ModLogger;
import invoker54.invocore.common.util.MathUtil;
import invoker54.reviveme.common.capability.FallenCapability;
import invoker54.reviveme.common.config.ReviveMeConfig;
import invoker54.reviveme.common.event.FallEvent;
import invoker54.reviveme.common.network.NetworkHandler;
import invoker54.reviveme.common.network.message.SyncClientCapMsg;
import invoker54.reviveme.init.MobEffectInit;
import invoker54.reviveme.init.SoundInit;
import invoker54.reviveme.mixin.FoodMixin;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetHealthPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="reviveme")
public class FallenTimerEvent {
    private static final ModLogger LOGGER = ModLogger.getLogger(FallenTimerEvent.class, (AtomicBoolean)ReviveMeConfig.debugMode);

    @SubscribeEvent
    public static void changeGamemode(PlayerEvent.PlayerChangeGameModeEvent event) {
        Player player = event.getEntity();
        if (!FallenCapability.GetFallCap((LivingEntity)player).isFallen()) {
            return;
        }
        if (event.getNewGameMode() != GameType.CREATIVE && event.getNewGameMode() != GameType.SPECTATOR) {
            return;
        }
        FallenTimerEvent.revivePlayer(player, false);
    }

    @SubscribeEvent
    public static void TickDownTimer(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.CLIENT) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        if (event.player.m_21224_()) {
            return;
        }
        FallenCapability cap = FallenCapability.GetFallCap((LivingEntity)event.player);
        if (!cap.isFallen() || cap.getOtherPlayer() != null) {
            return;
        }
        if (event.player.m_20142_()) {
            event.player.m_6858_(false);
        }
        if (event.player.m_21223_() != 1.0f) {
            event.player.m_21153_(1.0f);
        }
        event.player.m_36324_().m_38705_(0);
        cap.removeOriginalEffects(event.player);
        FallEvent.modifyPotionEffects(event.player);
        if (!cap.shouldDie()) {
            return;
        }
        cap.kill(event.player);
    }

    @SubscribeEvent
    public static void TickProgress(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        if (event.side != LogicalSide.SERVER) {
            return;
        }
        FallenCapability cap = FallenCapability.GetFallCap((LivingEntity)event.player);
        if (cap.getOtherPlayer() == null) {
            return;
        }
        if (cap.getProgress(true) < 1.0f) {
            return;
        }
        if (!cap.isFallen()) {
            return;
        }
        Player fellPlayer = event.player;
        ServerPlayer reviver = fellPlayer.m_20194_().m_6846_().m_11259_(cap.getOtherPlayer());
        FallenTimerEvent.takeFromReviver((Player)reviver, fellPlayer);
        FallenTimerEvent.revivePlayer(fellPlayer, false);
    }

    public static void takeFromReviver(Player reviver, Player fallen) {
        if (reviver == null) {
            return;
        }
        FallenCapability cap = FallenCapability.GetFallCap((LivingEntity)fallen);
        if (!reviver.m_7500_()) {
            int amount = (int)cap.getPenaltyAmount(reviver);
            int leftoverAmount = 0;
            block0 : switch (ReviveMeConfig.penaltyType) {
                case NONE: {
                    break;
                }
                case HEALTH: {
                    leftoverAmount = Math.max(0, Math.round((float)amount - reviver.m_6103_()));
                    reviver.m_7911_(reviver.m_6103_() - (float)amount);
                    reviver.m_21153_(Math.max(1.0f, reviver.m_21223_() - (float)leftoverAmount));
                    break;
                }
                case EXPERIENCE: {
                    reviver.m_6749_(-amount);
                    break;
                }
                case FOOD: {
                    FoodData food = reviver.m_36324_();
                    leftoverAmount = Math.max(0, Math.round((float)amount - food.m_38722_()));
                    ((FoodMixin)food).setSaturationLevel(Math.max(0.0f, food.m_38722_() - (float)amount));
                    food.m_38705_(Math.max(0, food.m_38702_() - leftoverAmount));
                    ((ServerPlayer)reviver).f_8906_.m_9829_((Packet)new ClientboundSetHealthPacket(reviver.m_21223_(), reviver.m_36324_().m_38702_(), reviver.m_36324_().m_38722_()));
                    break;
                }
                case ITEM: {
                    ItemStack penaltyStack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(ReviveMeConfig.penaltyItem)));
                    if (!ReviveMeConfig.penaltyItemData.m_128456_()) {
                        penaltyStack.m_41784_().m_128391_(ReviveMeConfig.penaltyItemData);
                    }
                    Inventory playerInv = reviver.m_150109_();
                    for (int a = 0; a < playerInv.m_6643_(); ++a) {
                        ItemStack currStack = playerInv.m_8020_(a);
                        if (!penaltyStack.m_41656_(currStack) || !ItemStack.m_41658_((ItemStack)penaltyStack, (ItemStack)currStack)) continue;
                        int takeAway = Math.min(amount, currStack.m_41613_());
                        currStack.m_41764_(currStack.m_41613_() - takeAway);
                        if ((amount -= takeAway) == 0) break block0;
                    }
                    break;
                }
            }
        }
        cap = FallenCapability.GetFallCap((LivingEntity)reviver);
        cap.setOtherPlayer(null);
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_(reviver.m_20149_(), cap.writeNBT());
        NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> reviver), (Object)new SyncClientCapMsg((Tag)nbt));
    }

    public static void revivePlayer(Player fallen, boolean isCommand) {
        FallenCapability cap = FallenCapability.GetFallCap((LivingEntity)fallen);
        float healAmount = ReviveMeConfig.revivedHealth <= 0.0 ? fallen.m_21233_() : (ReviveMeConfig.revivedHealth > 0.0 && ReviveMeConfig.revivedHealth < 1.0 ? (float)((double)fallen.m_21233_() * ReviveMeConfig.revivedHealth) : ReviveMeConfig.revivedHealth.floatValue());
        fallen.m_21153_(healAmount);
        float foodAmount = ReviveMeConfig.revivedFood < 0.0 ? 40.0f : (ReviveMeConfig.revivedFood >= 0.0 && ReviveMeConfig.revivedFood < 1.0 ? (float)(40.0 * ReviveMeConfig.revivedFood) : ReviveMeConfig.revivedFood.floatValue());
        fallen.m_36324_().m_38705_((int)Math.min(foodAmount, 20.0f));
        ((FoodMixin)fallen.m_36324_()).setSaturationLevel(Math.max(0.0f, foodAmount - 20.0f));
        fallen.m_21219_();
        cap.loadEffects(fallen);
        fallen.m_7292_(new MobEffectInstance(MobEffectInit.FALLEN_EFFECT, (int)(ReviveMeConfig.fallenPenaltyTimer * 20.0), cap.getPenaltyMultiplier()));
        if (ReviveMeConfig.reviveInvulnTime != 0.0) {
            fallen.m_7292_(new MobEffectInstance(MobEffects.f_19606_, (int)(ReviveMeConfig.reviveInvulnTime * 20.0), 5));
            fallen.m_7292_(new MobEffectInstance(MobEffects.f_19607_, (int)(ReviveMeConfig.reviveInvulnTime * 20.0), 5));
        }
        cap.setFallen(false);
        fallen.m_20124_(Pose.STANDING);
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_(fallen.m_20149_(), cap.writeNBT());
        fallen.f_19853_.m_6263_(null, fallen.m_20185_(), fallen.m_20186_(), fallen.m_20189_(), SoundInit.REVIVED, SoundSource.PLAYERS, 1.0f, MathUtil.randomFloat((float)0.7f, (float)1.0f));
        if (!fallen.f_19853_.f_46443_) {
            InvoText reviveTxt = InvoText.translate((String)"revive-me.commands.revive_pass", (Object[])new Object[]{fallen.m_5446_()});
            NetworkHandler.sendMessage(reviveTxt.getText(), isCommand, (Entity)fallen);
            NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> fallen), (Object)new SyncClientCapMsg((Tag)nbt));
        }
    }
}

