/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.common.network.message;

import invoker54.reviveme.common.capability.FallenCapability;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class SelfReviveMsg {
    public int selectedOption;

    public SelfReviveMsg(int selectedOption) {
        this.selectedOption = selectedOption;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.selectedOption);
    }

    public static SelfReviveMsg decode(FriendlyByteBuf buf) {
        return new SelfReviveMsg(buf.readInt());
    }

    public static void handle(SelfReviveMsg msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            if (!player.m_6084_()) {
                return;
            }
            FallenCapability cap = FallenCapability.GetFallCap((LivingEntity)player);
            if (!cap.canSelfRevive()) {
                cap.kill((Player)player);
            } else {
                cap.useReviveOption(cap.getSelfReviveOption(msg.selectedOption), (Player)player);
            }
        });
        context.setPacketHandled(true);
    }
}

