/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.common.potion;

import invoker54.reviveme.common.capability.FallenCapability;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class FallenPotionEffect
extends MobEffect {
    public static final int effectColor = new Color(35, 5, 5, 255).getRGB();

    public FallenPotionEffect(MobEffectCategory category) {
        super(category, effectColor);
    }

    public List<ItemStack> getCurativeItems() {
        return new ArrayList<ItemStack>();
    }

    @Mod.EventBusSubscriber(modid="reviveme")
    public static class PotionEvents {
        @SubscribeEvent
        public static void removeFallMethod(MobEffectEvent.Expired event) {
            PotionEvents.removePenalties(event.getEntity(), event.getEffectInstance());
        }

        @SubscribeEvent
        public static void onRemove(MobEffectEvent.Remove event) {
            PotionEvents.removePenalties(event.getEntity(), event.getEffectInstance());
        }

        public static void removePenalties(LivingEntity entity, MobEffectInstance effect) {
            if (effect == null) {
                return;
            }
            if (!(effect.m_19544_() instanceof FallenPotionEffect)) {
                return;
            }
            if (!(entity instanceof Player)) {
                return;
            }
            Player player = (Player)entity;
            FallenCapability cap = FallenCapability.GetFallCap((LivingEntity)player);
            if (cap.isFallen()) {
                return;
            }
            cap.resetSelfReviveCount();
            cap.setPenaltyMultiplier(0);
        }
    }
}

