/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.client.event;

import invoker54.invocore.client.util.ClientUtil;
import invoker54.reviveme.client.VanillaKeybindHandler;
import invoker54.reviveme.common.capability.FallenCapability;
import invoker54.reviveme.common.config.ReviveMeConfig;
import invoker54.reviveme.common.network.NetworkHandler;
import invoker54.reviveme.common.network.message.SelfReviveMsg;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="revive_me", value={Dist.CLIENT})
public class FallenPlayerActionsEvent {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Minecraft inst = Minecraft.m_91087_();
    public static int timeHeld = 0;

    @SubscribeEvent
    public static void forceDeath(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.SERVER) {
            return;
        }
        if (event.type != TickEvent.Type.PLAYER) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        if (event.player != ClientUtil.getPlayer()) {
            return;
        }
        FallenCapability cap = FallenCapability.GetFallCap((LivingEntity)FallenPlayerActionsEvent.inst.f_91074_);
        if (!cap.isFallen()) {
            return;
        }
        if (!VanillaKeybindHandler.useHeld && !VanillaKeybindHandler.attackHeld) {
            timeHeld = 0;
            return;
        }
        if (VanillaKeybindHandler.attackHeld) {
            ++timeHeld;
            if (!ClientUtil.getPlayer().f_20911_) {
                ClientUtil.getPlayer().m_6674_(InteractionHand.MAIN_HAND);
            }
            if (timeHeld == 40) {
                NetworkHandler.INSTANCE.sendToServer((Object)new SelfReviveMsg(0));
            }
        } else if (VanillaKeybindHandler.useHeld && cap.canSelfRevive()) {
            ClientUtil.getPlayer().m_6674_(InteractionHand.MAIN_HAND);
            if (++timeHeld == 40) {
                NetworkHandler.INSTANCE.sendToServer((Object)new SelfReviveMsg(1));
            }
        }
        timeHeld = Math.min(timeHeld, 41);
    }

    @SubscribeEvent
    public static void modifyFOV(ComputeFovModifierEvent event) {
        Player player = event.getPlayer();
        FallenCapability cap = FallenCapability.GetFallCap((LivingEntity)player);
        if (!cap.isFallen()) {
            return;
        }
        float f = 1.0f;
        if (player.m_150110_().f_35935_) {
            f *= 1.1f;
        }
        f = (float)((double)f * ((player.m_21133_(Attributes.f_22279_) / (double)player.m_150110_().m_35947_() + 1.0) / 2.0));
        if (player.m_150110_().m_35947_() == 0.0f || Float.isNaN(f) || Float.isInfinite(f)) {
            f = 1.0f;
        }
        int i = timeHeld;
        float f1 = Math.min((float)i / 40.0f, 1.0f);
        f1 *= f1;
        event.setNewFovModifier(f *= 1.0f - f1 * 0.15f);
    }

    @SubscribeEvent
    public static void openInventory(ScreenEvent.Opening event) {
        if (ClientUtil.getWorld() == null) {
            return;
        }
        if (ClientUtil.getPlayer() == null) {
            return;
        }
        if (!FallenCapability.GetFallCap((LivingEntity)ClientUtil.getPlayer()).isFallen()) {
            return;
        }
        if (!(event.getScreen() instanceof InventoryScreen)) {
            return;
        }
        if (ReviveMeConfig.interactWithInventory != ReviveMeConfig.INTERACT_WITH_INVENTORY.NO) {
            return;
        }
        event.setCanceled(true);
    }
}

