/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.client.event;

import invoker54.invocore.client.util.ClientUtil;
import invoker54.invocore.client.util.InvoSound;
import invoker54.invocore.common.ModLogger;
import invoker54.invocore.common.util.MathUtil;
import invoker54.reviveme.common.capability.FallenCapability;
import invoker54.reviveme.common.config.ReviveMeConfig;
import invoker54.reviveme.init.SoundInit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Vector3d;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="revive_me")
public class SoundEvents {
    private static final ModLogger LOGGER = ModLogger.getLogger(SoundEvents.class, (AtomicBoolean)ReviveMeConfig.debugMode);
    private static final InvoSound fallen_state_random_sound = new InvoSound(SoundInit.FALLEN_STATE_HEART_BEAT, SoundSource.AMBIENT).setVolume((float)(1.0 * ReviveMeConfig.soundLevel)).setPitch(1.0f).setRepeatDelay(200, true).setGlobal(true).setPreModifySound(invoSound -> {
        invoSound.setPitch(MathUtil.randomFloat((float)0.8f, (float)1.2f));
        invoSound.setVolume((float)((double)MathUtil.randomFloat((float)1.3f, (float)1.1f) * ReviveMeConfig.soundLevel));
        int delay = MathUtil.randomInt((int)10, (int)16);
        invoSound.setRepeatDelay(delay * 20, true);
    });
    private static final InvoSound fallen_state_ticking_sound = new InvoSound(SoundInit.FALLEN_STATE_TICK_TOCK, SoundSource.AMBIENT).setGlobal(true).setPreModifySound(invoSound -> {
        Player player = ClientUtil.getPlayer();
        if (player == null) {
            return;
        }
        FallenCapability cap = FallenCapability.GetFallCap((LivingEntity)player);
        float percentage = cap.GetTimeLeft(true);
        if (ReviveMeConfig.timeLeft == 0) {
            invoSound.setPitch(MathUtil.randomFloat((float)0.5f, (float)0.75f));
            invoSound.setVolume((float)((double)MathUtil.randomFloat((float)0.1f, (float)0.3f) * ReviveMeConfig.soundLevel));
            invoSound.setRepeatDelay(100, false);
        } else {
            invoSound.setPitch(MathUtil.lerp((double)percentage, (double)0.7f, (double)0.4f));
            invoSound.setVolume((float)((double)MathUtil.lerp((double)(1.0 - Math.pow(2.0, -10.0f * percentage)), (double)0.3f, (double)0.01f) * ReviveMeConfig.soundLevel));
            invoSound.setRepeatDelay(0, false);
        }
    });
    private static final InvoSound revive_sound = new InvoSound(SoundInit.REVIVE_BEAT, SoundSource.PLAYERS).setVolume(0.9f).setPitch(1.0f).setGlobal(true).setPreModifySound(invoSound -> {
        Player player = ClientUtil.getPlayer();
        if (player == null) {
            return;
        }
        FallenCapability cap = FallenCapability.GetFallCap((LivingEntity)player);
        float pitch = MathUtil.lerp((double)cap.getProgress(true), (double)0.8f, (double)1.2f);
        invoSound.setVolume((float)(1.0 * ReviveMeConfig.soundLevel));
        invoSound.setPitch(pitch);
    });
    private static final InvoSound revive_background_sound = new InvoSound(SoundInit.REVIVE_BACKGROUND, SoundSource.PLAYERS).setVolume((float)((double)0.4f * ReviveMeConfig.soundLevel)).setPitch(1.0f).setGlobal(true).setPreModifySound(is -> {
        is.setVolume((float)((double)0.3f * ReviveMeConfig.soundLevel));
        is.setPitch(MathUtil.randomFloat((float)0.7f, (float)1.1f));
    });

    @SubscribeEvent
    public static void fallenNoiseEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        if (ClientUtil.getPlayer() == null) {
            return;
        }
        FallenCapability cap = FallenCapability.GetFallCap((LivingEntity)ClientUtil.getPlayer());
        if (!cap.isFallen() || cap.getOtherPlayer() != null) {
            return;
        }
        if (cap.GetTimeLeft(false) > 5.0f) {
            fallen_state_random_sound.playWhenStopped();
        }
        if (cap.GetTimeLeft(false) % 1.0f == 0.0f && cap.GetTimeLeft(false) > 0.0f || ReviveMeConfig.timeLeft == 0) {
            fallen_state_ticking_sound.play();
        }
    }

    @SubscribeEvent
    public static void reviveNoiseEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        if (ClientUtil.getPlayer() == null) {
            return;
        }
        FallenCapability cap = FallenCapability.GetFallCap((LivingEntity)ClientUtil.getPlayer());
        if (cap.getOtherPlayer() == null) {
            if (!revive_background_sound.isDonePlaying()) {
                revive_background_sound.stopIt();
            }
            return;
        }
        if (cap.getProgress(false) / 20.0f % 0.5f == 0.0f && cap.GetTimeLeft(true) != 1.0f) {
            revive_sound.play();
        }
        revive_background_sound.playWhenStopped();
    }

    @SubscribeEvent
    public static void onReviveEvent(PlaySoundEvent event) {
        if (event.getSound() instanceof InvoSound) {
            return;
        }
        if (!SoundInit.REVIVED.m_11660_().m_135815_().equals(event.getName())) {
            return;
        }
        SoundInstance prevSound = event.getSound();
        event.setSound((SoundInstance)new InvoSound(SoundInit.REVIVED, SoundSource.PLAYERS).setVolume(MathUtil.randomFloat((float)0.7f, (float)0.9f)).setPitch(MathUtil.randomFloat((float)0.8f, (float)1.0f)).setPos(new Vector3d(prevSound.m_7772_(), prevSound.m_7780_(), prevSound.m_7778_())));
    }
}

