/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.common.potion;

import invoker54.reviveme.common.capability.FallenCapability;
import invoker54.reviveme.init.MobEffectInit;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class KillRevivePotionEffect
extends MobEffect {
    public static final int effectColor = new Color(35, 5, 5, 255).getRGB();
    public static DamageSource killReviveDamageSource = new DamageSource("revive-me.damage_source.kill_revive").m_19380_().m_19381_().m_19382_();

    public KillRevivePotionEffect(MobEffectCategory category) {
        super(category, effectColor);
    }

    public List<ItemStack> getCurativeItems() {
        return new ArrayList<ItemStack>();
    }

    @Mod.EventBusSubscriber(modid="reviveme")
    public static class PotionEvents {
        @SubscribeEvent
        public static void killMobEvent(LivingDeathEvent event) {
            Entity sourceEntity = event.getSource().m_7639_();
            if (!(sourceEntity instanceof Player)) {
                return;
            }
            LivingEntity entity = (LivingEntity)sourceEntity;
            MobEffectInstance instance = entity.m_21124_(MobEffectInit.KILL_REVIVE_EFFECT);
            if (instance == null) {
                return;
            }
            entity.m_21195_(MobEffectInit.KILL_REVIVE_EFFECT);
            if (instance.m_19564_() > 0) {
                entity.m_21195_(MobEffectInit.KILL_REVIVE_EFFECT);
                entity.m_7292_(new MobEffectInstance(MobEffectInit.KILL_REVIVE_EFFECT, instance.m_19557_(), instance.m_19564_() - 1));
            }
        }

        @SubscribeEvent
        public static void expireEvent(PotionEvent.PotionExpiryEvent event) {
            PotionEvents.removeEffect(event.getEntityLiving(), event.getPotionEffect(), false);
        }

        @SubscribeEvent
        public static void removeEvent(PotionEvent.PotionRemoveEvent event) {
            PotionEvents.removeEffect(event.getEntityLiving(), event.getPotionEffect(), true);
        }

        public static void removeEffect(LivingEntity entity, MobEffectInstance effect, boolean completed) {
            if (effect == null) {
                return;
            }
            if (!(effect.m_19544_() instanceof KillRevivePotionEffect)) {
                return;
            }
            if (!(entity instanceof Player)) {
                return;
            }
            FallenCapability cap = FallenCapability.GetFallCap(entity);
            if (cap.isFallen()) {
                return;
            }
            if (completed) {
                return;
            }
            entity.m_21153_(1.0E-8f);
            entity.m_6469_(killReviveDamageSource, 1.0f);
        }
    }
}

