/*
 * Decompiled with CFR 0.152.
 */
package net.deskped.myped;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.BookEditScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="myped")
public class BookDefender {

    @Mod.EventBusSubscriber(modid="myped", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ServerEvents {
        private static final int MAX_PAGES_SIGNED = 32;

        @SubscribeEvent
        public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
            ItemStack stack;
            int i;
            Player player = event.player;
            if (player.m_9236_().m_5776_()) {
                return;
            }
            for (i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                stack = (ItemStack)player.m_150109_().f_35974_.get(i);
                if (stack.m_41720_() != Items.f_42615_ || !stack.m_41782_()) continue;
                ServerEvents.trimBookPages(stack, player);
            }
            for (i = 0; i < player.m_150109_().f_35976_.size(); ++i) {
                stack = (ItemStack)player.m_150109_().f_35976_.get(i);
                if (stack.m_41720_() != Items.f_42615_ || !stack.m_41782_()) continue;
                ServerEvents.trimBookPages(stack, player);
            }
        }

        private static void trimBookPages(ItemStack book, Player player) {
            ListTag pages;
            CompoundTag tag = book.m_41783_();
            if (tag.m_128425_("pages", 9) && (pages = tag.m_128437_("pages", 8)).size() > 32) {
                ListTag trimmed = new ListTag();
                for (int i = 0; i < 32; ++i) {
                    trimmed.add((Object)pages.get(i));
                }
                tag.m_128365_("pages", (Tag)trimmed);
                player.m_213846_((Component)Component.m_237113_((String)"Book closed: 30-page limit reached"));
            }
        }
    }

    @Mod.EventBusSubscriber(modid="myped", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    public static class ClientEvents {
        private static final int MAX_PAGES = 30;
        private static boolean triggered = false;

        @SubscribeEvent
        public static void onScreenRender(ScreenEvent.Render.Post event) {
            Screen screen = event.getScreen();
            if (!(screen instanceof BookEditScreen)) {
                triggered = false;
                return;
            }
            Minecraft mc = Minecraft.m_91087_();
            ItemStack book = mc.f_91074_.m_21205_();
            if (book.m_41720_() != Items.f_42614_) {
                return;
            }
            CompoundTag tag = book.m_41784_();
            if (!tag.m_128425_("pages", 9)) {
                return;
            }
            ListTag pages = tag.m_128437_("pages", 8);
            if (pages.size() > 30) {
                ListTag trimmed = new ListTag();
                for (int i = 0; i < 30; ++i) {
                    trimmed.add((Object)pages.get(i));
                }
                tag.m_128365_("pages", (Tag)trimmed);
                mc.m_91152_(null);
                String lang = mc.m_91102_().m_264236_();
                if (lang != null && lang.toLowerCase().startsWith("ru")) {
                    mc.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u041a\u043d\u0438\u0433\u0430 \u0437\u0430\u043a\u0440\u044b\u0442\u0430: \u0434\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442 \u043b\u0438\u043c\u0438\u0442 30 \u0441\u0442\u0440\u0430\u043d\u0438\u0446"));
                } else {
                    mc.f_91074_.m_213846_((Component)Component.m_237113_((String)"Book closed: 30-page limit reached"));
                }
            }
        }
    }
}

