/*
 * Decompiled with CFR 0.152.
 */
package net.deskped.myped;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="myped", bus=Mod.EventBusSubscriber.Bus.MOD)
public class HARDCORE {
    public HARDCORE() {
        MinecraftForge.EVENT_BUS.register(HARDCOREForgeEvents.class);
    }

    @Mod.EventBusSubscriber(modid="myped", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class HARDCOREForgeEvents {
        private static final ConcurrentHashMap<UUID, Float> preArmorDamage = new ConcurrentHashMap();
        private static final float PLAYER_DAMAGE_MULTIPLIER = 0.1f;

        @SubscribeEvent
        public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            Player player = event.player;
            if (player == null) {
                return;
            }
            if (player.m_9236_() == null || player.m_9236_().m_5776_()) {
                return;
            }
            AttributeInstance maxHealthAttr = player.m_21051_(Attributes.f_22276_);
            if (maxHealthAttr != null && maxHealthAttr.m_22115_() != 20.0) {
                maxHealthAttr.m_22100_(20.0);
            }
            if (player.m_6103_() > 0.0f) {
                player.m_7911_(0.0f);
            }
            if (player.m_21223_() > 20.0f) {
                player.m_21153_(20.0f);
            }
        }

        @SubscribeEvent
        public static void onClone(PlayerEvent.Clone event) {
            Player player = event.getEntity();
            if (player == null) {
                return;
            }
            if (player.m_9236_() == null || player.m_9236_().m_5776_()) {
                return;
            }
            AttributeInstance maxHealthAttr = player.m_21051_(Attributes.f_22276_);
            if (maxHealthAttr != null) {
                maxHealthAttr.m_22100_(20.0);
            }
            player.m_7911_(0.0f);
            if (player.m_21223_() > 20.0f) {
                player.m_21153_(20.0f);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
            event.setNewSpeed(event.getNewSpeed() * 0.5f);
        }

        @SubscribeEvent
        public static void onLivingHurt(LivingHurtEvent event) {
            LivingEntity target = event.getEntity();
            if (target instanceof Player) {
                Player player = (Player)target;
                if (player.m_9236_() == null || player.m_9236_().m_5776_()) {
                    return;
                }
                preArmorDamage.put(player.m_20148_(), Float.valueOf(event.getAmount()));
            }
        }

        @SubscribeEvent
        public static void onLivingDamage(LivingDamageEvent event) {
            boolean attackerIsPlayer;
            LivingEntity target = event.getEntity();
            if (target == null) {
                return;
            }
            if (target.m_9236_() == null || target.m_9236_().m_5776_()) {
                return;
            }
            boolean bl = attackerIsPlayer = event.getSource() != null && event.getSource().m_7639_() instanceof Player;
            if (target instanceof Player) {
                float base;
                Player targetPlayer = (Player)target;
                Float baseDamage = preArmorDamage.remove(targetPlayer.m_20148_());
                float f = base = baseDamage != null ? baseDamage.floatValue() : event.getAmount();
                if (attackerIsPlayer) {
                    base *= 0.1f;
                }
                event.setAmount(Math.max(0.0f, base));
            } else if (attackerIsPlayer) {
                float base = event.getAmount();
                event.setAmount(Math.max(0.0f, base *= 0.1f));
            }
        }

        @SubscribeEvent
        public static void onLivingTick(LivingEvent.LivingTickEvent event) {
            MobEffectInstance resist;
            LivingEntity entity = event.getEntity();
            if (entity == null || entity.m_9236_().m_5776_()) {
                return;
            }
            if (!(entity instanceof Monster)) {
                return;
            }
            if (entity.f_19797_ % 100 != 0) {
                return;
            }
            MobEffectInstance regen = entity.m_21124_(MobEffects.f_19605_);
            if (regen == null || regen.m_19557_() < 200) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19605_, Integer.MAX_VALUE, 1, false, false, false));
            }
            if ((resist = entity.m_21124_(MobEffects.f_19606_)) == null || resist.m_19557_() < 200) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19606_, Integer.MAX_VALUE, 0, false, false, false));
            }
        }
    }
}

