/*
 * Decompiled with CFR 0.152.
 */
package net.deskped.myped;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class Unbreakable {
    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        new Unbreakable();
    }

    @Mod.EventBusSubscriber
    private static class UnbreakableGlobalEvents {
        private UnbreakableGlobalEvents() {
        }

        @SubscribeEvent
        public static void onServerTick(TickEvent.ServerTickEvent event) {
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server == null) {
                return;
            }
            for (ServerPlayer player : server.m_6846_().m_11314_()) {
                UnbreakableGlobalEvents.cleanInventory((Player)player);
            }
        }

        @SubscribeEvent
        public static void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
            UnbreakableGlobalEvents.removeUnbreakable(event.getCrafting());
        }

        @SubscribeEvent
        public static void onItemPickup(PlayerEvent.ItemPickupEvent event) {
            ItemStack stack = event.getStack();
            UnbreakableGlobalEvents.removeUnbreakable(stack);
        }

        @SubscribeEvent
        public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
            if (event.phase != TickEvent.Phase.END || event.player.m_9236_().f_46443_) {
                return;
            }
            UnbreakableGlobalEvents.cleanInventory(event.player);
        }

        private static void cleanInventory(Player player) {
            for (ItemStack stack : player.m_150109_().f_35974_) {
                UnbreakableGlobalEvents.removeUnbreakable(stack);
            }
            for (ItemStack stack : player.m_150109_().f_35976_) {
                UnbreakableGlobalEvents.removeUnbreakable(stack);
            }
            for (ItemStack stack : player.m_150109_().f_35975_) {
                UnbreakableGlobalEvents.removeUnbreakable(stack);
            }
        }

        private static void removeUnbreakable(ItemStack stack) {
            CompoundTag tag;
            if (!stack.m_41619_() && stack.m_41782_() && (tag = stack.m_41783_()) != null && tag.m_128441_("Unbreakable")) {
                tag.m_128473_("Unbreakable");
            }
        }
    }

    @Mod.EventBusSubscriber
    private static class UnbreakableForgeBusEvents {
        private UnbreakableForgeBusEvents() {
        }

        @SubscribeEvent
        public static void serverLoad(ServerStartingEvent event) {
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public static void clientLoad(FMLClientSetupEvent event) {
        }
    }
}

