/*
 * Decompiled with CFR 0.152.
 */
package net.deskped.myped.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.deskped.myped.block.entity.FlyBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class FlyRenderer
implements BlockEntityRenderer<FlyBlockEntity> {
    private static final double BASE_HEIGHT = 0.125;
    private static final float SCALE = 1.7f;
    private static final double SMOOTHNESS = 0.12;
    private final Map<BlockPos, Double> rotMap = new ConcurrentHashMap<BlockPos, Double>();
    private final Map<BlockPos, Double> bobMap = new ConcurrentHashMap<BlockPos, Double>();
    private final Map<BlockPos, Long> timeMap = new ConcurrentHashMap<BlockPos, Long>();

    public FlyRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(FlyBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        ItemStack stack = blockEntity.m_8020_(0);
        if (stack == null || stack.m_41619_()) {
            return;
        }
        BlockPos pos = blockEntity.m_58899_();
        long now = System.nanoTime();
        long last = this.timeMap.getOrDefault(pos, now);
        double dtSeconds = Math.max(0.0, (double)(now - last) / 1.0E9);
        this.timeMap.put(pos, now);
        double gameTime = (float)(blockEntity.m_58904_() != null ? blockEntity.m_58904_().m_46467_() : 0L) + partialTicks;
        double desiredRot = gameTime * 4.0;
        double desiredBob = Math.sin(gameTime * 0.1) * 0.08 + 0.08;
        double prevRot = this.rotMap.getOrDefault(pos, desiredRot);
        double prevBob = this.bobMap.getOrDefault(pos, desiredBob);
        double alpha = 1.0 - Math.exp(-0.12 * Math.max(1.0E-6, dtSeconds * 60.0));
        double smoothedRot = prevRot + (desiredRot - prevRot) * alpha;
        double smoothedBob = prevBob + (desiredBob - prevBob) * alpha;
        this.rotMap.put(pos, smoothedRot);
        this.bobMap.put(pos, smoothedBob);
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.125 + smoothedBob, 0.5);
        poseStack.m_85841_(1.7f, 1.7f, 1.7f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_((float)smoothedRot));
        poseStack.m_252781_(Axis.f_252529_.m_252977_((float)(Math.sin(gameTime * (double)0.05f) * 45.0)));
        poseStack.m_252781_(Axis.f_252403_.m_252977_((float)(Math.cos(gameTime * (double)0.03f) * 30.0)));
        int seed = pos.hashCode();
        Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.FIXED, combinedLight, combinedOverlay, poseStack, bufferSource, blockEntity.m_58904_(), seed);
        poseStack.m_85849_();
    }
}

