/*
 * Decompiled with CFR 0.152.
 */
package net.deskped.myped.potion;

import com.mojang.blaze3d.platform.Window;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.extensions.common.IClientMobEffectExtensions;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class BlacknessMobEffect
extends MobEffect {
    public BlacknessMobEffect() {
        super(MobEffectCategory.NEUTRAL, -16777216);
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }

    public void initializeClient(Consumer<IClientMobEffectExtensions> consumer) {
        consumer.accept(new IClientMobEffectExtensions(){

            public boolean isVisibleInInventory(MobEffectInstance effect) {
                return false;
            }

            public boolean renderInventoryText(MobEffectInstance instance, EffectRenderingInventoryScreen<?> screen, GuiGraphics guiGraphics, int x, int y, int blitOffset) {
                return false;
            }

            public boolean isVisibleInGui(MobEffectInstance effect) {
                return false;
            }
        });
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ClientHandler {
        private static float darknessAlpha = 0.0f;
        private static float targetAlpha = 0.0f;
        private static final float ALPHA_STEP = 0.05f;
        private static float textAlpha = 0.0f;
        private static final float TEXT_ALPHA_STEP = 0.03f;
        private static float textY = -20.0f;
        private static float targetTextY = 0.0f;
        private static final float TEXT_Y_STEP = 2.0f;
        private static final int LIGHT_CHECK_RADIUS = 6;
        private static final int SKY_LIGHT_DAY_THRESHOLD = 12;
        private static final long DAY_START = 0L;
        private static final long DAY_END = 12000L;
        private static final int BLINDNESS_DURATION = -1;
        private static final int BLINDNESS_AMPLIFIER = 0;
        private static final ResourceKey<Biome> MY_VOID_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("myped", "my_void"));

        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            boolean shouldBeDark;
            ItemStack[] hands;
            int combinedLight;
            if (event.phase != TickEvent.Phase.START) {
                return;
            }
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ == null || mc.f_91074_ == null) {
                targetAlpha = 0.0f;
                return;
            }
            boolean hasBlackness = false;
            try {
                for (MobEffectInstance ei : mc.f_91074_.m_21220_()) {
                    if (ei == null || ei.m_19544_() == null || !ei.m_19544_().getClass().equals(BlacknessMobEffect.class)) continue;
                    hasBlackness = true;
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!hasBlackness) {
                if (mc.f_91074_.m_21023_(MobEffects.f_19610_)) {
                    mc.f_91074_.m_21195_(MobEffects.f_19610_);
                }
                targetAlpha = 0.0f;
                targetTextY = -20.0f;
                if (darknessAlpha < targetAlpha) {
                    darknessAlpha = Math.min(targetAlpha, darknessAlpha + 0.05f);
                } else if (darknessAlpha > targetAlpha) {
                    darknessAlpha = Math.max(targetAlpha, darknessAlpha - 0.05f);
                }
                float targetTextAlpha = targetAlpha;
                if (textAlpha < targetTextAlpha) {
                    textAlpha = Math.min(targetTextAlpha, textAlpha + 0.03f);
                } else if (textAlpha > targetTextAlpha) {
                    textAlpha = Math.max(targetTextAlpha, textAlpha - 0.03f);
                }
                if (textY < targetTextY) {
                    textY = Math.min(targetTextY, textY + 2.0f);
                } else if (textY > targetTextY) {
                    textY = Math.max(targetTextY, textY - 2.0f);
                }
                return;
            }
            ClientLevel level = mc.f_91073_;
            boolean forceNoDarkness = false;
            if (!level.m_46472_().equals((Object)Level.f_46428_)) {
                forceNoDarkness = true;
            }
            BlockPos playerPos = mc.f_91074_.m_20183_();
            boolean inFluid = false;
            try {
                FluidState fluidAtPos = level.m_6425_(playerPos);
                if (!fluidAtPos.m_76178_()) {
                    inFluid = true;
                }
            }
            catch (Exception fluidAtPos) {
                // empty catch block
            }
            try {
                if (mc.f_91074_.m_20069_() || mc.f_91074_.m_20077_()) {
                    inFluid = true;
                }
            }
            catch (Exception fluidAtPos) {
                // empty catch block
            }
            if (inFluid) {
                forceNoDarkness = true;
            }
            boolean isCreative = false;
            try {
                isCreative = mc.f_91074_.m_150110_() != null && mc.f_91074_.m_150110_().f_35937_;
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean isSpectator = false;
            try {
                isSpectator = mc.f_91074_.m_5833_();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (isCreative || isSpectator) {
                forceNoDarkness = true;
            }
            boolean inMyVoid = false;
            try {
                Optional keyOpt = level.m_204166_(playerPos).m_203543_();
                if (keyOpt.isPresent() && ((ResourceKey)keyOpt.get()).equals(MY_VOID_KEY)) {
                    inMyVoid = true;
                }
            }
            catch (Exception keyOpt) {
                // empty catch block
            }
            int maxBlockLight = 0;
            int r = 6;
            block17: for (int dx = -r; dx <= r; ++dx) {
                for (int dy = -r; dy <= r; ++dy) {
                    for (int dz = -r; dz <= r; ++dz) {
                        BlockPos p = playerPos.m_7918_(dx, dy, dz);
                        int blockLight = level.m_45517_(LightLayer.BLOCK, p);
                        if (blockLight > maxBlockLight) {
                            maxBlockLight = blockLight;
                        }
                        if (maxBlockLight > 1) break block17;
                    }
                }
            }
            boolean noNearbyLight = (combinedLight = maxBlockLight) <= 1;
            boolean holdingLightSource = false;
            for (ItemStack stack : hands = new ItemStack[]{mc.f_91074_.m_21205_(), mc.f_91074_.m_21206_()}) {
                BlockItem blockItem;
                BlockState state;
                if (stack == null || stack.m_41619_()) continue;
                Item item = stack.m_41720_();
                if (item instanceof BlockItem && (state = (blockItem = (BlockItem)item).m_40614_().m_49966_()).m_60791_() > 0) {
                    holdingLightSource = true;
                    break;
                }
                int itemLight = 0;
                try {
                    Method m = item.getClass().getMethod("getLightEmission", ItemStack.class);
                    Object res = m.invoke((Object)item, stack);
                    if (res instanceof Number) {
                        itemLight = ((Number)res).intValue();
                    }
                }
                catch (Exception ignored) {
                    try {
                        Method m2 = item.getClass().getMethod("getLightLevel", ItemStack.class);
                        Object res2 = m2.invoke((Object)item, stack);
                        if (res2 instanceof Number) {
                            itemLight = ((Number)res2).intValue();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (itemLight <= 0) continue;
                holdingLightSource = true;
                break;
            }
            boolean hasNightVision = mc.f_91074_.m_21023_(MobEffects.f_19611_);
            if (inMyVoid) {
                shouldBeDark = maxBlockLight < 4 && !forceNoDarkness;
            } else {
                boolean globallyLit = combinedLight >= 4;
                boolean bl = shouldBeDark = !globallyLit && !holdingLightSource && !hasNightVision && !forceNoDarkness;
            }
            if (shouldBeDark) {
                if (!mc.f_91074_.m_21023_(MobEffects.f_19610_) || mc.f_91074_.m_21124_(MobEffects.f_19610_).m_19557_() < 0) {
                    mc.f_91074_.m_7292_(new MobEffectInstance(MobEffects.f_19610_, -1, 0, false, false, false));
                }
            } else if (mc.f_91074_.m_21023_(MobEffects.f_19610_)) {
                mc.f_91074_.m_21195_(MobEffects.f_19610_);
            }
            targetAlpha = shouldBeDark ? 1.0f : 0.0f;
            float f = targetTextY = targetAlpha > 0.0f ? 50.0f : -20.0f;
            if (darknessAlpha < targetAlpha) {
                darknessAlpha = Math.min(targetAlpha, darknessAlpha + 0.05f);
            } else if (darknessAlpha > targetAlpha) {
                darknessAlpha = Math.max(targetAlpha, darknessAlpha - 0.05f);
            }
            float targetTextAlpha = targetAlpha;
            if (textAlpha < targetTextAlpha) {
                textAlpha = Math.min(targetTextAlpha, textAlpha + 0.03f);
            } else if (textAlpha > targetTextAlpha) {
                textAlpha = Math.max(targetTextAlpha, textAlpha - 0.03f);
            }
            if (textY < targetTextY) {
                textY = Math.min(targetTextY, textY + 2.0f);
            } else if (textY > targetTextY) {
                textY = Math.max(targetTextY, textY - 2.0f);
            }
        }

        @SubscribeEvent
        public static void onRenderGuiOverlay(RenderGuiOverlayEvent.Pre event) {
            if (darknessAlpha <= 0.001f && textAlpha <= 0.001f) {
                return;
            }
            Minecraft mc = Minecraft.m_91087_();
            if (mc == null) {
                return;
            }
            if (mc.f_91073_ == null || mc.f_91074_ == null) {
                return;
            }
            if (!mc.f_91073_.m_46472_().equals((Object)Level.f_46428_)) {
                return;
            }
            int alphaInt = Math.round(darknessAlpha * 255.0f) & 0xFF;
            int color = alphaInt << 24;
            Window window = mc.m_91268_();
            int w = window.m_85445_();
            int h = window.m_85446_();
            GuiGraphics gg = event.getGuiGraphics();
            gg.m_280509_(0, 0, w, h, color);
            String lang = "en";
            try {
                if (mc.m_91102_() != null && mc.m_91102_().m_264236_() != null) {
                    lang = mc.m_91102_().m_264236_();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            String message = lang.toLowerCase().startsWith("ru") ? "\u0418\u0437\u0431\u0435\u0433\u0430\u0439\u0442\u0435 \u0442\u0435\u043c\u043d\u043e\u0442\u044b, \u0434\u0435\u0440\u0436\u0438\u0442\u0435 \u0441\u0432\u0435\u0442 \u0432 \u0440\u0443\u043a\u0430\u0445" : "Avoid darkness while holding a light source";
            int textAlphaInt = Math.round(textAlpha * 255.0f) & 0xFF;
            int textColor = textAlphaInt << 24 | 0xFFFFFF;
            int textWidth = mc.f_91062_.m_92895_(message);
            gg.m_280056_(mc.f_91062_, message, (w - textWidth) / 2, (int)textY, textColor, false);
        }
    }
}

