/*
 * Decompiled with CFR 0.152.
 */
package net.deskped.myped.procedures;

import java.util.concurrent.ThreadLocalRandom;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class EarthquakeTikProcedure {
    private static boolean registered = false;
    private static double strength = 0.0;
    private static double time = 0.0;
    private static final double DECAY_PER_SECOND = 2.5;
    private static final double BASE_FREQ = 8.0;
    private static final double BASE_FREQ2 = 13.0;
    private static final double BASE_FREQ3 = 21.0;
    private static final double PITCH_SCALE = 0.4;
    private static final double YAW_SCALE = 0.6;
    private static final double ROLL_SCALE = 0.3;
    private static final double SEED_A = ThreadLocalRandom.current().nextDouble() * 1000.0;
    private static final double SEED_B = ThreadLocalRandom.current().nextDouble() * 1000.0;
    private static final double SEED_C = ThreadLocalRandom.current().nextDouble() * 1000.0;

    public static void execute() {
        if ((strength += 0.18) > 2.0) {
            strength = 2.0;
        }
        if (strength > 0.0) {
            time = 0.0;
        }
        if (FMLEnvironment.dist == Dist.CLIENT) {
            EarthquakeTikProcedure.setupClient();
        }
    }

    private static void setupClient() {
        if (registered) {
            return;
        }
        registered = true;
        MinecraftForge.EVENT_BUS.register(new Object(){

            @SubscribeEvent(priority=EventPriority.NORMAL)
            public void onComputeCameraAngles(ViewportEvent.ComputeCameraAngles ev) {
                if (strength <= 1.0E-4) {
                    return;
                }
                double dt = Math.max(0.0, ev.getPartialTick());
                double damp = Math.exp(-2.5 * (time += dt * 1.0) * 0.016);
                double t = time;
                double s1 = Math.sin(t * 8.0 + SEED_A) + 0.5 * Math.sin(t * 13.0 + SEED_B);
                double s2 = Math.cos(t * 13.0 + SEED_B) + 0.35 * Math.cos(t * 21.0 + SEED_C);
                double s3 = Math.sin(t * 21.0 + SEED_C) * 0.7 + Math.cos(t * 8.0 + SEED_A) * 0.3;
                float yawOffset = (float)(s1 * 0.6 * strength * damp);
                float pitchOffset = (float)(s2 * 0.4 * strength * damp);
                float rollOffset = (float)(s3 * 0.3 * strength * damp);
                ev.setYaw(ev.getYaw() + yawOffset);
                ev.setPitch(EarthquakeTikProcedure.clampPitch(ev.getPitch() + pitchOffset));
                ev.setRoll(ev.getRoll() + rollOffset);
                strength -= 0.04;
                if (strength < 0.0) {
                    strength = 0.0;
                }
                if (strength <= 1.0E-4) {
                    time = 0.0;
                }
            }
        });
    }

    private static float clampPitch(float p) {
        if (p > 90.0f) {
            return 90.0f;
        }
        if (p < -90.0f) {
            return -90.0f;
        }
        return p;
    }
}

