/*
 * Decompiled with CFR 0.152.
 */
package net.deskped.myped;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="myped")
public class BenisonCode {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final BenisonManager manager = new BenisonManager();

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        MinecraftServer server;
        if (event.phase == TickEvent.Phase.END && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
            manager.tick(server);
        }
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"myped").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"benison").requires(src -> src.m_6761_(2))).then(Commands.m_82127_((String)"status").executes(ctx -> {
            Object timeStr;
            CommandSourceStack src = (CommandSourceStack)ctx.getSource();
            BlockPos last = manager.getLastPos();
            int remaining = manager.getRemainingTicks();
            if (remaining < 0) {
                timeStr = "\u0410\u0432\u0442\u043e\u0441\u043f\u0430\u0432\u043d \u043e\u0442\u043a\u043b\u044e\u0447\u0451\u043d";
            } else {
                int secs = remaining / 20;
                int mins = secs / 60;
                timeStr = mins + ":" + (String)((secs %= 60) < 10 ? "0" + secs : Integer.toString(secs));
            }
            if (last != null) {
                Supplier<Component> comp = () -> BenisonCode.lambda$onRegisterCommands$1(last, (String)timeStr);
                src.m_288197_(comp, false);
            } else {
                Supplier<Component> comp = () -> BenisonCode.lambda$onRegisterCommands$2((String)timeStr);
                src.m_288197_(comp, false);
            }
            return 1;
        }))).then(Commands.m_82127_((String)"spawn").executes(ctx -> {
            CommandSourceStack src = (CommandSourceStack)ctx.getSource();
            ServerLevel overworld = src.m_81377_().m_129880_(Level.f_46428_);
            if (overworld == null) {
                src.m_81352_((Component)Component.m_237113_((String)"Overworld \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d.").m_130940_(ChatFormatting.RED));
                return 0;
            }
            boolean ok = manager.spawnNow(overworld);
            if (!ok) {
                src.m_81352_((Component)Component.m_237113_((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0435\u0435 \u043c\u0435\u0441\u0442\u043e \u0434\u043b\u044f \u0441\u043f\u0430\u0432\u043d\u0430.").m_130940_(ChatFormatting.RED));
            }
            return ok ? 1 : 0;
        }))).then(Commands.m_82127_((String)"stop").executes(ctx -> {
            manager.setEnabled(false, ((CommandSourceStack)ctx.getSource()).m_81372_() instanceof ServerLevel ? ((CommandSourceStack)ctx.getSource()).m_81372_() : null);
            Supplier<Component> comp = () -> Component.m_237113_((String)"\u0410\u0432\u0442\u043e\u0441\u043f\u0430\u0432\u043d \u0411\u043b\u0430\u0433\u043e\u0441\u043b\u0430\u0432\u0435\u043d\u0438\u044f \u043e\u0442\u043a\u043b\u044e\u0447\u0451\u043d.").m_130940_(ChatFormatting.AQUA);
            ((CommandSourceStack)ctx.getSource()).m_288197_(comp, true);
            return 1;
        }))).then(Commands.m_82127_((String)"start").executes(ctx -> {
            manager.setEnabled(true, ((CommandSourceStack)ctx.getSource()).m_81372_() instanceof ServerLevel ? ((CommandSourceStack)ctx.getSource()).m_81372_() : null);
            manager.resetCounter();
            Supplier<Component> comp = () -> Component.m_237113_((String)"\u0410\u0432\u0442\u043e\u0441\u043f\u0430\u0432\u043d \u0411\u043b\u0430\u0433\u043e\u0441\u043b\u0430\u0432\u0435\u043d\u0438\u044f \u0432\u043a\u043b\u044e\u0447\u0451\u043d.").m_130940_(ChatFormatting.AQUA);
            ((CommandSourceStack)ctx.getSource()).m_288197_(comp, true);
            return 1;
        }))));
    }

    private static /* synthetic */ Component lambda$onRegisterCommands$2(String timeStr) {
        return Component.m_237113_((String)("\u0411\u043b\u0430\u0433\u043e\u0441\u043b\u0430\u0432\u0435\u043d\u0438\u0435 \u0435\u0449\u0451 \u043d\u0435 \u043f\u043e\u044f\u0432\u043b\u044f\u043b\u043e\u0441\u044c. \u0414\u043e \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0433\u043e: " + timeStr)).m_130940_(ChatFormatting.AQUA);
    }

    private static /* synthetic */ Component lambda$onRegisterCommands$1(BlockPos last, String timeStr) {
        return Component.m_237113_((String)("\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0435 \u0411\u043b\u0430\u0433\u043e\u0441\u043b\u0430\u0432\u0435\u043d\u0438\u0435: [" + last.m_123341_() + " " + last.m_123342_() + " " + last.m_123343_() + "]. \u0414\u043e \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0433\u043e: " + timeStr)).m_130940_(ChatFormatting.AQUA);
    }

    private static class BenisonManager {
        private final int INTERVAL_TICKS = 36000;
        private int tickCounter = 0;
        private boolean enabled = true;
        private BlockPos lastPos = null;
        private final Random random = new Random();
        private final int SEARCH_RADIUS = 1000;
        private final int MAX_ATTEMPTS = 40;
        private boolean persistLoaded = false;
        private BenisonSavedData saved = null;

        private BenisonManager() {
        }

        public void tick(MinecraftServer server) {
            if (!this.enabled) {
                return;
            }
            ++this.tickCounter;
            if (this.tickCounter >= 36000) {
                ServerLevel overworld = server.m_129880_(Level.f_46428_);
                if (overworld != null) {
                    this.ensurePersistLoaded(overworld);
                    boolean spawned = this.spawnNow(overworld);
                    this.tickCounter = 0;
                    if (!spawned) {
                        LOGGER.info("Benison: \u043f\u043e\u043f\u044b\u0442\u043a\u0430 \u0441\u043f\u0430\u0432\u043d\u0430 \u043d\u0435 \u0443\u0434\u0430\u043b\u0430\u0441\u044c.");
                    }
                } else {
                    this.tickCounter = 0;
                }
            }
        }

        public boolean spawnNow(ServerLevel level) {
            this.ensurePersistLoaded(level);
            Block benison = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("myped", "benison"));
            if (benison == null) {
                LOGGER.warn("Benison block (myped:benison) not found in registry.");
                return false;
            }
            if (!level.m_46472_().equals((Object)Level.f_46428_)) {
                return false;
            }
            BlockPos worldSpawn = level.m_220360_();
            for (int attempt = 0; attempt < 40; ++attempt) {
                int z;
                int y;
                int dx = this.random.nextInt(2001) - 1000;
                int dz = this.random.nextInt(2001) - 1000;
                int x = worldSpawn.m_123341_() + dx;
                BlockPos pos = new BlockPos(x, y = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z = worldSpawn.m_123343_() + dz), z);
                if (!level.m_46859_(pos) && !level.m_46859_(pos = pos.m_7494_()) || !level.m_45527_(pos)) continue;
                BlockState state = benison.m_49966_();
                level.m_7731_(pos, state, 3);
                this.lastPos = pos.m_7949_();
                if (this.saved != null) {
                    this.saved.setLastPos(this.lastPos);
                }
                String msg = "\u0411\u043b\u0430\u0433\u043e\u0441\u043b\u0430\u0432\u0435\u043d\u0438\u0435 \u0441\u043d\u0438\u0437\u043e\u0448\u043b\u043e \u0441 \u043d\u0435\u0431\u0435\u0441 \u043d\u0430 \u043a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442\u0430\u0445 [" + pos.m_123341_() + " " + pos.m_123342_() + " " + pos.m_123343_() + "]! \u0414\u043e \u043d\u043e\u0432\u043e\u0433\u043e \u0431\u043b\u0430\u0433\u043e\u0441\u043b\u0430\u0432\u0435\u043d\u0438\u044f \u043e\u0441\u0442\u0430\u043b\u043e\u0441\u044c 30 \u043c\u0438\u043d\u0443\u0442";
                this.broadcastPlainColoredMessage(level.m_7654_(), msg);
                LOGGER.info("Benison spawned at " + String.valueOf(pos));
                return true;
            }
            LOGGER.info("Benison: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0443\u044e \u043f\u043e\u0437\u0438\u0446\u0438\u044e \u0434\u043b\u044f \u0441\u043f\u0430\u0432\u043d\u0430 \u043f\u043e\u0441\u043b\u0435 40 \u043f\u043e\u043f\u044b\u0442\u043e\u043a.");
            return false;
        }

        private void broadcastPlainColoredMessage(MinecraftServer server, String text) {
            MutableComponent comp = Component.m_237113_((String)text).m_130940_(ChatFormatting.AQUA);
            server.m_6846_().m_240416_((Component)comp, false);
        }

        public BlockPos getLastPos() {
            return this.lastPos;
        }

        public int getRemainingTicks() {
            if (!this.enabled) {
                return -1;
            }
            return Math.max(0, 36000 - this.tickCounter);
        }

        public void setEnabled(boolean value, ServerLevel maybeLevel) {
            this.enabled = value;
            if (maybeLevel != null) {
                this.ensurePersistLoaded(maybeLevel);
                if (this.saved != null) {
                    this.saved.setEnabled(value);
                }
            }
        }

        public void resetCounter() {
            this.tickCounter = 0;
        }

        private void ensurePersistLoaded(ServerLevel level) {
            if (this.persistLoaded) {
                return;
            }
            try {
                this.saved = (BenisonSavedData)level.m_8895_().m_164861_(BenisonSavedData::load, BenisonSavedData::new, "myped_benison");
                if (this.saved != null) {
                    this.lastPos = this.saved.getLastPos();
                    this.enabled = this.saved.isEnabled();
                }
            }
            catch (Exception e) {
                LOGGER.warn("Benison: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0441\u043e\u0445\u0440\u0430\u043d\u0451\u043d\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435: " + e.getMessage());
            }
            this.persistLoaded = true;
        }
    }

    public static class BenisonSavedData
    extends SavedData {
        private boolean enabled = true;
        private BlockPos lastPos = null;

        public static BenisonSavedData load(CompoundTag nbt) {
            BenisonSavedData d = new BenisonSavedData();
            if (nbt != null) {
                d.enabled = nbt.m_128471_("Enabled");
                if (nbt.m_128441_("LastPos")) {
                    CompoundTag p = nbt.m_128469_("LastPos");
                    d.lastPos = new BlockPos(p.m_128451_("x"), p.m_128451_("y"), p.m_128451_("z"));
                }
            }
            return d;
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("Enabled", this.enabled);
            if (this.lastPos != null) {
                CompoundTag p = new CompoundTag();
                p.m_128405_("x", this.lastPos.m_123341_());
                p.m_128405_("y", this.lastPos.m_123342_());
                p.m_128405_("z", this.lastPos.m_123343_());
                nbt.m_128365_("LastPos", (Tag)p);
            }
            return nbt;
        }

        public BlockPos getLastPos() {
            return this.lastPos;
        }

        public void setLastPos(BlockPos p) {
            this.lastPos = p;
            this.m_77762_();
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean v) {
            this.enabled = v;
            this.m_77762_();
        }
    }
}

