/*
 * Decompiled with CFR 0.152.
 */
package net.deskped.myped;

import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class Dialog {
    public static final String MODID = "myped";
    private static final ResourceLocation PROTOCOL = new ResourceLocation("myped", "dialog_channel");
    private static SimpleChannel CHANNEL;
    private static final int PROTOCOL_VERSION = 1;

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)PROTOCOL, () -> Integer.toString(1), s -> true, s -> true);
        int id = 0;
        CHANNEL.registerMessage(id++, ClientToServerDialogMessage.class, ClientToServerDialogMessage::encode, ClientToServerDialogMessage::decode, ClientToServerDialogMessage::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(id++, ServerToClientDialogMessage.class, ServerToClientDialogMessage::encode, ServerToClientDialogMessage::decode, ServerToClientDialogMessage::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    public static class ClientToServerDialogMessage {
        public final String message;

        public ClientToServerDialogMessage(String message) {
            this.message = message;
        }

        public static void encode(ClientToServerDialogMessage pkt, FriendlyByteBuf buf) {
            byte[] bytes = pkt.message.getBytes(StandardCharsets.UTF_8);
            buf.writeInt(bytes.length);
            buf.writeBytes(bytes);
        }

        public static ClientToServerDialogMessage decode(FriendlyByteBuf buf) {
            int len = buf.readInt();
            byte[] bytes = new byte[len];
            buf.readBytes(bytes);
            return new ClientToServerDialogMessage(new String(bytes, StandardCharsets.UTF_8));
        }

        public static void handle(ClientToServerDialogMessage pkt, Supplier<NetworkEvent.Context> ctx) {
            NetworkEvent.Context context = ctx.get();
            context.enqueueWork(() -> {
                ServerPlayer sender = context.getSender();
                if (sender == null) {
                    return;
                }
                if (!sender.m_20310_(1)) {
                    return;
                }
                long startMillis = System.currentTimeMillis();
                ServerToClientDialogMessage out = new ServerToClientDialogMessage(pkt.message, sender.m_20148_(), sender.m_20182_().f_82479_, sender.m_20182_().f_82480_, sender.m_20182_().f_82481_, startMillis);
                double radius = 20.0;
                double r2 = radius * radius;
                MinecraftServer server = sender.m_20194_();
                if (server == null) {
                    return;
                }
                List players = server.m_6846_().m_11314_();
                if (players == null) {
                    return;
                }
                for (ServerPlayer target : players) {
                    if (!(target.m_20280_((Entity)sender) <= r2)) continue;
                    CHANNEL.send(PacketDistributor.PLAYER.with(() -> target), (Object)out);
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class ServerToClientDialogMessage {
        public final String message;
        public final UUID senderUuid;
        public final double x;
        public final double y;
        public final double z;
        public final long startMillis;

        public ServerToClientDialogMessage(String message, UUID senderUuid, double x, double y, double z, long startMillis) {
            this.message = message;
            this.senderUuid = senderUuid;
            this.x = x;
            this.y = y;
            this.z = z;
            this.startMillis = startMillis;
        }

        public static void encode(ServerToClientDialogMessage pkt, FriendlyByteBuf buf) {
            byte[] bytes = pkt.message.getBytes(StandardCharsets.UTF_8);
            buf.writeInt(bytes.length);
            buf.writeBytes(bytes);
            buf.writeLong(pkt.senderUuid.getMostSignificantBits());
            buf.writeLong(pkt.senderUuid.getLeastSignificantBits());
            buf.writeDouble(pkt.x);
            buf.writeDouble(pkt.y);
            buf.writeDouble(pkt.z);
            buf.writeLong(pkt.startMillis);
        }

        public static ServerToClientDialogMessage decode(FriendlyByteBuf buf) {
            int len = buf.readInt();
            byte[] bytes = new byte[len];
            buf.readBytes(bytes);
            String msg = new String(bytes, StandardCharsets.UTF_8);
            long msb = buf.readLong();
            long lsb = buf.readLong();
            UUID uuid = new UUID(msb, lsb);
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            long start = buf.readLong();
            return new ServerToClientDialogMessage(msg, uuid, x, y, z, start);
        }

        public static void handle(ServerToClientDialogMessage pkt, Supplier<NetworkEvent.Context> ctx) {
            NetworkEvent.Context context = ctx.get();
            context.enqueueWork(() -> ClientDialogManager.addRemoteMessage(pkt));
            context.setPacketHandled(true);
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ServerChatInterceptor {
        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onServerChat(ServerChatEvent event) {
            String msg;
            Component comp = event.getMessage();
            String string = msg = comp == null ? "" : comp.getString();
            if (!msg.startsWith("%!")) {
                return;
            }
            ServerPlayer p = event.getPlayer();
            if (!(p instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer sender = p;
            if (!sender.m_20310_(1)) {
                return;
            }
            String after = msg.substring(2).trim();
            event.setCanceled(true);
            if (after.isEmpty()) {
                return;
            }
            long start = System.currentTimeMillis();
            ServerToClientDialogMessage out = new ServerToClientDialogMessage(after, sender.m_20148_(), sender.m_20182_().f_82479_, sender.m_20182_().f_82480_, sender.m_20182_().f_82481_, start);
            double radius = 20.0;
            double r2 = radius * radius;
            MinecraftServer server = sender.m_20194_();
            if (server == null) {
                return;
            }
            List players = server.m_6846_().m_11314_();
            if (players == null) {
                return;
            }
            for (ServerPlayer target : players) {
                if (!(target.m_20280_((Entity)sender) <= r2) || CHANNEL == null) continue;
                CHANNEL.send(PacketDistributor.PLAYER.with(() -> target), (Object)out);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ClientDialogManager {
        private static final long DISPLAY_DURATION_MS = 15000L;
        private static final long FADE_MS = 1000L;
        private static final int MAX_HISTORY = 12;
        private static final Map<String, ActiveMessage> active = new ConcurrentHashMap<String, ActiveMessage>();

        public static void noop() {
        }

        public static void addRemoteMessage(ServerToClientDialogMessage pkt) {
            if (pkt.message == null) {
                return;
            }
            String trimmed = pkt.message.trim();
            if (trimmed.isEmpty()) {
                return;
            }
            MutableComponent comp = Component.m_237113_((String)trimmed);
            String key = pkt.senderUuid.toString() + "_" + pkt.startMillis;
            long localStart = System.currentTimeMillis();
            ActiveMessage m = new ActiveMessage(pkt.senderUuid, (Component)comp, localStart, 15000L);
            active.put(key, m);
            if (active.size() > 12) {
                String oldestKey = null;
                long oldest = Long.MAX_VALUE;
                for (Map.Entry<String, ActiveMessage> e : active.entrySet()) {
                    if (e.getValue().startMillis >= oldest) continue;
                    oldest = e.getValue().startMillis;
                    oldestKey = e.getKey();
                }
                if (oldestKey != null) {
                    active.remove(oldestKey);
                }
            }
        }

        public static void onClientChat(ClientChatEvent event) {
            String m = event.getMessage();
            if (m == null) {
                return;
            }
            if (m.startsWith("%!")) {
                String after = m.substring(2).trim();
                event.setCanceled(true);
                if (after.isEmpty()) {
                    return;
                }
                if (CHANNEL != null) {
                    CHANNEL.sendToServer((Object)new ClientToServerDialogMessage(after));
                }
            }
        }

        public static void onClientTick(TickEvent.ClientTickEvent event) {
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            long now = System.currentTimeMillis();
            ArrayList<String> toRemove = new ArrayList<String>();
            for (Map.Entry<String, ActiveMessage> e : active.entrySet()) {
                ActiveMessage m = e.getValue();
                if (now - m.startMillis <= m.duration + 1000L) continue;
                toRemove.add(e.getKey());
            }
            for (String k : toRemove) {
                active.remove(k);
            }
        }

        public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
            if (event.getEntity() instanceof LocalPlayer) {
                active.clear();
            }
        }

        public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
            if (event.getEntity() instanceof LocalPlayer) {
                active.clear();
            }
        }

        public static void onRenderGui(RenderGuiOverlayEvent.Post event) {
            GuiGraphics gui = event.getGuiGraphics();
            Minecraft mc = Minecraft.m_91087_();
            if (mc == null) {
                return;
            }
            Font font = mc.f_91062_;
            int screenW = mc.m_91268_().m_85445_();
            int screenH = mc.m_91268_().m_85446_();
            int hotbarOffset = 50;
            int baseY = screenH - hotbarOffset - 20;
            ArrayList<ActiveMessage> list = new ArrayList<ActiveMessage>(active.values());
            list.sort(Comparator.comparingLong(a -> a.startMillis));
            if (list.isEmpty()) {
                return;
            }
            int maxLines = 3;
            int linesToRender = Math.min(maxLines, list.size());
            int lineGap = 6;
            Objects.requireNonNull(font);
            int lineHeight = 9 + 6;
            int startY = baseY - lineHeight * (linesToRender - 1);
            long now = System.currentTimeMillis();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            int rendered = 0;
            for (int i = Math.max(0, list.size() - linesToRender); i < list.size(); ++i) {
                ActiveMessage m = (ActiveMessage)list.get(i);
                long age = now - m.startMillis;
                if (age < 0L) {
                    age = 0L;
                }
                if (age > m.duration + 1000L) continue;
                float alphaFactor = age < 1000L ? (float)age / 1000.0f : (age > m.duration ? 1.0f - Math.min(1.0f, (float)(age - m.duration) / 1000.0f) : 1.0f);
                if ((alphaFactor = Math.max(0.0f, Math.min(1.0f, alphaFactor))) <= 0.0f) continue;
                Component comp = m.textComponent;
                String text = comp.getString();
                int textWidth = font.m_92895_(text);
                int paddingX = 10;
                int paddingY = 6;
                int boxWidth = textWidth + paddingX * 2;
                Objects.requireNonNull(font);
                int boxHeight = 9 + paddingY * 2;
                int centerX = screenW / 2;
                int boxX0 = centerX - boxWidth / 2;
                int boxX1 = centerX + boxWidth / 2;
                int boxY = startY + rendered * (boxHeight + lineGap);
                float baseBgAlpha = 0.3f;
                int bgAlphaByte = Math.round(255.0f * baseBgAlpha * alphaFactor);
                int bgColor = (bgAlphaByte & 0xFF) << 24 | 0;
                float shadowBase = 0.18f;
                int shadowAlphaByte = Math.round(255.0f * shadowBase * alphaFactor);
                int shadowColor = (shadowAlphaByte & 0xFF) << 24 | 0;
                gui.m_280509_(boxX0 + 1, boxY + 1, boxX1 + 1, boxY + boxHeight + 1, shadowColor);
                gui.m_280509_(boxX0, boxY, boxX1, boxY + boxHeight, bgColor);
                int outlineAlpha = Math.round((float)bgAlphaByte * 0.6f);
                int outlineColor = (outlineAlpha & 0xFF) << 24 | 0xFFFFFF;
                gui.m_280509_(boxX0, boxY, boxX1, boxY + 1, outlineColor);
                gui.m_280509_(boxX0, boxY + boxHeight - 1, boxX1, boxY + boxHeight, outlineColor);
                gui.m_280509_(boxX0, boxY, boxX0 + 1, boxY + boxHeight, outlineColor);
                gui.m_280509_(boxX1 - 1, boxY, boxX1, boxY + boxHeight, outlineColor);
                int textAlpha = Math.round(255.0f * alphaFactor);
                int textColor = (textAlpha & 0xFF) << 24 | 0xFFFFFF;
                int textX = centerX - textWidth / 2;
                int textY = boxY + paddingY;
                gui.m_280614_(font, comp, textX, textY, textColor, false);
                ++rendered;
            }
            RenderSystem.disableBlend();
        }

        private static class ActiveMessage {
            public final UUID sender;
            public final Component textComponent;
            public final long startMillis;
            public final long duration;

            public ActiveMessage(UUID sender, Component textComponent, long startMillis, long duration) {
                this.sender = sender;
                this.textComponent = textComponent;
                this.startMillis = startMillis;
                this.duration = duration;
            }
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ClientEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent evt) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> ClientDialogManager::noop);
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent(priority=EventPriority.NORMAL)
        public static void onClientChat(ClientChatEvent event) {
            ClientDialogManager.onClientChat(event);
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public static void onRenderGui(RenderGuiOverlayEvent.Post event) {
            ClientDialogManager.onRenderGui(event);
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            ClientDialogManager.onClientTick(event);
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
            ClientDialogManager.onPlayerLogout(event);
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
            ClientDialogManager.onPlayerRespawn(event);
        }
    }
}

