/*
 * Decompiled with CFR 0.152.
 */
package net.deskped.myped;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.OptionsScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class Menu {
    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        new Menu();
    }

    @OnlyIn(value=Dist.CLIENT)
    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ClientScreenEvents {
        @SubscribeEvent
        public static void onScreenInit(ScreenEvent.Init.Post event) {
            Screen screen = event.getScreen();
            if (!(screen instanceof TitleScreen)) {
                return;
            }
            Minecraft mc = Minecraft.m_91087_();
            ArrayList snapshot = new ArrayList(event.getListenersList());
            for (Object o : snapshot) {
                if (!(o instanceof Button)) continue;
                Button btn = (Button)o;
                event.removeListener((GuiEventListener)btn);
            }
            int buttonWidth = 100;
            int buttonHeight = 20;
            int spacing = 24;
            int marginRight = 10;
            int x = screen.f_96543_ - marginRight - buttonWidth;
            if (x < 10) {
                x = 10;
            }
            int totalButtons = 5;
            int totalHeight = totalButtons * buttonHeight + (totalButtons - 1) * (spacing - buttonHeight);
            int startY = screen.f_96544_ / 1 - totalHeight / 1;
            Button singleplayer = Button.m_253074_((Component)Component.m_237115_((String)"menu.singleplayer"), b -> mc.m_91152_((Screen)new SelectWorldScreen(screen))).m_252987_(x, startY, buttonWidth, buttonHeight).m_253136_();
            event.addListener((GuiEventListener)singleplayer);
            Button multiplayer = Button.m_253074_((Component)Component.m_237115_((String)"menu.multiplayer"), b -> mc.m_91152_((Screen)new JoinMultiplayerScreen(screen))).m_252987_(x, startY += spacing, buttonWidth, buttonHeight).m_253136_();
            event.addListener((GuiEventListener)multiplayer);
            Button options = Button.m_253074_((Component)Component.m_237115_((String)"menu.options"), b -> mc.m_91152_((Screen)new OptionsScreen(screen, mc.f_91066_))).m_252987_(x, startY += spacing, buttonWidth, buttonHeight).m_253136_();
            event.addListener((GuiEventListener)options);
            startY += spacing;
            try {
                Class<?> modListClass = null;
                try {
                    modListClass = Class.forName("net.minecraftforge.client.gui.screen.ModListScreen");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                Class<?> finalModListClass = modListClass;
                if (finalModListClass != null) {
                    Button mods = Button.m_253074_((Component)Component.m_237113_((String)"Mods"), b -> {
                        try {
                            Screen modsScreen = (Screen)finalModListClass.getConstructor(Screen.class).newInstance(screen);
                            mc.m_91152_(modsScreen);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }).m_252987_(x, startY, buttonWidth, buttonHeight).m_253136_();
                    event.addListener((GuiEventListener)mods);
                    startY += spacing;
                }
            }
            catch (Throwable modListClass) {
                // empty catch block
            }
            Button quit = Button.m_253074_((Component)Component.m_237115_((String)"menu.quit"), b -> mc.m_91395_()).m_252987_(x, startY, buttonWidth, buttonHeight).m_253136_();
            event.addListener((GuiEventListener)quit);
        }
    }

    @Mod.EventBusSubscriber
    private static class MenuForgeBusEvents {
        private MenuForgeBusEvents() {
        }

        @SubscribeEvent
        public static void serverLoad(ServerStartingEvent event) {
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public static void clientLoad(FMLClientSetupEvent event) {
        }
    }
}

