/*
 * Decompiled with CFR 0.152.
 */
package net.deskped.myped;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.deskped.myped.init.MypedModGameRules;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="myped")
public class Seasons {
    private static final long TICKS_PER_SEASON = 72000L;
    private static Season currentSeason = Season.LIFE;
    private static long tickCounter = 0L;
    private static final Random RANDOM = new Random();
    private static final String PROTOCOL_VERSION = "1";
    private static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("myped", "channel"), () -> "1", "1"::equals, "1"::equals);
    private static final UUID BLOODY_HEALTH_MOD_UUID;
    private static final UUID BLOODY_ATTACK_MOD_UUID;
    private static final UUID MAGIC_VORTEX_HP_UUID;
    private static final UUID SILENT_NIGHT_ATTACK_UUID;
    private static final UUID SILENT_NIGHT_HP_UUID;
    private static final Set<Season> BAD_SEASONS;
    private static final Map<Season, SeasonConfig> CONFIGS;
    private static SeasonSavedData savedData;

    public Seasons() {
        MinecraftForge.EVENT_BUS.register((Object)new SeasonsForgeBusEvents());
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        new Seasons();
    }

    private static void removeModifierIfPresent(AttributeInstance inst, UUID id) {
        try {
            AttributeModifier mod = inst.m_22111_(id);
            if (mod != null) {
                inst.m_22130_(mod);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static boolean isSeasonsEnabled(MinecraftServer server) {
        if (server == null) {
            return true;
        }
        try {
            GameRules.BooleanValue val = (GameRules.BooleanValue)server.m_129900_().m_46170_(MypedModGameRules.MYPEDSEASONS);
            if (val != null) {
                return val.m_46223_();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    static {
        CHANNEL.registerMessage(0, SeasonSyncPacket.class, SeasonSyncPacket::encode, SeasonSyncPacket::decode, SeasonSyncPacket::handle);
        BLOODY_HEALTH_MOD_UUID = UUID.fromString("5e7f7f10-0000-4f2b-9c3a-000000000001");
        BLOODY_ATTACK_MOD_UUID = UUID.fromString("5e7f7f10-0000-4f2b-9c3a-000000000002");
        MAGIC_VORTEX_HP_UUID = UUID.fromString("5e7f7f10-0000-4f2b-9c3a-000000000101");
        SILENT_NIGHT_ATTACK_UUID = UUID.fromString("5e7f7f10-0000-4f2b-9c3a-000000002201");
        SILENT_NIGHT_HP_UUID = UUID.fromString("5e7f7f10-0000-4f2b-9c3a-000000002202");
        BAD_SEASONS = EnumSet.of(Season.BLOODY_SUN, new Season[]{Season.END_OF_WORLD, Season.THUNDER_THREAT, Season.WORLD_ECLIPSE, Season.DRAGON_BREATH, Season.MAGIC_VORTEX});
        CONFIGS = new EnumMap<Season, SeasonConfig>(Season.class);
        savedData = null;
        CONFIGS.put(Season.PEACEFUL_SKY, new SeasonConfig.Builder().setStartCommands(List.of("difficulty peaceful", "gamerule doMobSpawning false")).setPlayerPeriodicEffect(() -> new MobEffectInstance(MobEffects.f_19605_, 100, 0, false, false)).setMobSpawnModifier(m -> false).setDropBonus(Items.f_42404_, 0.15f).build());
        CONFIGS.put(Season.BLOODY_SUN, new SeasonConfig.Builder().setStartCommands(List.of("time set day", "gamerule doDaylightCycle false")).setDifficulty("hard").setPlayerPeriodicEffect(() -> new MobEffectInstance(MobEffects.f_19600_, 100, 0, false, false)).setMobAttributeMultiplier(MAGIC_VORTEX_HP_UUID, 0.1).setDropBonus(Items.f_42437_, 0.05f).setRareWorldCommand("playsound minecraft:entity.wither.spawn @a", 12000).build());
        CONFIGS.put(Season.QUIET_KNIGHT, new SeasonConfig.Builder().setPlayerPeriodicEffect(() -> new MobEffectInstance(MobEffects.f_19606_, 100, 0, false, false)).setMobSpawnModifier(m -> {
            AttributeInstance hp = m.m_21051_(Attributes.f_22276_);
            if (hp != null) {
                hp.m_22100_(Math.max(1.0, hp.m_22115_() * 1.25));
            }
            return true;
        }).setDropBonus(Items.f_42416_, 0.12f).setStartCommands(List.of("gamerule doMobSpawning true")).build());
        CONFIGS.put(Season.LIFE, new SeasonConfig.Builder().setPlayerPeriodicEffect(() -> new MobEffectInstance(MobEffects.f_19605_, 100, 0, false, false)).setDropBonus(Items.f_42410_, 0.08f).setStartCommands(List.of("gamerule doDaylightCycle true")).setMobSpawnModifier(m -> true).build());
        CONFIGS.put(Season.END_OF_WORLD, new SeasonConfig.Builder().setStartCommands(List.of("time set midnight", "gamerule doDaylightCycle false")).setDifficulty("hard").setMobAttributeMultiplier(UUID.randomUUID(), 0.1111111111111111).setDropBonus(Items.f_42413_, 0.6f).setPlayerPeriodicEffect(() -> new MobEffectInstance(MobEffects.f_19613_, 100, 0, false, false)).build());
        CONFIGS.put(Season.CRYSTAL_DAWN, new SeasonConfig.Builder().setStartCommands(List.of("gamerule doDaylightCycle true")).setPlayerPeriodicEffect(() -> new MobEffectInstance(MobEffects.f_19617_, 100, 0, false, false)).setDropBonus(Items.f_42612_, 0.6f).setMobSpawnModifier(m -> {
            m.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 72000, 0, false, false));
            return true;
        }).setRareWorldCommand("playsound minecraft:block.amethyst.block.place @a", 18000).build());
        CONFIGS.put(Season.THUNDER_THREAT, new SeasonConfig.Builder().setStartCommands(List.of("weather thunder 600")).setDifficulty("hard").setPlayerPeriodicEffect(() -> new MobEffectInstance(MobEffects.f_19606_, 100, 0, false, false)).setDropBonus(Items.f_42109_, 0.08f).setMobAttributeMultiplier(UUID.randomUUID(), 1.5).build());
        CONFIGS.put(Season.GOLDEN_AUTUMN, new SeasonConfig.Builder().setPlayerPeriodicEffect(() -> new MobEffectInstance(MobEffects.f_19621_, 100, 0, false, false)).setDropBonus(Items.f_42437_, 0.12f).setMobSpawnModifier(m -> {
            if (RANDOM.nextFloat() < 0.12f) {
                m.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42476_));
            }
            return true;
        }).setRareWorldCommand("particle minecraft:happy_villager ~ ~1 ~ 1 1 1 0.1 100", 24000).setStartCommands(List.of("gamerule randomTickSpeed 3")).build());
        CONFIGS.put(Season.LAVA_BREATH, new SeasonConfig.Builder().setPlayerPeriodicEffect(() -> new MobEffectInstance(MobEffects.f_19607_, 100, 0, false, false)).setDropBonus(Items.f_42585_, 0.25f).setRareWorldCommand("playsound minecraft:block.lava.ambient @a", 12000).setMobAttributeMultiplier(UUID.randomUUID(), 1.2).setStartCommands(List.of("gamerule doFireTick true")).build());
        CONFIGS.put(Season.BLUE_SEA_WHITE_FOAM, new SeasonConfig.Builder().setPlayerPeriodicEffect(() -> new MobEffectInstance(MobEffects.f_19608_, 100, 0, false, false)).setDropBonus(Items.f_42715_, 0.25f).setMobSpawnModifier(m -> true).setPlayerNearMobEffect(() -> new MobEffectInstance(MobEffects.f_19610_, 100, 0, false, false), 100, 16.0).build());
        CONFIGS.put(Season.SOLAR_DAWN, new SeasonConfig.Builder().setStartCommands(List.of("time set day", "gamerule doDaylightCycle true")).setPlayerPeriodicEffect(() -> new MobEffectInstance(MobEffects.f_19605_, 100, 0, false, false)).setDropBonus(Items.f_42580_, 0.3f).setMobAttributeMultiplier(UUID.randomUUID(), 0.2).setRareWorldCommand("particle minecraft:sunflower ~ ~1 ~ 1 1 1 0.1 50", 18000).build());
        CONFIGS.put(Season.SNOW_STORM, new SeasonConfig.Builder().setStartCommands(List.of("weather rain 600")).setDropBonus(Items.f_41981_, 0.4f).setRareWorldCommand("particle minecraft:snowball ~ ~1 ~ 1 1 1 0.1 200", 12000).setMobAttributeMultiplier(UUID.randomUUID(), 0.9).build());
        CONFIGS.put(Season.WORLD_ECLIPSE, new SeasonConfig.Builder().setStartCommands(List.of("time set midnight", "gamerule doDaylightCycle false")).setDifficulty("hard").setDropReplacement(Items.f_41999_, 0.05f).setMobAttributeMultiplier(UUID.randomUUID(), 0.5).build());
        CONFIGS.put(Season.HMMM, new SeasonConfig.Builder().setPlayerPeriodicEffect(() -> new MobEffectInstance(MobEffects.f_19621_, 100, 0, false, false)).setDropBonus(Items.f_42616_, 0.6f).setRareWorldCommand("playsound minecraft:block.note_block.pling @a", 8000).setMobSpawnModifier(m -> true).setStartCommands(List.of("gamerule doDaylightCycle true")).build());
        CONFIGS.put(Season.DRAGON_BREATH, new SeasonConfig.Builder().setPlayerPeriodicEffect(() -> new MobEffectInstance(MobEffects.f_19607_, 100, 0, false, false)).setDifficulty("hard").setDropBonus(Items.f_42102_, 0.35f).setMobAttributeMultiplier(UUID.randomUUID(), 1.3).setStartCommands(List.of("gamerule doMobSpawning true")).build());
        CONFIGS.put(Season.LUNAR_PEACE, new SeasonConfig.Builder().setPlayerPeriodicEffect(() -> new MobEffectInstance(MobEffects.f_19606_, 100, 0, false, false)).setDropBonus(Items.f_42690_, 0.25f).setRareWorldCommand("playsound minecraft:entity.fox.ambient @a", 20000).setMobAttributeMultiplier(UUID.randomUUID(), 0.8).setStartCommands(List.of("gamerule doDaylightCycle true")).build());
        CONFIGS.put(Season.MAGIC_VORTEX, new SeasonConfig.Builder().setDifficulty("hard").setMobAttributeMultiplier(MAGIC_VORTEX_HP_UUID, 0.1).setPlayerPeriodicEffect(() -> new MobEffectInstance(MobEffects.f_19613_, 100, 0, false, false)).setDropBonus(Items.f_42690_, 0.5f).setRareWorldCommand("particle minecraft:enchant ~ ~1 ~ 1 1 1 0.2 80", 12000).build());
        CONFIGS.put(Season.FOREST_SHADOWS, new SeasonConfig.Builder().setPlayerPeriodicEffect(() -> new MobEffectInstance(MobEffects.f_19596_, 100, 0, false, false)).setPlayerPeriodicEffect2(() -> new MobEffectInstance(MobEffects.f_19603_, 100, 0, false, false)).setMobAttributeMultiplier(UUID.randomUUID(), 0.3333333333333333).setDropBonus(Items.f_41940_, 0.15f).setRareWorldCommand("particle minecraft:campfire_cosy_smoke ~ ~1 ~ 1 1 1 0.05 40", 24000).build());
        CONFIGS.put(Season.SILENT_NIGHT, new SeasonConfig.Builder().setMobAttributeMultiplier(SILENT_NIGHT_ATTACK_UUID, 2.0).setMobAttributeMultiplier(SILENT_NIGHT_HP_UUID, 0.3333333333333333).setDropBonus(Items.f_42752_, 0.2f).setPlayerPeriodicEffect(() -> new MobEffectInstance(MobEffects.f_19611_, 100, 0, false, false)).setRareWorldCommand("playsound minecraft:block.note_block.basedrum @a", 24000).build());
        CONFIGS.put(Season.ETERNAL_HARVEST, new SeasonConfig.Builder().setPlayerPeriodicEffect(() -> new MobEffectInstance(MobEffects.f_19605_, 100, 0, false, false)).setDropBonus(Items.f_42486_, 0.5f).setStartCommands(List.of("gamerule randomTickSpeed 5")).setMobSpawnModifier(m -> true).build());
    }

    @Mod.EventBusSubscriber
    private static class SeasonsForgeBusEvents {
        private final Map<Season, Boolean> oneTimeCommandsExecuted = new ConcurrentHashMap<Season, Boolean>();
        private static final Map<ServerLevel, SpawnTracker> SPAWN_TRACKERS = new ConcurrentHashMap<ServerLevel, SpawnTracker>();
        private static final int MAX_EXTRA_SPAWNS_PER_20_TICKS = 8;
        private static boolean seasonsEnabledCached = true;

        private SeasonsForgeBusEvents() {
        }

        @SubscribeEvent
        public static void serverLoad(ServerStartingEvent event) {
            boolean enabled;
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server == null) {
                return;
            }
            ServerLevel overworld = server.m_129880_(Level.f_46428_);
            if (overworld != null) {
                try {
                    SeasonSavedData sd;
                    savedData = sd = (SeasonSavedData)overworld.m_8895_().m_164861_(SeasonSavedData::load, SeasonSavedData::new, "myped_seasons");
                    int ord = savedData.getSeasonOrdinal();
                    long tc = savedData.getTickCounter();
                    if (ord >= 0 && ord < Season.values().length) {
                        currentSeason = Season.values()[ord];
                    }
                    tickCounter = Math.max(0L, tc);
                }
                catch (Throwable sd) {
                    // empty catch block
                }
            }
            seasonsEnabledCached = enabled = Seasons.isSeasonsEnabled(server);
            SeasonsForgeBusEvents.sendSeasonSyncToAll(server, currentSeason, enabled);
            if (!enabled) {
                SeasonsForgeBusEvents.revertSeasonEffects(server);
            } else {
                SeasonsForgeBusEvents.applySeasonEffects(currentSeason, currentSeason);
            }
        }

        @SubscribeEvent
        public static void onRegisterCommands(RegisterCommandsEvent event) {
            CommandDispatcher dispatcher = event.getDispatcher();
            dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"myped").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"season").requires(src -> src.m_6761_(2))).then(Commands.m_82127_((String)"next").executes(ctx -> {
                SeasonsForgeBusEvents.nextSeason(true);
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Season switched to " + currentSeason.name())), false);
                return 1;
            }))).then(Commands.m_82127_((String)"status").executes(ctx -> {
                long remainingTicks = Math.max(0L, 72000L - tickCounter);
                long seconds = remainingTicks / 20L;
                String msg = "Season: " + currentSeason.name() + " | Time to change: " + seconds + "s";
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)msg), false);
                return 1;
            }))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"season", (ArgumentType)StringArgumentType.word()).suggests((ctx, sb) -> {
                for (Season s : Season.values()) {
                    sb.suggest(s.name());
                }
                return sb.buildFuture();
            }).executes(ctx -> {
                Season found;
                String s = StringArgumentType.getString((CommandContext)ctx, (String)"season");
                try {
                    found = Season.valueOf(s.toUpperCase(Locale.ROOT));
                }
                catch (Exception ex) {
                    ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("Season not found: " + s)));
                    return 0;
                }
                SeasonsForgeBusEvents.setSeason(found, true);
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Season set: " + found.name())), false);
                return 1;
            })))));
        }

        @SubscribeEvent
        public void onServerTick(TickEvent.ServerTickEvent event) {
            SeasonConfig cfg;
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server == null) {
                return;
            }
            boolean enabled = Seasons.isSeasonsEnabled(server);
            if (enabled != seasonsEnabledCached) {
                seasonsEnabledCached = enabled;
                SeasonsForgeBusEvents.sendSeasonSyncToAll(server, currentSeason, enabled);
                if (!enabled) {
                    SeasonsForgeBusEvents.revertSeasonEffects(server);
                } else {
                    SeasonsForgeBusEvents.applySeasonEffects(currentSeason, currentSeason);
                }
            }
            if (!enabled) {
                return;
            }
            if (++tickCounter >= 72000L) {
                SeasonsForgeBusEvents.nextSeason(false);
                tickCounter = 0L;
            }
            if (tickCounter % 20L == 0L) {
                SPAWN_TRACKERS.clear();
            }
            if (savedData != null && tickCounter % 600L == 0L) {
                try {
                    savedData.setSeasonOrdinal(currentSeason.ordinal());
                    savedData.setTickCounter(tickCounter);
                    savedData.m_77762_();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if ((cfg = CONFIGS.get((Object)currentSeason)) == null) {
                return;
            }
            if (tickCounter == 1L) {
                SeasonsForgeBusEvents.executeOneTimeCommands(server, cfg);
            }
            if (cfg.hasPlayerEffects()) {
                for (ServerPlayer p : server.m_6846_().m_11314_()) {
                    if (p.m_9236_().m_5776_() || !SeasonsForgeBusEvents.isPlayerAffected(p)) continue;
                    cfg.maybeApplyPlayerEffects(p, tickCounter);
                }
            }
            if (currentSeason == Season.SNOW_STORM && tickCounter % 100L == 0L) {
                for (ServerPlayer p : server.m_6846_().m_11314_()) {
                    if (!SeasonsForgeBusEvents.isPlayerAffected(p)) continue;
                    try {
                        String name = p.m_7755_().getString();
                        server.m_129892_().m_82094_().execute("effect give " + name + " myped:chilly 5 0 true", (Object)server.m_129893_().m_81324_());
                    }
                    catch (Exception name) {}
                }
            }
            if (currentSeason == Season.THUNDER_THREAT && tickCounter % 20L == 0L) {
                for (ServerPlayer p : server.m_6846_().m_11314_()) {
                    if (!SeasonsForgeBusEvents.isPlayerAffected(p)) continue;
                    float chance = 0.2f + RANDOM.nextFloat() * 0.25f;
                    if (!(RANDOM.nextFloat() < chance)) continue;
                    try {
                        if (!SeasonsForgeBusEvents.isSkyOpenAbove(p)) continue;
                        server.m_129892_().m_82094_().execute("execute at " + p.m_7755_().getString() + " run summon minecraft:lightning_bolt ~ ~ ~", (Object)server.m_129893_().m_81324_());
                    }
                    catch (Exception exception) {}
                }
            }
            if (currentSeason == Season.WORLD_ECLIPSE && tickCounter % 100L == 0L) {
                for (ServerPlayer p : server.m_6846_().m_11314_()) {
                    if (!SeasonsForgeBusEvents.isPlayerAffected(p)) continue;
                    if (RANDOM.nextFloat() < 0.5f) {
                        int seconds = 2 + RANDOM.nextInt(7);
                        try {
                            server.m_129892_().m_82094_().execute("effect give " + p.m_7755_().getString() + " minecraft:darkness " + seconds + " 0 true", (Object)server.m_129893_().m_81324_());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!(RANDOM.nextFloat() < 0.2f)) continue;
                    try {
                        server.m_129892_().m_82094_().execute("effect give " + p.m_7755_().getString() + " myped:earthquake 3 0 true", (Object)server.m_129893_().m_81324_());
                    }
                    catch (Exception exception) {}
                }
            }
            if (cfg.getRareCommand() != null && tickCounter % (long)Math.max(1, cfg.getRareCommandInterval()) == 0L) {
                try {
                    server.m_129892_().m_82094_().execute(cfg.getRareCommand(), (Object)server.m_129893_().m_81324_());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @SubscribeEvent(priority=EventPriority.NORMAL)
        public static void onEntityJoin(EntityJoinLevelEvent event) {
            Entity e = event.getEntity();
            if (!(e instanceof LivingEntity)) {
                return;
            }
            LivingEntity le = (LivingEntity)e;
            if (le.m_9236_().m_5776_()) {
                return;
            }
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server == null) {
                return;
            }
            if (!Seasons.isSeasonsEnabled(server)) {
                return;
            }
            SeasonConfig cfg = CONFIGS.get((Object)currentSeason);
            if (cfg == null) {
                return;
            }
            if (le instanceof Monster) {
                cfg.applyMobSpawnModifiers((Monster)le);
                if (currentSeason == Season.BLOODY_SUN) {
                    SeasonsForgeBusEvents.removeBloodyModifiers(le);
                    SeasonsForgeBusEvents.applyBloodyModifiers(le);
                } else {
                    SeasonsForgeBusEvents.removeBloodyModifiers(le);
                }
                if (BAD_SEASONS.contains((Object)currentSeason)) {
                    if (le.m_19880_().contains("myped_spawned")) {
                        return;
                    }
                    ServerLevel lvl = (ServerLevel)le.m_9236_();
                    SpawnTracker tracker = SPAWN_TRACKERS.computeIfAbsent(lvl, k -> new SpawnTracker());
                    if (tracker.getCount() >= 8) {
                        return;
                    }
                    int extrasToSpawn = Math.min(2, 8 - tracker.getCount());
                    for (int i = 0; i < extrasToSpawn; ++i) {
                        try {
                            EntityType et = le.m_6095_();
                            Entity newE = et.m_20615_((Level)lvl);
                            if (newE == null || !(newE instanceof LivingEntity)) continue;
                            double dx = (RANDOM.nextDouble() - 0.5) * 4.0;
                            double dz = (RANDOM.nextDouble() - 0.5) * 4.0;
                            newE.m_7678_(le.m_20185_() + dx, le.m_20186_(), le.m_20189_() + dz, le.m_146908_(), le.m_146909_());
                            newE.m_20049_("myped_spawned");
                            if (newE instanceof Mob) {
                                ((Mob)newE).m_21153_(((Mob)newE).m_21233_());
                            }
                            lvl.m_7967_(newE);
                            tracker.increment();
                            continue;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            }
            if (le instanceof Player) {
                ServerPlayer p = (ServerPlayer)le;
                if (!SeasonsForgeBusEvents.isPlayerAffected(p)) {
                    SeasonsForgeBusEvents.removeBloodyModifiers(le);
                    return;
                }
                if (currentSeason == Season.BLOODY_SUN) {
                    SeasonsForgeBusEvents.removeBloodyModifiers(le);
                    SeasonsForgeBusEvents.applyBloodyModifiers(le);
                } else {
                    SeasonsForgeBusEvents.removeBloodyModifiers(le);
                }
            }
        }

        @SubscribeEvent(priority=EventPriority.NORMAL)
        public static void onLivingDrops(LivingDropsEvent event) {
            if (event.getEntity().m_9236_().m_5776_()) {
                return;
            }
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server == null) {
                return;
            }
            if (!Seasons.isSeasonsEnabled(server)) {
                return;
            }
            SeasonConfig cfg = CONFIGS.get((Object)currentSeason);
            if (cfg == null) {
                return;
            }
            cfg.maybeModifyDrops(event);
        }

        private static void executeOneTimeCommands(MinecraftServer server, SeasonConfig cfg) {
            if (cfg.getStartCommands() == null) {
                return;
            }
            for (String cmd : cfg.getStartCommands()) {
                try {
                    server.m_129892_().m_82094_().execute(cmd, (Object)server.m_129893_().m_81324_());
                }
                catch (Exception exception) {}
            }
        }

        private static void nextSeason(boolean manual) {
            if (manual) {
                int next = (currentSeason.ordinal() + 1) % Season.values().length;
                SeasonsForgeBusEvents.setSeason(Season.values()[next], manual);
                return;
            }
            Season pick = currentSeason;
            Season[] vals = Season.values();
            while (pick == currentSeason) {
                pick = vals[RANDOM.nextInt(vals.length)];
            }
            SeasonsForgeBusEvents.setSeason(pick, false);
        }

        private static void setSeason(Season s, boolean manual) {
            Season previous = currentSeason;
            currentSeason = s;
            tickCounter = 0L;
            if (Seasons.isSeasonsEnabled(ServerLifecycleHooks.getCurrentServer())) {
                SeasonsForgeBusEvents.applySeasonEffects(s, previous);
            }
            if (savedData != null) {
                savedData.setSeasonOrdinal(currentSeason.ordinal());
                savedData.setTickCounter(tickCounter);
                savedData.m_77762_();
            }
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            boolean enabled = Seasons.isSeasonsEnabled(server);
            SeasonsForgeBusEvents.sendSeasonSyncToAll(server, s, enabled);
        }

        private static void applySeasonEffects(Season s, Season previous) {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server == null) {
                return;
            }
            SeasonConfig cfg = CONFIGS.get((Object)s);
            try {
                try {
                    server.m_129892_().m_82094_().execute("difficulty normal", (Object)server.m_129893_().m_81324_());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (cfg != null && cfg.getDifficulty() != null) {
                    try {
                        server.m_129892_().m_82094_().execute("difficulty " + cfg.getDifficulty(), (Object)server.m_129893_().m_81324_());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (cfg != null && cfg.getStartCommands() != null) {
                    for (String cmd : cfg.getStartCommands()) {
                        try {
                            server.m_129892_().m_82094_().execute(cmd, (Object)server.m_129893_().m_81324_());
                        }
                        catch (Exception exception) {}
                    }
                }
                if (s == Season.END_OF_WORLD) {
                    try {
                        server.m_129892_().m_82094_().execute("time set midnight", (Object)server.m_129893_().m_81324_());
                        server.m_129892_().m_82094_().execute("gamerule doDaylightCycle false", (Object)server.m_129893_().m_81324_());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                for (ServerLevel level : server.m_129785_()) {
                    for (Entity e : level.m_8583_()) {
                        if (!(e instanceof LivingEntity)) continue;
                        LivingEntity le = (LivingEntity)e;
                        if (s == Season.BLOODY_SUN) {
                            SeasonsForgeBusEvents.removeBloodyModifiers(le);
                            SeasonsForgeBusEvents.applyBloodyModifiers(le);
                            continue;
                        }
                        SeasonsForgeBusEvents.removeBloodyModifiers(le);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private static void sendSeasonSyncToAll(MinecraftServer server, Season s, boolean enabled) {
            CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new SeasonSyncPacket(s.ordinal(), enabled));
        }

        private static void applyBloodyModifiers(LivingEntity le) {
            AttributeInstance attack;
            AttributeInstance hp = le.m_21051_(Attributes.f_22276_);
            if (hp != null) {
                SeasonsForgeBusEvents.removeModifierIfPresent(hp, BLOODY_HEALTH_MOD_UUID);
                AttributeModifier mod = new AttributeModifier(BLOODY_HEALTH_MOD_UUID, "myped_bloody_health", -0.9, AttributeModifier.Operation.MULTIPLY_TOTAL);
                try {
                    hp.m_22118_(mod);
                    le.m_21153_(Math.min(le.m_21223_(), le.m_21233_()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((attack = le.m_21051_(Attributes.f_22281_)) != null) {
                SeasonsForgeBusEvents.removeModifierIfPresent(attack, BLOODY_ATTACK_MOD_UUID);
                AttributeModifier mod2 = new AttributeModifier(BLOODY_ATTACK_MOD_UUID, "myped_bloody_attack", -0.9, AttributeModifier.Operation.MULTIPLY_TOTAL);
                try {
                    attack.m_22118_(mod2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private static void removeBloodyModifiers(LivingEntity le) {
            AttributeInstance attack;
            AttributeInstance hp = le.m_21051_(Attributes.f_22276_);
            if (hp != null) {
                SeasonsForgeBusEvents.removeModifierIfPresent(hp, BLOODY_HEALTH_MOD_UUID);
                SeasonsForgeBusEvents.removeModifierByName(hp, "myped_season_hp_mult");
                SeasonsForgeBusEvents.removeModifierByName(hp, "myped_bloody_health");
            }
            if ((attack = le.m_21051_(Attributes.f_22281_)) != null) {
                SeasonsForgeBusEvents.removeModifierIfPresent(attack, BLOODY_ATTACK_MOD_UUID);
                SeasonsForgeBusEvents.removeModifierByName(attack, "myped_bloody_attack");
            }
        }

        private static void removeModifierIfPresent(AttributeInstance inst, UUID id) {
            try {
                AttributeModifier mod = inst.m_22111_(id);
                if (mod != null) {
                    inst.m_22130_(mod);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private static void removeModifierByName(AttributeInstance inst, String name) {
            try {
                ArrayList<AttributeModifier> toRemove = new ArrayList<AttributeModifier>();
                for (AttributeModifier m : inst.m_22122_()) {
                    if (m == null || !name.equals(m.m_22214_())) continue;
                    toRemove.add(m);
                }
                for (AttributeModifier m : toRemove) {
                    try {
                        inst.m_22130_(m);
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private static boolean isPlayerAffected(ServerPlayer p) {
            if (p == null) {
                return false;
            }
            try {
                if (p.m_5833_()) {
                    return false;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (p.m_150110_() != null && p.m_150110_().f_35937_) {
                    return false;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return true;
        }

        private static boolean isSkyOpenAbove(ServerPlayer p) {
            if (p == null) {
                return false;
            }
            try {
                ServerLevel level = (ServerLevel)p.m_9236_();
                BlockPos pos = p.m_20183_().m_7494_();
                for (int y = pos.m_123342_(); y < level.m_151558_(); ++y) {
                    if (level.m_46859_(new BlockPos(pos.m_123341_(), y, pos.m_123343_()))) continue;
                    return false;
                }
                return true;
            }
            catch (Throwable ignored) {
                return false;
            }
        }

        private static void revertSeasonEffects(MinecraftServer server) {
            try {
                for (ServerLevel level : server.m_129785_()) {
                    for (Entity e : level.m_8583_()) {
                        AttributeInstance atk;
                        if (!(e instanceof LivingEntity)) continue;
                        LivingEntity le = (LivingEntity)e;
                        SeasonsForgeBusEvents.removeBloodyModifiers(le);
                        AttributeInstance hp = le.m_21051_(Attributes.f_22276_);
                        if (hp != null) {
                            SeasonsForgeBusEvents.removeModifierByName(hp, "myped_season_hp_mult");
                        }
                        if ((atk = le.m_21051_(Attributes.f_22281_)) == null) continue;
                        SeasonsForgeBusEvents.removeModifierByName(atk, "myped_season_hp_mult");
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private static class SpawnTracker {
            private int count = 0;

            private SpawnTracker() {
            }

            public synchronized void increment() {
                ++this.count;
            }

            public synchronized int getCount() {
                return this.count;
            }
        }
    }

    private static enum Season {
        PEACEFUL_SKY("\u041c\u0438\u0440\u043d\u043e\u0435 \u043d\u0435\u0431\u043e", "Peaceful Sky", ChatFormatting.AQUA),
        BLOODY_SUN("\u041a\u0440\u043e\u0432\u0430\u0432\u043e\u0435 \u0441\u043e\u043b\u043d\u0446\u0435", "Bloody Sun", ChatFormatting.DARK_RED),
        QUIET_KNIGHT("\u0422\u0438\u0445\u0438\u0439 \u0440\u044b\u0446\u0430\u0440\u044c", "Quiet Knight", ChatFormatting.GOLD),
        LIFE("\u0416\u0438\u0437\u043d\u044c", "Life", ChatFormatting.GREEN),
        END_OF_WORLD("\u041a\u0440\u0430\u0439 \u0441\u0432\u0435\u0442\u0430", "End of World", ChatFormatting.DARK_PURPLE),
        CRYSTAL_DAWN("\u0425\u0440\u0443\u0441\u0442\u0430\u043b\u044c\u043d\u044b\u0439 \u0440\u0430\u0441\u0441\u0432\u0435\u0442", "Crystal Dawn", ChatFormatting.LIGHT_PURPLE),
        THUNDER_THREAT("\u0423\u0433\u0440\u043e\u0437\u0430 \u0433\u0440\u043e\u0437\u0430\u043c\u0438", "Thunder Threat", ChatFormatting.DARK_BLUE),
        GOLDEN_AUTUMN("\u0417\u043e\u043b\u043e\u0442\u0430\u044f \u043e\u0441\u0435\u043d\u044c", "Golden Autumn", ChatFormatting.GOLD),
        LAVA_BREATH("\u041e\u0433\u043d\u0435\u043d\u043d\u043e\u0435 \u0434\u044b\u0445\u0430\u043d\u0438\u0435", "Lava Breath", ChatFormatting.RED),
        BLUE_SEA_WHITE_FOAM("\u0412 \u0441\u0438\u043d\u0435\u043c \u043c\u043e\u0440\u0435 \u0432 \u0431\u0435\u043b\u043e\u0439 \u043f\u0435\u043d\u0435", "Blue Sea White Foam", ChatFormatting.DARK_AQUA),
        SOLAR_DAWN("\u0421\u043e\u043b\u043d\u0435\u0447\u043d\u044b\u0439 \u0440\u0430\u0441\u0441\u0432\u0435\u0442", "Solar Dawn", ChatFormatting.YELLOW),
        SNOW_STORM("\u0421\u043d\u0435\u0436\u043d\u0430\u044f \u0431\u0443\u0440\u044f", "Snow Storm", ChatFormatting.WHITE),
        WORLD_ECLIPSE("\u0417\u0430\u0442\u043c\u0435\u043d\u0438\u0435 \u043c\u0438\u0440\u0430", "World Eclipse", ChatFormatting.DARK_PURPLE),
        HMMM("\u0425\u043c\u043c\u043c", "Hmmm", ChatFormatting.GREEN),
        DRAGON_BREATH("\u0414\u044b\u0445\u0430\u043d\u0438\u0435 \u0434\u0440\u0430\u043a\u043e\u043d\u0430", "Dragon Breath", ChatFormatting.DARK_RED),
        LUNAR_PEACE("\u041b\u0443\u043d\u043d\u044b\u0439 \u043f\u043e\u043a\u043e\u0439", "Lunar Peace", ChatFormatting.BLUE),
        MAGIC_VORTEX("\u041c\u0430\u0433\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0432\u0438\u0445\u0440\u044c", "Magic Vortex", ChatFormatting.LIGHT_PURPLE),
        FOREST_SHADOWS("\u041b\u0435\u0441\u043d\u044b\u0435 \u0442\u0435\u043d\u0438", "Forest Shadows", ChatFormatting.DARK_GREEN),
        SILENT_NIGHT("\u0411\u0435\u0437\u043c\u043e\u043b\u0432\u043d\u0430\u044f \u043d\u043e\u0447\u044c", "Silent Night", ChatFormatting.DARK_GRAY),
        ETERNAL_HARVEST("\u0412\u0435\u0447\u043d\u044b\u0439 \u0443\u0440\u043e\u0436\u0430\u0439", "Eternal Harvest", ChatFormatting.GOLD);

        private final String russian;
        private final String english;
        private final ChatFormatting color;

        private Season(String ru, String en, ChatFormatting c) {
            this.russian = ru;
            this.english = en;
            this.color = c;
        }

        public String getRussian() {
            return this.russian;
        }

        public String getEnglish() {
            return this.english;
        }

        public ChatFormatting getColor() {
            return this.color;
        }
    }

    private static class SeasonSyncPacket {
        private final int seasonId;
        private final boolean enabled;

        public SeasonSyncPacket(int id, boolean enabled) {
            this.seasonId = id;
            this.enabled = enabled;
        }

        public static void encode(SeasonSyncPacket pkt, FriendlyByteBuf buf) {
            buf.writeInt(pkt.seasonId);
            buf.writeBoolean(pkt.enabled);
        }

        public static SeasonSyncPacket decode(FriendlyByteBuf buf) {
            return new SeasonSyncPacket(buf.readInt(), buf.readBoolean());
        }

        public static void handle(SeasonSyncPacket pkt, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> SeasonsClient.setCurrentSeasonClientSide(pkt.seasonId, pkt.enabled));
            ctx.get().setPacketHandled(true);
        }
    }

    public static class SeasonSavedData
    extends SavedData {
        private int seasonOrdinal = Season.LIFE.ordinal();
        private long tickCounterLocal = 0L;

        public static SeasonSavedData load(CompoundTag nbt) {
            SeasonSavedData s = new SeasonSavedData();
            try {
                if (nbt.m_128441_("SeasonOrdinal")) {
                    s.seasonOrdinal = nbt.m_128451_("SeasonOrdinal");
                }
                if (nbt.m_128441_("TickCounter")) {
                    s.tickCounterLocal = nbt.m_128454_("TickCounter");
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return s;
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            try {
                nbt.m_128405_("SeasonOrdinal", this.seasonOrdinal);
                nbt.m_128356_("TickCounter", this.tickCounterLocal);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return nbt;
        }

        public int getSeasonOrdinal() {
            return this.seasonOrdinal;
        }

        public long getTickCounter() {
            return this.tickCounterLocal;
        }

        public void setSeasonOrdinal(int o) {
            this.seasonOrdinal = o;
        }

        public void setTickCounter(long t) {
            this.tickCounterLocal = t;
        }
    }

    private static class SeasonConfig {
        private final List<String> startCommands;
        private final MobEffectFactory playerEffect;
        private final MobEffectFactory playerEffect2;
        private final ItemStack dropItem;
        private final float dropChance;
        private final ItemStack dropReplacement;
        private final float dropReplacementChance;
        private final String rareCommand;
        private final int rareCommandInterval;
        private final double mobAttributeMultiplier;
        private final UUID mobAttributeUUID;
        private final MonsterSpawnModifier mobSpawnModifier;
        private final boolean hasPlayerNearMobEffect;
        private final MobEffectFactory nearMobEffect;
        private final double nearMobRange;
        private final String difficulty;

        private SeasonConfig(Builder b) {
            this.startCommands = b.startCommands;
            this.playerEffect = b.playerEffect;
            this.playerEffect2 = b.playerEffect2;
            this.dropItem = b.dropItem == null ? null : new ItemStack((ItemLike)b.dropItem);
            this.dropChance = b.dropChance;
            this.dropReplacement = b.dropReplacement == null ? null : new ItemStack((ItemLike)b.dropReplacement);
            this.dropReplacementChance = b.dropReplacementChance;
            this.rareCommand = b.rareCommand;
            this.rareCommandInterval = b.rareCommandInterval;
            this.mobAttributeMultiplier = b.mobAttributeMultiplier;
            this.mobAttributeUUID = b.mobAttributeUUID;
            this.mobSpawnModifier = b.mobSpawnModifier;
            this.hasPlayerNearMobEffect = b.hasPlayerNearMobEffect;
            this.nearMobEffect = b.nearMobEffect;
            this.nearMobRange = b.nearMobRange;
            this.difficulty = b.difficulty;
        }

        public List<String> getStartCommands() {
            return this.startCommands;
        }

        public String getRareCommand() {
            return this.rareCommand;
        }

        public int getRareCommandInterval() {
            return this.rareCommandInterval;
        }

        public String getDifficulty() {
            return this.difficulty;
        }

        public boolean hasPlayerEffects() {
            return this.playerEffect != null || this.playerEffect2 != null || this.hasPlayerNearMobEffect;
        }

        public void maybeApplyPlayerEffects(ServerPlayer p, long tick) {
            AABB box;
            ServerLevel level;
            List monsters;
            if (this.playerEffect != null && tick % 100L == 0L) {
                p.m_7292_(this.playerEffect.create());
            }
            if (this.playerEffect2 != null && tick % 100L == 0L) {
                p.m_7292_(this.playerEffect2.create());
            }
            if (this.hasPlayerNearMobEffect && tick % 100L == 0L && !(monsters = (level = (ServerLevel)p.m_9236_()).m_6443_(Monster.class, box = p.m_20191_().m_82400_(this.nearMobRange), m -> true)).isEmpty()) {
                p.m_7292_(this.nearMobEffect.create());
            }
        }

        public void applyMobSpawnModifiers(Monster m) {
            try {
                AttributeInstance hp;
                if (this.mobSpawnModifier != null) {
                    this.mobSpawnModifier.modify(m);
                }
                if (this.mobAttributeMultiplier > 0.0 && this.mobAttributeUUID != null && (hp = m.m_21051_(Attributes.f_22276_)) != null) {
                    SeasonConfig.removeModifierIfPresent(hp, this.mobAttributeUUID);
                    AttributeModifier mod = new AttributeModifier(this.mobAttributeUUID, "myped_season_hp_mult", this.mobAttributeMultiplier - 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
                    hp.m_22118_(mod);
                    m.m_21153_(Math.min(m.m_21223_(), m.m_21233_()));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void maybeModifyDrops(LivingDropsEvent event) {
            try {
                if (this.dropItem != null && RANDOM.nextFloat() < this.dropChance) {
                    event.getDrops().add(new ItemEntity(event.getEntity().m_9236_(), event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), this.dropItem.m_41777_()));
                }
                if (this.dropReplacement != null && RANDOM.nextFloat() < this.dropReplacementChance) {
                    event.getDrops().clear();
                    event.getDrops().add(new ItemEntity(event.getEntity().m_9236_(), event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), this.dropReplacement.m_41777_()));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private static void removeModifierIfPresent(AttributeInstance inst, UUID id) {
            try {
                AttributeModifier mod = inst.m_22111_(id);
                if (mod != null) {
                    inst.m_22130_(mod);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public static class Builder {
            private List<String> startCommands;
            private MobEffectFactory playerEffect;
            private MobEffectFactory playerEffect2;
            private Item dropItem;
            private float dropChance;
            private Item dropReplacement;
            private float dropReplacementChance;
            private String rareCommand;
            private int rareCommandInterval = 24000;
            private double mobAttributeMultiplier = 0.0;
            private UUID mobAttributeUUID;
            private MonsterSpawnModifier mobSpawnModifier;
            private boolean hasPlayerNearMobEffect = false;
            private MobEffectFactory nearMobEffect;
            private double nearMobRange = 16.0;
            private String difficulty;

            public Builder setStartCommands(List<String> cmds) {
                this.startCommands = cmds;
                return this;
            }

            public Builder setPlayerPeriodicEffect(MobEffectFactory f) {
                this.playerEffect = Builder.wrapFactory(f);
                return this;
            }

            public Builder setPlayerPeriodicEffect2(MobEffectFactory f) {
                this.playerEffect2 = Builder.wrapFactory(f);
                return this;
            }

            public Builder setDropBonus(Item item, float chance) {
                this.dropItem = item;
                this.dropChance = chance;
                return this;
            }

            public Builder setDropReplacement(Item item, float chance) {
                this.dropReplacement = item;
                this.dropReplacementChance = chance;
                return this;
            }

            public Builder setRareWorldCommand(String cmd, int interval) {
                this.rareCommand = cmd;
                this.rareCommandInterval = interval;
                return this;
            }

            public Builder setMobAttributeMultiplier(UUID id, double multiplier) {
                this.mobAttributeUUID = id;
                this.mobAttributeMultiplier = multiplier;
                return this;
            }

            public Builder setMobSpawnModifier(MonsterSpawnModifier mod) {
                this.mobSpawnModifier = mod;
                return this;
            }

            public Builder setPlayerNearMobEffect(MobEffectFactory f, int interval, double range) {
                this.hasPlayerNearMobEffect = true;
                this.nearMobEffect = Builder.wrapFactory(f);
                this.nearMobRange = range;
                return this;
            }

            public Builder setDifficulty(String d) {
                this.difficulty = d;
                return this;
            }

            public SeasonConfig build() {
                return new SeasonConfig(this);
            }

            private static MobEffectFactory wrapFactory(MobEffectFactory f) {
                return () -> {
                    MobEffectInstance sample = f.create();
                    return new MobEffectInstance(sample.m_19544_(), 100, 0, false, false);
                };
            }
        }

        @FunctionalInterface
        private static interface MobEffectFactory {
            public MobEffectInstance create();
        }

        @FunctionalInterface
        private static interface MonsterSpawnModifier {
            public boolean modify(Monster var1);
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE, modid="myped")
    private static class SeasonsClient {
        private static volatile int currentSeasonOrdinal = Season.LIFE.ordinal();
        private static volatile boolean showSeason = true;

        private SeasonsClient() {
        }

        public static void setCurrentSeasonClientSide(int ord, boolean enabled) {
            currentSeasonOrdinal = ord;
            showSeason = enabled;
        }

        @SubscribeEvent
        public static void onRenderGuiOverlayPost(RenderGuiOverlayEvent.Post event) {
            String prefixKey;
            String prefix;
            boolean prefixTranslated;
            String langCode;
            boolean translated;
            String seasonName;
            Season s;
            int y;
            int x;
            Minecraft mc;
            GuiGraphics gg;
            block9: {
                if (!showSeason) {
                    return;
                }
                gg = event.getGuiGraphics();
                mc = Minecraft.m_91087_();
                x = 2;
                y = 2;
                s = Season.values()[Math.max(0, Math.min(currentSeasonOrdinal, Season.values().length - 1))];
                String transKey = "myped.season." + s.name().toLowerCase(Locale.ROOT);
                seasonName = Component.m_237115_((String)transKey).getString();
                translated = !seasonName.equals(transKey);
                langCode = null;
                try {
                    String sel = mc.m_91102_().m_264236_();
                    if (sel instanceof String) {
                        langCode = sel;
                        break block9;
                    }
                    try {
                        Method m = sel.getClass().getMethod("getCode", new Class[0]);
                        Object code = m.invoke((Object)sel, new Object[0]);
                        if (code != null) {
                            langCode = code.toString();
                            break block9;
                        }
                        langCode = sel.toString();
                    }
                    catch (Exception e) {
                        langCode = sel.toString();
                    }
                }
                catch (Throwable sel) {
                    // empty catch block
                }
            }
            if (!translated) {
                seasonName = langCode != null && langCode.startsWith("ru") ? s.getRussian() : s.getEnglish();
            }
            boolean bl = prefixTranslated = !(prefix = Component.m_237115_((String)(prefixKey = "myped.season.prefix")).getString()).equals(prefixKey);
            if (!prefixTranslated) {
                prefix = langCode != null && langCode.startsWith("ru") ? "\u0421\u0435\u0437\u043e\u043d:" : "Season:";
            }
            String text = prefix + " " + seasonName;
            int color = SeasonsClient.getColorInt(s.getColor());
            int textWidth = mc.f_91062_.m_92895_(text);
            int pad = 4;
            int bgLeft = x - pad / 2;
            int bgTop = y - pad / 2;
            int bgRight = x + textWidth + pad;
            Objects.requireNonNull(mc.f_91062_);
            int bgBottom = y + 9 + pad / 2;
            gg.m_280509_(bgLeft, bgTop, bgRight, bgBottom, 0);
            gg.m_280056_(mc.f_91062_, text, x, y, color, false);
        }

        private static int getColorInt(ChatFormatting cf) {
            try {
                Integer c = cf.m_126665_();
                if (c != null) {
                    return c;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return 0xFFFFFF;
        }
    }
}

