/*
 * Decompiled with CFR 0.152.
 */
package net.deskped.myped.entity;

import net.deskped.myped.init.MypedModEntities;
import net.deskped.myped.init.MypedModItems;
import net.deskped.myped.procedures.AutbreakTikProcedure;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class ChargeEntity
extends AbstractArrow
implements ItemSupplier {
    public static final ItemStack PROJECTILE_ITEM = new ItemStack((ItemLike)MypedModItems.OUTBREAK_IN_A_BOTTLE.get());

    public ChargeEntity(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType)MypedModEntities.CHARGE.get(), world);
    }

    public ChargeEntity(EntityType<? extends ChargeEntity> type, Level world) {
        super(type, world);
    }

    public ChargeEntity(EntityType<? extends ChargeEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
    }

    public ChargeEntity(EntityType<? extends ChargeEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack m_7846_() {
        return PROJECTILE_ITEM;
    }

    protected ItemStack m_7941_() {
        return PROJECTILE_ITEM;
    }

    protected void m_7761_(LivingEntity entity) {
        super.m_7761_(entity);
        entity.m_21317_(entity.m_21234_() - 1);
    }

    public void m_8119_() {
        super.m_8119_();
        AutbreakTikProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
        if (this.f_19797_ > 80) {
            this.m_146870_();
            return;
        }
        if (this.f_36703_) {
            this.m_146870_();
            return;
        }
        if (!this.m_9236_().f_46443_) {
            double radius = 32.0;
            LivingEntity target = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(radius)).stream().filter(e -> e.m_6084_() && e != this.m_19749_()).filter(e -> {
                if (e instanceof Player) {
                    Player player = (Player)e;
                    if (player.m_7500_() || player.m_5833_()) {
                        return false;
                    }
                    if (player.m_21023_(MobEffects.f_19609_)) {
                        return false;
                    }
                }
                return true;
            }).min((a, b) -> Double.compare(this.m_20270_((Entity)a), this.m_20270_((Entity)b))).orElse(null);
            if (target != null) {
                Vec3 toTarget;
                double dist;
                Vec3 motion = this.m_20184_();
                double speed = motion.m_82553_();
                if (speed < 0.001) {
                    speed = 3.0;
                }
                if ((dist = (toTarget = new Vec3(target.m_20185_() - this.m_20185_(), target.m_20188_() - this.m_20186_(), target.m_20189_() - this.m_20189_())).m_82553_()) > 1.0E-4) {
                    Vec3 dir = toTarget.m_82490_(1.0 / dist);
                    double homingStrength = 0.45;
                    Vec3 newMotion = motion.m_82490_(1.0 - homingStrength).m_82549_(dir.m_82490_(homingStrength));
                    newMotion = newMotion.m_82541_().m_82490_(Math.max(speed, 2.0));
                    this.m_20256_(newMotion);
                    double nx = newMotion.f_82479_;
                    double ny = newMotion.f_82480_;
                    double nz = newMotion.f_82481_;
                    double horizontal = Math.sqrt(nx * nx + nz * nz);
                    float yaw = (float)(Math.atan2(nz, nx) * 57.29577951308232) - 90.0f;
                    float pitch = (float)(Math.atan2(ny, horizontal) * 57.29577951308232);
                    this.m_146922_(yaw);
                    this.m_146926_(pitch);
                }
            }
        }
    }

    protected void m_5790_(EntityHitResult hitResult) {
        super.m_5790_(hitResult);
        Entity entity = hitResult.m_82443_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack offhand = player.m_21120_(InteractionHand.OFF_HAND);
            ItemStack mainhand = player.m_21120_(InteractionHand.MAIN_HAND);
            if (offhand.m_150930_(Items.f_42740_) && player.m_21254_() || mainhand.m_150930_(Items.f_42740_) && player.m_21254_()) {
                this.m_146870_();
            }
        }
    }

    public static ChargeEntity shoot(Level world, LivingEntity entity, RandomSource source) {
        return ChargeEntity.shoot(world, entity, source, 1.0f, 8.0, 2);
    }

    public static ChargeEntity shoot(Level world, LivingEntity entity, RandomSource source, float pullingPower) {
        return ChargeEntity.shoot(world, entity, source, pullingPower * 1.0f, 8.0, 2);
    }

    public static ChargeEntity shoot(Level world, LivingEntity entity, RandomSource random, float power, double damage, int knockback) {
        ChargeEntity entityarrow = new ChargeEntity((EntityType<? extends ChargeEntity>)((EntityType)MypedModEntities.CHARGE.get()), entity, world);
        entityarrow.m_6686_(entity.m_20252_((float)1.0f).f_82479_, entity.m_20252_((float)1.0f).f_82480_, entity.m_20252_((float)1.0f).f_82481_, power * 3.0f, 0.0f);
        entityarrow.m_20225_(true);
        entityarrow.m_36762_(false);
        entityarrow.m_36781_(damage);
        entityarrow.m_36735_(knockback);
        Vec3 m = entityarrow.m_20184_();
        if (m.m_82553_() > 1.0E-4) {
            entityarrow.m_20256_(m.m_82541_().m_82490_(3.3333333333333335));
        }
        world.m_7967_((Entity)entityarrow);
        world.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.shulker.shoot")), SoundSource.PLAYERS, 1.0f, 1.0f / (random.m_188501_() * 0.5f + 1.0f) + power / 2.0f);
        return entityarrow;
    }

    public static ChargeEntity shoot(LivingEntity entity, LivingEntity target) {
        ChargeEntity entityarrow = new ChargeEntity((EntityType<? extends ChargeEntity>)((EntityType)MypedModEntities.CHARGE.get()), entity, entity.m_9236_());
        double dx = target.m_20185_() - entity.m_20185_();
        double dy = target.m_20186_() + (double)target.m_20192_() - 1.1;
        double dz = target.m_20189_() - entity.m_20189_();
        entityarrow.m_6686_(dx, dy - entityarrow.m_20186_() + Math.hypot(dx, dz) * (double)0.2f, dz, 12.0f, 0.0f);
        entityarrow.m_20225_(true);
        entityarrow.m_36781_(8.0);
        entityarrow.m_36735_(2);
        entityarrow.m_36762_(false);
        Vec3 m = entityarrow.m_20184_();
        if (m.m_82553_() > 1.0E-4) {
            entityarrow.m_20256_(m.m_82541_().m_82490_(4.0));
        }
        entity.m_9236_().m_7967_((Entity)entityarrow);
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.shulker.shoot")), SoundSource.PLAYERS, 1.0f, 1.0f / (RandomSource.m_216327_().m_188501_() * 0.5f + 1.0f));
        return entityarrow;
    }
}

