/*
 * Decompiled with CFR 0.152.
 */
package net.theobsessed.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.theobsessed.procedures.DebugToggleOnKeyPressedProcedure;
import net.theobsessed.procedures.ForceIdkSpawnProcedure;
import net.theobsessed.procedures.IntensityCommandProcedure;
import net.theobsessed.procedures.SetHappinessProcedure;
import net.theobsessed.procedures.SetSpawnTimeProcedure;

@EventBusSubscriber
public class DebugCommand {
    @SubscribeEvent
    public static void registerCommand(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"obsessed").requires(s -> s.hasPermission(2))).then(Commands.literal((String)"debugmode").then(Commands.argument((String)"enable", (ArgumentType)BoolArgumentType.bool()).executes(arguments -> {
            Level world = ((CommandSourceStack)arguments.getSource()).getUnsidedLevel();
            double x = ((CommandSourceStack)arguments.getSource()).getPosition().x();
            double y = ((CommandSourceStack)arguments.getSource()).getPosition().y();
            double z = ((CommandSourceStack)arguments.getSource()).getPosition().z();
            Entity entity = ((CommandSourceStack)arguments.getSource()).getEntity();
            if (entity == null && world instanceof ServerLevel) {
                ServerLevel _servLevel = (ServerLevel)world;
                entity = FakePlayerFactory.getMinecraft((ServerLevel)_servLevel);
            }
            Direction direction = Direction.DOWN;
            if (entity != null) {
                direction = entity.getDirection();
            }
            DebugToggleOnKeyPressedProcedure.execute((CommandContext<CommandSourceStack>)arguments, entity);
            return 0;
        })))).then(Commands.literal((String)"force_spawn").executes(arguments -> {
            Level world = ((CommandSourceStack)arguments.getSource()).getUnsidedLevel();
            double x = ((CommandSourceStack)arguments.getSource()).getPosition().x();
            double y = ((CommandSourceStack)arguments.getSource()).getPosition().y();
            double z = ((CommandSourceStack)arguments.getSource()).getPosition().z();
            Entity entity = ((CommandSourceStack)arguments.getSource()).getEntity();
            if (entity == null && world instanceof ServerLevel) {
                ServerLevel _servLevel = (ServerLevel)world;
                entity = FakePlayerFactory.getMinecraft((ServerLevel)_servLevel);
            }
            Direction direction = Direction.DOWN;
            if (entity != null) {
                direction = entity.getDirection();
            }
            ForceIdkSpawnProcedure.execute((LevelAccessor)world, entity);
            return 0;
        }))).then(Commands.literal((String)"set_happiness").then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"happiness_level", (ArgumentType)DoubleArgumentType.doubleArg((double)-5.0, (double)5.0)).executes(arguments -> {
            Level world = ((CommandSourceStack)arguments.getSource()).getUnsidedLevel();
            double x = ((CommandSourceStack)arguments.getSource()).getPosition().x();
            double y = ((CommandSourceStack)arguments.getSource()).getPosition().y();
            double z = ((CommandSourceStack)arguments.getSource()).getPosition().z();
            Entity entity = ((CommandSourceStack)arguments.getSource()).getEntity();
            if (entity == null && world instanceof ServerLevel) {
                ServerLevel _servLevel = (ServerLevel)world;
                entity = FakePlayerFactory.getMinecraft((ServerLevel)_servLevel);
            }
            Direction direction = Direction.DOWN;
            if (entity != null) {
                direction = entity.getDirection();
            }
            SetHappinessProcedure.execute((CommandContext<CommandSourceStack>)arguments, entity);
            return 0;
        }))))).then(Commands.literal((String)"set_intensity").then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"intensity_0_to_3", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)3.0)).executes(arguments -> {
            Level world = ((CommandSourceStack)arguments.getSource()).getUnsidedLevel();
            double x = ((CommandSourceStack)arguments.getSource()).getPosition().x();
            double y = ((CommandSourceStack)arguments.getSource()).getPosition().y();
            double z = ((CommandSourceStack)arguments.getSource()).getPosition().z();
            Entity entity = ((CommandSourceStack)arguments.getSource()).getEntity();
            if (entity == null && world instanceof ServerLevel) {
                ServerLevel _servLevel = (ServerLevel)world;
                entity = FakePlayerFactory.getMinecraft((ServerLevel)_servLevel);
            }
            Direction direction = Direction.DOWN;
            if (entity != null) {
                direction = entity.getDirection();
            }
            IntensityCommandProcedure.execute((CommandContext<CommandSourceStack>)arguments, entity);
            return 0;
        }))))).then(Commands.literal((String)"spawn_time").then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"time_in_seconds_before_spawn", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)9999999.0)).executes(arguments -> {
            Level world = ((CommandSourceStack)arguments.getSource()).getUnsidedLevel();
            double x = ((CommandSourceStack)arguments.getSource()).getPosition().x();
            double y = ((CommandSourceStack)arguments.getSource()).getPosition().y();
            double z = ((CommandSourceStack)arguments.getSource()).getPosition().z();
            Entity entity = ((CommandSourceStack)arguments.getSource()).getEntity();
            if (entity == null && world instanceof ServerLevel) {
                ServerLevel _servLevel = (ServerLevel)world;
                entity = FakePlayerFactory.getMinecraft((ServerLevel)_servLevel);
            }
            Direction direction = Direction.DOWN;
            if (entity != null) {
                direction = entity.getDirection();
            }
            SetSpawnTimeProcedure.execute((CommandContext<CommandSourceStack>)arguments, entity);
            return 0;
        })))));
    }
}

