/*
 * Decompiled with CFR 0.152.
 */
package net.theobsessed.init;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.theobsessed.potion.ZoomSlowMobEffect;
import net.theobsessed.procedures.ZoomSlowEffectExpiresProcedure;

@Mod.EventBusSubscriber
public class TheObsessedModMobEffects {
    public static final DeferredRegister<MobEffect> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"the_obsessed");
    public static final DeferredHolder<MobEffect, MobEffect> ZOOM_SLOW = REGISTRY.register("zoom_slow", () -> new ZoomSlowMobEffect());

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            TheObsessedModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            TheObsessedModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    private static void expireEffects(Entity entity, MobEffectInstance effectInstance) {
        MobEffect effect = effectInstance.getEffect();
        if (effect == ZOOM_SLOW.get()) {
            ZoomSlowEffectExpiresProcedure.execute(entity);
        }
    }
}

