/*
 * Decompiled with CFR 0.152.
 */
package net.theobsessed.item;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.theobsessed.procedures.CrushedAnimalRemainsItemInHandTickProcedure;
import net.theobsessed.procedures.DustySpiderEggRightclickedOnBlockProcedure;

public class DustySpiderEggItem
extends Item {
    public DustySpiderEggItem() {
        super(new Item.Properties().stacksTo(64).rarity(Rarity.COMMON));
    }

    public int getUseDuration(ItemStack itemstack, LivingEntity livingEntity) {
        return 80;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.literal((String)"\u00a77+1 mood for the obsessor on first pickup"));
        list.add((Component)Component.literal((String)"\u00a77+1 mood for the obsessor on placement"));
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = super.use(world, entity, hand);
        entity.startUsingItem(hand);
        return ar;
    }

    public InteractionResult useOn(UseOnContext context) {
        super.useOn(context);
        DustySpiderEggRightclickedOnBlockProcedure.execute((LevelAccessor)context.getLevel(), context.getClickedPos().getX(), context.getClickedPos().getY(), context.getClickedPos().getZ(), (Entity)context.getPlayer());
        return InteractionResult.SUCCESS;
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        if (selected) {
            CrushedAnimalRemainsItemInHandTickProcedure.execute(entity);
        }
    }
}

