/*
 * Decompiled with CFR 0.152.
 */
package net.theobsessed;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.TickEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.handling.IPlayPayloadHandler;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;
import net.theobsessed.init.TheObsessedModEntities;
import net.theobsessed.init.TheObsessedModItems;
import net.theobsessed.init.TheObsessedModMobEffects;
import net.theobsessed.init.TheObsessedModParticleTypes;
import net.theobsessed.init.TheObsessedModSounds;
import net.theobsessed.init.TheObsessedModTabs;
import net.theobsessed.network.TheObsessedModVariables;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="the_obsessed")
public class TheObsessedMod {
    public static final Logger LOGGER = LogManager.getLogger(TheObsessedMod.class);
    public static final String MODID = "the_obsessed";
    private static boolean networkingRegistered = false;
    private static final Map<ResourceLocation, NetworkMessage<?>> MESSAGES = new HashMap();
    private static final Collection<Tuple<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<Tuple<Runnable, Integer>>();

    public TheObsessedMod(IEventBus modEventBus) {
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::registerNetworking);
        TheObsessedModSounds.REGISTRY.register(modEventBus);
        TheObsessedModItems.register(modEventBus);
        TheObsessedModEntities.REGISTRY.register(modEventBus);
        TheObsessedModTabs.REGISTRY.register(modEventBus);
        TheObsessedModVariables.ATTACHMENT_TYPES.register(modEventBus);
        TheObsessedModMobEffects.REGISTRY.register(modEventBus);
        TheObsessedModParticleTypes.REGISTRY.register(modEventBus);
    }

    public static <T extends CustomPacketPayload> void addNetworkMessage(ResourceLocation id, FriendlyByteBuf.Reader<T> reader, IPlayPayloadHandler<T> handler) {
        if (networkingRegistered) {
            throw new IllegalStateException("Cannot register new network messages after networking has been registered");
        }
        MESSAGES.put(id, new NetworkMessage<T>(reader, handler));
    }

    private void registerNetworking(RegisterPayloadHandlerEvent event) {
        IPayloadRegistrar registrar = event.registrar(MODID);
        MESSAGES.forEach((id, networkMessage) -> registrar.play(id, networkMessage.reader(), networkMessage.handler()));
        networkingRegistered = true;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add((Tuple<Runnable, Integer>)new Tuple((Object)action, (Object)tick));
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setB((Object)((Integer)work.getB() - 1));
                if ((Integer)work.getB() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getA()).run());
            workQueue.removeAll(actions);
        }
    }

    private record NetworkMessage<T extends CustomPacketPayload>(FriendlyByteBuf.Reader<T> reader, IPlayPayloadHandler<T> handler) {
    }
}

