/*
 * Decompiled with CFR 0.152.
 */
package net.theobsessed.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.theobsessed.TheObsessedMod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TheObsessedModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        TheObsessedMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        TheObsessedMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.idktarget = message.data.idktarget;
                    variables.idkmood = message.data.idkmood;
                    variables.idkhealth_perplayer = message.data.idkhealth_perplayer;
                    variables.gift1 = message.data.gift1;
                    variables.gift2 = message.data.gift2;
                    variables.gift3 = message.data.gift3;
                    variables.obsessedpopup = message.data.obsessedpopup;
                    variables.debug_command = message.data.debug_command;
                    variables.one_time_splash = message.data.one_time_splash;
                    variables.obsession_length = message.data.obsession_length;
                    variables.gift4 = message.data.gift4;
                    variables.gift5 = message.data.gift5;
                    variables.gift6 = message.data.gift6;
                    variables.gift7 = message.data.gift7;
                    variables.message_memory = message.data.message_memory;
                    variables.store_chats = message.data.store_chats;
                    variables.store_chats_2 = message.data.store_chats_2;
                    variables.store_chats_3 = message.data.store_chats_3;
                    variables.store_chats_4 = message.data.store_chats_4;
                    variables.store_chats_5 = message.data.store_chats_5;
                    variables.gift8 = message.data.gift8;
                    variables.last_targeter_spawnfail = message.data.last_targeter_spawnfail;
                    variables.gift9 = message.data.gift9;
                    variables.gift10 = message.data.gift10;
                    variables.gift11 = message.data.gift11;
                    variables.patron_informed = message.data.patron_informed;
                    variables.time_outside_overworld = message.data.time_outside_overworld;
                    variables.last_untarget_reason = message.data.last_untarget_reason;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public boolean idktarget = false;
        public double idkmood = 0.0;
        public double idkhealth_perplayer = 0.0;
        public boolean gift1 = false;
        public boolean gift2 = false;
        public boolean gift3 = false;
        public boolean obsessedpopup = false;
        public boolean debug_command = false;
        public boolean one_time_splash = false;
        public double obsession_length = 0.0;
        public boolean gift4 = false;
        public boolean gift5 = false;
        public boolean gift6 = false;
        public boolean gift7 = false;
        public String message_memory = "\"\"";
        public String store_chats = "\"\"";
        public String store_chats_2 = "\"\"";
        public String store_chats_3 = "\"\"";
        public String store_chats_4 = "\"\"";
        public String store_chats_5 = "\"\"";
        public boolean gift8 = false;
        public String last_targeter_spawnfail = "\"\"";
        public boolean gift9 = false;
        public boolean gift10 = false;
        public boolean gift11 = false;
        public boolean patron_informed = false;
        public double time_outside_overworld = 0.0;
        public String last_untarget_reason = "\"\"";

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                TheObsessedMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("idktarget", this.idktarget);
            nbt.m_128347_("idkmood", this.idkmood);
            nbt.m_128347_("idkhealth_perplayer", this.idkhealth_perplayer);
            nbt.m_128379_("gift1", this.gift1);
            nbt.m_128379_("gift2", this.gift2);
            nbt.m_128379_("gift3", this.gift3);
            nbt.m_128379_("obsessedpopup", this.obsessedpopup);
            nbt.m_128379_("debug_command", this.debug_command);
            nbt.m_128379_("one_time_splash", this.one_time_splash);
            nbt.m_128347_("obsession_length", this.obsession_length);
            nbt.m_128379_("gift4", this.gift4);
            nbt.m_128379_("gift5", this.gift5);
            nbt.m_128379_("gift6", this.gift6);
            nbt.m_128379_("gift7", this.gift7);
            nbt.m_128359_("message_memory", this.message_memory);
            nbt.m_128359_("store_chats", this.store_chats);
            nbt.m_128359_("store_chats_2", this.store_chats_2);
            nbt.m_128359_("store_chats_3", this.store_chats_3);
            nbt.m_128359_("store_chats_4", this.store_chats_4);
            nbt.m_128359_("store_chats_5", this.store_chats_5);
            nbt.m_128379_("gift8", this.gift8);
            nbt.m_128359_("last_targeter_spawnfail", this.last_targeter_spawnfail);
            nbt.m_128379_("gift9", this.gift9);
            nbt.m_128379_("gift10", this.gift10);
            nbt.m_128379_("gift11", this.gift11);
            nbt.m_128379_("patron_informed", this.patron_informed);
            nbt.m_128347_("time_outside_overworld", this.time_outside_overworld);
            nbt.m_128359_("last_untarget_reason", this.last_untarget_reason);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.idktarget = nbt.m_128471_("idktarget");
            this.idkmood = nbt.m_128459_("idkmood");
            this.idkhealth_perplayer = nbt.m_128459_("idkhealth_perplayer");
            this.gift1 = nbt.m_128471_("gift1");
            this.gift2 = nbt.m_128471_("gift2");
            this.gift3 = nbt.m_128471_("gift3");
            this.obsessedpopup = nbt.m_128471_("obsessedpopup");
            this.debug_command = nbt.m_128471_("debug_command");
            this.one_time_splash = nbt.m_128471_("one_time_splash");
            this.obsession_length = nbt.m_128459_("obsession_length");
            this.gift4 = nbt.m_128471_("gift4");
            this.gift5 = nbt.m_128471_("gift5");
            this.gift6 = nbt.m_128471_("gift6");
            this.gift7 = nbt.m_128471_("gift7");
            this.message_memory = nbt.m_128461_("message_memory");
            this.store_chats = nbt.m_128461_("store_chats");
            this.store_chats_2 = nbt.m_128461_("store_chats_2");
            this.store_chats_3 = nbt.m_128461_("store_chats_3");
            this.store_chats_4 = nbt.m_128461_("store_chats_4");
            this.store_chats_5 = nbt.m_128461_("store_chats_5");
            this.gift8 = nbt.m_128471_("gift8");
            this.last_targeter_spawnfail = nbt.m_128461_("last_targeter_spawnfail");
            this.gift9 = nbt.m_128471_("gift9");
            this.gift10 = nbt.m_128471_("gift10");
            this.gift11 = nbt.m_128471_("gift11");
            this.patron_informed = nbt.m_128471_("patron_informed");
            this.time_outside_overworld = nbt.m_128459_("time_outside_overworld");
            this.last_untarget_reason = nbt.m_128461_("last_untarget_reason");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("the_obsessed", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "the_obsessed_mapvars";
        public String log_last_type_attempt = "\"\"";
        public String log_last_type__attempt_origin = "\"\"";
        public double obsessed_exists = 0.0;
        public boolean global_normaltick = false;
        public double obs_x = 0.0;
        public double obs_y = 0.0;
        public double obs_z = 0.0;
        public double obs_yaw = 0.0;
        public String last_despawn_reason = "\"\"";
        public String single_player_target_uuid = "\"\"";
        public double time_without_finding_single_target = 0.0;
        public double chat_cooldown = 0.0;
        public String targeter_spawn_cancel_list = "\"\"";
        public boolean report_mimic_spawn = false;
        public String t1_patrons = "\"\"";
        public String t2_patrons = "\"\"";
        public String t3_patrons = "\"\"";
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.log_last_type_attempt = nbt.m_128461_("log_last_type_attempt");
            this.log_last_type__attempt_origin = nbt.m_128461_("log_last_type__attempt_origin");
            this.obsessed_exists = nbt.m_128459_("obsessed_exists");
            this.global_normaltick = nbt.m_128471_("global_normaltick");
            this.obs_x = nbt.m_128459_("obs_x");
            this.obs_y = nbt.m_128459_("obs_y");
            this.obs_z = nbt.m_128459_("obs_z");
            this.obs_yaw = nbt.m_128459_("obs_yaw");
            this.last_despawn_reason = nbt.m_128461_("last_despawn_reason");
            this.single_player_target_uuid = nbt.m_128461_("single_player_target_uuid");
            this.time_without_finding_single_target = nbt.m_128459_("time_without_finding_single_target");
            this.chat_cooldown = nbt.m_128459_("chat_cooldown");
            this.targeter_spawn_cancel_list = nbt.m_128461_("targeter_spawn_cancel_list");
            this.report_mimic_spawn = nbt.m_128471_("report_mimic_spawn");
            this.t1_patrons = nbt.m_128461_("t1_patrons");
            this.t2_patrons = nbt.m_128461_("t2_patrons");
            this.t3_patrons = nbt.m_128461_("t3_patrons");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128359_("log_last_type_attempt", this.log_last_type_attempt);
            nbt.m_128359_("log_last_type__attempt_origin", this.log_last_type__attempt_origin);
            nbt.m_128347_("obsessed_exists", this.obsessed_exists);
            nbt.m_128379_("global_normaltick", this.global_normaltick);
            nbt.m_128347_("obs_x", this.obs_x);
            nbt.m_128347_("obs_y", this.obs_y);
            nbt.m_128347_("obs_z", this.obs_z);
            nbt.m_128347_("obs_yaw", this.obs_yaw);
            nbt.m_128359_("last_despawn_reason", this.last_despawn_reason);
            nbt.m_128359_("single_player_target_uuid", this.single_player_target_uuid);
            nbt.m_128347_("time_without_finding_single_target", this.time_without_finding_single_target);
            nbt.m_128347_("chat_cooldown", this.chat_cooldown);
            nbt.m_128359_("targeter_spawn_cancel_list", this.targeter_spawn_cancel_list);
            nbt.m_128379_("report_mimic_spawn", this.report_mimic_spawn);
            nbt.m_128359_("t1_patrons", this.t1_patrons);
            nbt.m_128359_("t2_patrons", this.t2_patrons);
            nbt.m_128359_("t3_patrons", this.t3_patrons);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                TheObsessedMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "the_obsessed_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                TheObsessedMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.idktarget = original.idktarget;
            clone.idkmood = original.idkmood;
            clone.idkhealth_perplayer = original.idkhealth_perplayer;
            clone.gift1 = original.gift1;
            clone.gift2 = original.gift2;
            clone.gift3 = original.gift3;
            clone.one_time_splash = original.one_time_splash;
            clone.obsession_length = original.obsession_length;
            clone.gift4 = original.gift4;
            clone.gift5 = original.gift5;
            clone.gift6 = original.gift6;
            clone.gift7 = original.gift7;
            clone.message_memory = original.message_memory;
            clone.store_chats = original.store_chats;
            clone.store_chats_2 = original.store_chats_2;
            clone.store_chats_3 = original.store_chats_3;
            clone.store_chats_4 = original.store_chats_4;
            clone.store_chats_5 = original.store_chats_5;
            clone.gift8 = original.gift8;
            clone.last_targeter_spawnfail = original.last_targeter_spawnfail;
            clone.gift9 = original.gift9;
            clone.gift10 = original.gift10;
            clone.gift11 = original.gift11;
            clone.patron_informed = original.patron_informed;
            clone.time_outside_overworld = original.time_outside_overworld;
            clone.last_untarget_reason = original.last_untarget_reason;
            if (!event.isWasDeath()) {
                clone.obsessedpopup = original.obsessedpopup;
                clone.debug_command = original.debug_command;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    TheObsessedMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    TheObsessedMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                TheObsessedMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

