/*
 * Decompiled with CFR 0.152.
 */
package net.theobsessed.configuration;

import net.neoforged.neoforge.common.ModConfigSpec;

public class IdkConfigsConfiguration {
    public static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec SPEC;
    public static final ModConfigSpec.ConfigValue<Double> STALK_FREQUENCY;
    public static final ModConfigSpec.ConfigValue<Double> ORIGINAL_SPAWNRATE;
    public static final ModConfigSpec.ConfigValue<Double> PATIENCE;
    public static final ModConfigSpec.ConfigValue<Boolean> SPLASH_TEXT;
    public static final ModConfigSpec.ConfigValue<Boolean> ALLOW_MULTIPLE_TARGETS;
    public static final ModConfigSpec.ConfigValue<Boolean> ALLOW_HALLUCINATIONS;
    public static final ModConfigSpec.ConfigValue<Boolean> ALLOW_CREATIVE_TARGET;
    public static final ModConfigSpec.ConfigValue<Boolean> OBSESSED_GRIEFING;
    public static final ModConfigSpec.ConfigValue<Double> SINGLE_TARGET_INTEREST;

    static {
        BUILDER.push("Spawning");
        STALK_FREQUENCY = BUILDER.comment("You can boost the frequency of the obsessed stalking its targets by increasing this number (4,000 default), or decrease it by lowering it (minimum=0, maximum effect=6000)").define("Stalk Frequency", (Object)4000.0);
        ORIGINAL_SPAWNRATE = BUILDER.comment("You can boost the frequency of the original targeting version of the obsessed by increasing this number (2400 default), or decrease it by lowering it (minimum=0, maximum effect=4600)").define("Natural Targeter Spawnrate", (Object)2400.0);
        BUILDER.pop();
        BUILDER.push("Difficulty");
        PATIENCE = BUILDER.comment("Minimum 1.0, default 5.0. Controls how many obsessed spawns occur before each time its mood decreases automatically. E.g. with default value of 10.0, every eight times it spawns, it will decrease its mood by 1 point (mood range is -5 to 5).").define("Obsessed Patience", (Object)8.0);
        BUILDER.pop();
        BUILDER.push("Other");
        SPLASH_TEXT = BUILDER.comment("Set to false to disable the initial welcome text shown to players on first world load").define("Splash Text", true);
        ALLOW_MULTIPLE_TARGETS = BUILDER.comment("Allow multiple players to be targeted, or only one per world? Set to true if you would like to allow multiple obsessions at a time.").define("Allow Multiple Targets", false);
        ALLOW_HALLUCINATIONS = BUILDER.comment("Set to false to disable hallucination entities. This includes the bed version, block breaking version, targeter popup, and lightning strike spider version").define("Enable Hallucination Entities", true);
        ALLOW_CREATIVE_TARGET = BUILDER.comment("FALSE by default. If you set this to true, it is recommended to also set Allow Multiple Targets to true. Enables creative/spectator mode players to retain obsessed targeting.").define("Allow Targeting Creative/Spectator Players", false);
        OBSESSED_GRIEFING = BUILDER.comment("Enabled by default. The Obsessed can open wooden doors, replace regular torches with redstone equivalents, and plant wither roses in intruder mode, and break leaves, non-stained glass, and doors when abducting. Plus it places blocks sometimes in the mimicking mode. Set to false to prevent these").define("Allow Obsessed Griefing", true);
        SINGLE_TARGET_INTEREST = BUILDER.comment("If you do not have the above 'allow multiple targets' mode enabled, the obsessed will lose interest after X amount of seconds of its target player not being on the server, or being in a non-overworld dimension continuously. 1200 seconds by default (20 minutes).").define("Seconds before losing interest in single target mode", (Object)1200.0);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

